<?php

namespace App\System\Controller;

use App\System\Basic\beContoller;
use App\System\Basic\beModel;
use App\System\Model\AuthModel;
use App\System\Model\CurrencyModel;
use App\System\Model\LanguageModel;
use App\System\Model\SettingModel;
use App\System\Vendor\beLanguage;
use Sabberworm\CSS\Settings;

class CurrencyController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","list") -> "9101db8b3142404cffbb15d98d4e633a" RANDOM
    public function list(){
        $currencies = CurrencyModel::beGetAll();
        return beGetView("admin.currency.list",["currencies" => $currencies]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","add") -> "693124c9e83f454f57d2e4f611fe1c9c" RANDOM
    public function add(){
        return beGetView("admin.currency.add");
    }
    //@ioncube.dk beEncrypt("be_diyocp","add_post") -> "ffadff297f0a97a2330891c534e5ce93" RANDOM
    public function add_post(){
        beLanguage::beReadLang("currency");
        beLanguage::beReadLang("form");
        $cname = $_POST["cname"];
        $ccode = $_POST["ccode"];
        $cicon = $_POST["cicon"];
        $crate = (double)$_POST["crate"];
        $ctaxrate = (double)$_POST["ctaxrate"];
        if(empty($cname) || empty($ccode)){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        CurrencyModel::beInsert([
            "cname" => $cname,
            "ccode" => $ccode,
            "cicon" => $cicon,
            "crate" => $crate,
            "ctaxrate" => $ctaxrate,
            "cdateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("currency_created"),"url" => beGetRoute("admin.language.list")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit") -> "ef2c86a2f570e9f43db63597a17bf569" RANDOM
    public function edit($cid){
        beLanguage::beReadLang("currency");
        $currency = CurrencyModel::beWhere("cid",$cid)->beGet();
        if(!$currency){
            beError(beGetLang("currency"),beGetLang("currency_not_found"));
        }
        return beGetView("admin.currency.edit",["currency" => $currency]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit_post") -> "612153cbfbd9f0b9015947cac84fe756" RANDOM
    public function edit_post(){
        beLanguage::beReadLang("currency");
        beLanguage::beReadLang("form");
        $cid = (int)$_POST["cid"];
        $currency = CurrencyModel::beSelect("cid")->beWhere("cid",$cid)->beGet();
        if(!$currency){
            return beAjaxError(["message" => beGetLang("currency_not_found")]);
        }
        $cname = $_POST["cname"];
        $ccode = $_POST["ccode"];
        $cicon = $_POST["cicon"];
        $crate = (double)$_POST["crate"];
        $ctaxrate = (double)$_POST["ctaxrate"];
        if(empty($cname) || empty($ccode)){
            return beAjaxError(["message" => beGetLang("form_not_full")]);
        }
        CurrencyModel::beUpdate([
            "cname" => $cname,
            "ccode" => $ccode,
            "cicon" => $cicon,
            "crate" => $crate,
            "ctaxrate" => $ctaxrate,
        ])->beWhere("cid",$currency["cid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("currency_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","default_post") -> "080e8149d99b956520a647f5518b4b07" RANDOM
    public function default_post(){
        beLanguage::beReadLang("currency");
        $cid = (int)$_POST["cid"];
        $currency = CurrencyModel::beSelect("cid")->beWhere("cid",$cid)->beGet();
        if(!$currency){
            return beAjaxError(["message" => beGetLang("currency_not_found")]);
        }
        SettingModel::beUpdate(["svalue" => $currency["cid"]])->beWhere("scode","system_currency")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("currency_defaylt_selected")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","delete_post") -> "f2e13f17daf43cb049e56f8ccb4e3d39" RANDOM
    public function delete_post(){
        beLanguage::beReadLang("currency");
        $cid = (int)$_POST["cid"];
        $currency = CurrencyModel::beSelect("cid")->beWhere("cid",$cid)->beGet();
        if(!$currency){
            return beAjaxError(["message" => beGetLang("currency_not_found")]);
        }
        CurrencyModel::beDelete()->beWhere("cid",$currency["cid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("currency_deleted")]);
    }
}

?>