<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Model\SettingModel;
use App\System\Model\SettingsModel;

class LicenseController extends beContoller {
    public function show(){
        global $be;
        $mainfile = BE_APPPATH."resources/cache/version.json";
        if(!file_exists($mainfile)){
            beError("Bir sorun oluştu!","Yerel sistem dosyası bulunamadı!");
        }
        $license = $be->settings["system_said"].":".$be->settings["system_sacode"];
        $userproduct = $be->settings["system_data"]["product"];
        $system = file_get_contents($mainfile);
        $system = json_decode($system,true);
        $build = $system["build"];
        $version = $system["version"];
        $list = $be->settings["system_data"]["api"]["list"];
        $active = $be->settings["system_data"]["api"]["active"];
        return beGetView("admin.license",["license" => $license,"userproduct" => $userproduct,"build" => $build,"version" => $version,"apis" => $list,"active" => $active]);
    }
    public function edit_post(){
        global $be;
        $settings = $be->settings;
        $itemcount = (int)$_POST["itemCount"];
        $list = [];
        $firtapi = "";
        for($i = 0; $i < $itemcount+1; $i++){
            $rowname = htmlspecialchars($_POST["rowName".$i]);
            if(!$rowname){
                continue;
            }
            $be->settings["system_data"]["api"]["active"] = $rowname;
            $response = ConnectionController::beSendRequestControlPanel([
                "method" => "checkuser",
                "notnext" => true,
                "data" => [
                    "cid" => $settings["system_id"],
                    "ctoken" => $settings["system_token"],
                    "secret" => $settings["system_secret"]
                ]
            ]);
            if(!$response["status"]){
                if(!$response["message"]){
                    $response["message"] = "API şuan erişilebilir durumda değil(DNS,FIREWALL gibi sorunlardan bu sorun olabilir bu adresi silerek diğer API adreslerini kullanınınız!)";
                }
                return beAjaxError(["message" => $rowname." API Adresinen Hata: ".$response["message"]]);
            }
            if(!$firtapi){
                $firtapi = $rowname;
            }
            $list[] = $rowname;
        }
        if(empty($list)){
            return beAjaxError(["message" => "En az bir adet api sunucusunun bulunması gerekiyor!"]);
        }
        $be->settings["system_data"]["api"]["list"] = $list;
        $be->settings["system_data"]["api"]["active"] = $firtapi;
        SettingModel::beUpdate(["svalue" => json_encode($be->settings["system_data"],JSON_UNESCAPED_UNICODE)])->beWhere("scode","system_data")->beExecute();
        return beAjaxSuccess(["message" => "Başarılı bir şekilde api adresleri güncellendi"]);
    }
}

?>