<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Basic\beModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;

class LogController extends beContoller {
    public function system(){
        return beGetView("admin.log.system.list");
    }
    public function system_delete_post(){
        beLanguage::beReadLang("log");
        beModel::beQuery("TRUNCATE TABLE be_system_logs")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("log_deleted")]);
    }
    public function system_search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $user = (int)$_POST["user"];
        $itemsearch = beModel::beTable("be_system_logs")->beSelect("COUNT(slid) as total");
        if($user){
            $itemsearch = $itemsearch->beWhere("uid",$user);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = beModel::beTable("be_system_logs as sl")->beSelect("sl.*,u.name,u.surname");
        if($user){
            $items = $items->beWhere("sl.uid",$user);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "slid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("LEFT JOIN be_users as u ON u.uid = sl.uid")->beGetAll();
        $itemhtml = beGetView("admin.log.system.listrows",["items" => $items]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
    public function module(){
        return beGetView("admin.log.module.list");
    }
    public function module_delete_post(){
        beLanguage::beReadLang("log");
        beModel::beQuery("TRUNCATE TABLE be_module_logs")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("log_deleted")]);
    }
    public function module_search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $upid = (int)$_POST["upid"];
        $itemsearch = beModel::beTable("be_module_logs")->beSelect("COUNT(mlid) as total");
        if($upid){
            $itemsearch = $itemsearch->beWhere("upid",$upid);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = beModel::beTable("be_module_logs as ml")->beSelect("ml.*,up.upname,up.uptag");
        if($upid){
            $items = $items->beWhere("ml.upid",$upid);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "mlid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("LEFT JOIN be_user_products as up ON up.upid = ml.upid")->beGetAll();
        $itemhtml = beGetView("admin.log.module.listrows",["items" => $items]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
    public function user(){
        return beGetView("admin.log.user.list");
    }
    public function user_delete_post(){
        beLanguage::beReadLang("log");
        beModel::beQuery("TRUNCATE TABLE be_user_logs")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("log_deleted")]);
    }
    public function user_search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $user = (int)$_POST["user"];
        $itemsearch = beModel::beTable("be_user_logs")->beSelect("COUNT(lid) as total");
        if($user){
            $itemsearch = $itemsearch->beWhere("uid",$user);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = beModel::beTable("be_user_logs as ul")->beSelect("ul.*,u.name,u.surname");
        if($user){
            $items = $items->beWhere("ul.uid",$user);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "lid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("LEFT JOIN be_users as u ON u.uid = ul.uid")->beGetAll();
        $usercontroller = new UserController();
        $admin = Auth::beGetUser();
        $usercontroller->beSetUserMessages($admin["lid"],$items);
        $itemhtml = beGetView("admin.log.user.listrows",["items" => $items]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
    public function userproduct(){
        return beGetView("admin.log.userproduct.list");
    }
    public function userproduct_delete_post(){
        beLanguage::beReadLang("log");
        beModel::beQuery("TRUNCATE TABLE be_user_product_logs")->beExecute();
        return beAjaxSuccess(["message" => beGetLang("log_deleted")]);
    }
    public function userproduct_search_post(){
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $user = (int)$_POST["user"];
        $upid = (int)$_POST["upid"];
        $itemsearch = beModel::beTable("be_user_product_logs")->beSelect("COUNT(uplid) as total");
        if($user){
            $itemsearch = $itemsearch->beWhere("uid",$user);
        }
        if($upid){
            $itemsearch = $itemsearch->beWhere("upid",$upid);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = beModel::beTable("be_user_product_logs as upl")->beSelect("upl.*,u.name,u.surname,up.upname,up.uptag");
        if($user){
            $items = $items->beWhere("upl.uid",$user);
        }
        if($upid){
            $items = $items->beWhere("upl.upid",$upid);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        $orderkey = "uplid";
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("LEFT JOIN be_users as u ON u.uid = upl.uid LEFT JOIN be_user_products as up ON up.upid = upl.upid")->beGetAll();
        $admin = Auth::beGetUser();
        $ordercontroller = new OrderController();
        $ordercontroller->beSetOrderMessages($admin["lid"],$items);
        $itemhtml = beGetView("admin.log.userproduct.listrows",["items" => $items]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
}

?>