<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Model\AuthModel;
use App\System\Model\InvoiceItemModel;
use App\System\Model\SettingModel;
use App\System\Model\TicketModel;
use App\System\Model\UserProductModel;

class SearchController extends beContoller {
    public function search_post(){
        $limit = (int)$_POST["limit"];
        if(!$limit){
            $limit = 5;
        }
        $term = $_POST["term"];
        $search = [];
        $terms = explode(" ",$term);
        $termcount = count($terms);
        switch($termcount){
            case 1 :
                $userlist = AuthModel::beSelect("uid,name,surname,email")->beWhere("name",$terms[0],"LIKE","||")->beWhere("surname",$terms[0],"LIKE","||")->beWhere("email",$terms[0],"LIKE","||")->beLimit($limit)->beGetAll();
                break;
            case 2 :
                $userlist = AuthModel::beSelect("uid,name,surname,email")->beWhere("name",$terms[0],"LIKE")->beWhere("surname",$terms[1],"LIKE")->beLimit($limit)->beGetAll();
                break;
            case 3 :
                $userlist = AuthModel::beSelect("uid,name,surname,email")->beWhere("name",$terms[0]." ".$terms[1],"LIKE")->beWhere("surname",$terms[2],"LIKE")->beLimit($limit)->beGetAll();
                break;
        }
        $orderlist = UserProductModel::beTable("be_user_products as up")->beSelect("upid,up.upname,up.uptag,up.upstatus,u.uid,u.name,u.surname")->beWhereGroup(function($query) use ($term){
            $query->beWhere("up.upid",$term,"=","||");
            $query->beWhere("up.updata",$term,"LIKE","||");
            $query->beWhere("up.uptag",$term,"LIKE","||");
        })->beJoin("INNER JOIN be_users as u ON u.uid = up.uid")->beOrder("up.upid","DESC")->beLimit($limit)->beGetAll();
        $invoicelist = InvoiceItemModel::beTable("be_invoice_items as ii")->beSelect("i.iid,i.iname,i.istatus,u.uid,u.name,u.surname")->beWhereGroup(function($query) use ($term){
            $query->beWhere("ii.iid",$term,"=","||");
            $query->beWhere("ii.iiobjectid",$term,"LIKE","||");
            $query->beWhere("ii.iiname",$term,"LIKE","||");
        })->beJoin("INNER JOIN be_invoices as i ON i.iid = ii.iid INNER JOIN be_users as u ON u.uid = i.uid")->beOrder("i.iid","DESC")->beLimit($limit)->beGetAll();
        $ticketlist = TicketModel::beTable("be_tickets as t")->beSelect("t.tid,t.tsubject,t.tstatus,u.uid,u.name,u.surname")->beWhere("t.tsubject",$term,"LIKE")->beJoin("INNER JOIN be_users as u ON u.uid = t.uid")->beOrder("t.tid","DESC")->beLimit($limit)->beGetAll();
        $settinglist = SettingModel::beTable("be_settings as s")->beSelect("s.sid,s.sgid,s.sname")->beWhere("s.sname",$term,"LIKE")->beLimit($limit)->beGetAll();
        $found = false;
        if($userlist){
            $found = true;
            foreach($userlist as $user){
                $search["users"][] = $user;
            }
        }
        if($orderlist){
            $found = true;
            foreach($orderlist as $order){
                $search["orders"][] = $order;
            }
        }
        if($invoicelist){
            $found = true;
            foreach($invoicelist as $invoice){
                $search["invoices"][] = $invoice;
            }
        }
        if($ticketlist){
            $found = true;
            foreach($ticketlist as $ticket){
                $search["tickets"][] = $ticket;
            }
        }
        if($settinglist){
            $found = true;
            foreach($settinglist as $setting){
                $search["settings"][] = $setting;
            }
        }
        return json_encode(["found" => $found,"search" => $search],JSON_UNESCAPED_UNICODE);
    }
}