<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Model\AttachmentModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;
use App\System\Vendor\beUpload;

class UploadController extends beContoller {
    public function upload(){
        beLanguage::beReadLang("upload");
        $user = Auth::beGetUser();
        $file = $_FILES["file"];
        if(!$file){
            return beAjaxError(["message" => beGetLang("file_empty")]);
        }
        $name = $file["name"];
        $slug = beSelfLink($name);
        $secretname = date("m.Y",BE_TIME)."-".substr(md5(BE_TIME),0,8)."-"."berk.diyo";
        $upload = beUpload::beUploadFile($file,$secretname,BE_APPPATH."resources/upload",0,[],false);
        if(!$upload["status"]){
            return beAjaxError(["message" => $upload["message"]]);
        }
        $aid = AttachmentModel::beInsert([
            "uid" => $user["uid"],
            "aname" => $name,
            "aslug" => $slug,
            "atype" => $file["type"],
            "asize" => $file["size"],
            "apath" => "resources/upload/".$upload["filename"],
            "aviews" => 0,
            "adownloads" => 0,
            "astatus" => "1",
            "afavorite" => "0",
            "apassword" => "",
            "adateline" => BE_TIME
        ]);
        return beAjaxSuccess(["message" => beGetLang("file_uploaded_successfully"),"aid" => $aid]);
    }
    public function delete(){
        beLanguage::beReadLang("upload");
        $user = Auth::beGetUser();
        $aid = (int)$_POST["aid"];
        $file = AttachmentModel::beSelect("aid,apath")->beWhere("aid",$aid)->beWhere("uid",$user["uid"])->beGet();
        if(!$file){
            return beAjaxError(["message" => beGetLang("file_not_found")]);
        }
        unlink(BE_APPPATH.$file["apath"]);
        AttachmentModel::beDelete()->beWhere("aid",$file["aid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("file_deleted_successfully")]);
    }
    public function show($slug = "",$aid = 0){
        beLanguage::beReadLang("upload");
        $attachment = AttachmentModel::beSelect("aid,aname,atype,asize,apath,aviews,adownloads")->beWhere("aid",$aid)->beWhere("aslug",$slug)->beGet();
        if(!$attachment){
            beError("Bulunamadı",beGetLang("file_not_found"));
        }
        $this->showcontent($attachment);
    }
    public function showspecial($aid = 0){
        beLanguage::beReadLang("upload");
        $user = Auth::beGetUser();
        $attachment = AttachmentModel::beSelect("aid,aname,atype,asize,apath,aviews,adownloads")->beWhere("aid",$aid)->beWhere("uid",$user["uid"])->beGet();
        if(!$attachment){
            beError("Bulunamadı",beGetLang("file_not_found"));
        }
        $this->showcontent($attachment);
    }
    public function showcontent($attachment){
        if($_GET["action"] != "download"){
            switch($attachment["atype"]){
                case "application/pdf":
                case "image/bmp":
                case "image/gif":
                case "image/webp":
                case "image/jpeg":
                case "image/pjpeg":
                case "image/png":
                case "text/html":
                    header("Content-type: {$attachment['atype']}");
                    $disposition = "inline";
                    break;
                default:
                    $filetype = $attachment["atype"];
                    if(!$filetype){
                        $filetype = "application/force-download";
                    }
                    header("Content-type: {$filetype}");
                    $disposition = "attachment";
                    break;
            }  
        }
        else{
            $filetype = "application/force-download";
            header("Content-type: {$filetype}");
            $disposition = "attachment";		
        }
        if(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]),"msie") !== false){
            header("Content-disposition: attachment; filename=\"{$attachment['aname']}\"");
        }
        else{
            header("Content-disposition: {$disposition}; filename=\"{$attachment['aname']}\"");
        }
        if(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]),"msie 6.0") !== false){
            header("Expires: -1");
        }
        header("Content-length: {$attachment['asize']}");
        header("Content-range: bytes=0-".($attachment["asize"]-1)."/".$attachment["asize"]);
        $filehandle = fopen(BE_APPPATH.$attachment["apath"],"rb");
        while(!feof($filehandle)){
            echo fread($filehandle,8192);
        }
        fclose($filehandle);
        if($disposition == "attachment"){
            AttachmentModel::beUpdate(["adownloads" => $attachment["adownloads"]+1])->beWhere("aid",$attachment["aid"])->beExecute();
        }
        else{
            AttachmentModel::beUpdate(["aviews" => $attachment["aviews"]+1])->beWhere("aid",$attachment["aid"])->beExecute();
        }
        exit;
    }
}

?>