<?php

namespace App\System\Module;

use App\System\Controller\NavController;
use App\System\Model\CurrencieModel;
use App\System\Model\ModuleLogModel;
use App\System\Model\ProductModel;
use App\System\Model\UserProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\Basic\beCookie;
use App\System\Vendor\beLanguage;

class hetznerdedicated {
    public $options = [
        "isneedserver" => true
    ];
    public $pages = [
        "/" => [
            "showmenu" => true,
            "name" => "Ana Sayfa",
            "icon" => "<i class=\"ri-home-line\"></i>"
        ]
    ];
    public function hetznerdedicated_info(){
        return [
            "name" => "Hetzner Dedicated",
            "description" => "Hetzner ile gerekli bağlantıyı kurup Dedicated sunucu için otomasyon sağlar",
            "version" => "1.0",
            "vercode" => 10,
            "type" => "server",
            "author" => "ITenGriTR"
        ];
    }
    public function hetznerdedicated_connection_test($params = []){
        $response = $this->beSendApiRequest([
            "apiurl" => $params["surl"],
            "method" => "checkuser",
            "data" => [
                "login_username" => $params["susername"],
                "login_password" => $params["spassword"]
            ]
        ]);
        if(!$response["status"]){
            return ["status" => false,"message" => $response["message"]];
        }
        return ["status" => true];
    }
    public function hetznerdedicated_order_config(){
        return [
            "server_number" => [
                "name" => "Server ID",
                "description" => "Kullanıcının yöneteceği sunucunun panel üzerindeki değerini giriniz(Server ID)",
                "type" => "integer",
                "default" => ""
            ]
        ];
    }
    public function hetznerdedicated_product_config($params = []){
        return [        
            "productname" => [
                "name" => "Ürün Adı",
                "description" => "Verilecek olan sunucu ürününün adını giriniz",
                "type" => "string",
                "default" => ""
            ],
            "location" => [
                "name" => "Lokasyon",
                "description" => "Verilecek olan sunucunun lokasyonunu seçiniz",
                "type" => "select",
                "default" => "",
                "form-view" => [
                    "class" => "col-6 col-md-12" 
                ],
                "values" => [
                    "random" => "Rastgele",
                    "fsn1" => "Falkenstein",
                    "nbg1" => "Nuremberg",
                    "hel1" => "Helsinki",
                    "ash" => "Ashburn, VA",
                    "hil" => "Hillsboro, OR",
                ]
            ]
        ];
    }
    public function hetznerdedicated_create($params = []){
        $server = $params["server"];
        $userproduct = $params["userproduct"];
        $productmodules = $params["productmodules"];
        $updata = json_decode($userproduct["updata"],true);
        $dist = "";
        if($productmodules["location"] != "random"){
            $dist = $productmodules["location"];
        }
        $siteshortname = strtolower(str_replace(" ","",beGetConfig("siteshortname")));
        $password = "N".substr(md5(rand(0,1000).$userproduct["upid"].rand(0,1000)),0,10)."!@".$siteshortname;
        $updata = [
            "password" => beEncryptData($password),
        ];
        $response = $this->beSendApiRequest([
            "apiurl" => $server["surl"],
            "method" => "buy_dedicatedserver",
            "data" => [
                "productname" => $productmodules["productname"],
                "password" => $password,
                "dist" => $dist,
                "login_username" => $server["susername"],
                "login_password" => $server["spassword"]
            ]
        ]);
        if(!$response["status"]){
            ModuleLogModel::beCreateModuleLog($userproduct["upid"],"hetznerdedicated","Kurulum Hatası","Kurulum esnasında bir sorun oluştu!",[
                "response" => $response
            ]);
            return ["status" => false,"message" => "Sunucu kurulumunda bir sorun oluştu lütfen yönetici ile iletişime geçiniz."];
        }
        switch($response["transaction"]["status"]){
            case "ready" :
                $updata["transaction_id"] = $response["transaction"]["id"];
                $updata["transaction_status"] = "ready";
                $updata["server_number"] = $response["transaction"]["server_number"];
                $updata["server_ip"] = $response["transaction"]["server_ip"];
                $updatedata["uptag"] = $response["transaction"]["server_ip"];
                break;
            case "in process" :
                $updata["transaction_id"] = $response["transaction"]["id"];
                $updata["transaction_status"] = "in process";
                break;
        }
        $activisioninfo = "Reference number: {$updata['transaction_id']}\n\nYour order:\n\n 1 x Server Auction\n".implode("\n*",$response["transaction"]["product"]["description"]);
        $updatedata["updata"] = json_encode($updata,JSON_UNESCAPED_UNICODE);
        UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
        return [
            "status" => true,
            "message" => "Ürün yönetim paneline yönlendiliriliyorsunuz",
            "url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]]),
            "activisioninfo" => $activisioninfo
        ];
    }
    public function hetznerdedicated_manage($params = []){
        $userproduct = $params["userproduct"];
        beCookie::beCreateCookie("be_upid",$userproduct["upid"],true,true);
        return ["status" => true,"message" => "Ürün yönetim paneline yönlendiliriliyorsunuz","url" => beGetRoute("client.userproduct.userproduct.show",["upid" => $userproduct["upid"]])];
    }
    public function hetznerdedicated_extend($params = []){
        return ["status" => true];
    }
    public function hetznerdedicated_terminate($params = []){
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $params["server"]["surl"],
            "method" => "terminate_market_server",
            "data" => [
                "server_number" => $updata["server_number"],
                "login_username" => $params["server"]["susername"],
                "login_password" => $params["server"]["spassword"]
            ]
        ]);
        if(!$response["status"]){
            return ["status" => false,"message" => "Silme işlemi esnasında bir sorun oluştu. ".$response["message"]];
        }
        return ["status" => true,"message" => "Başarılı bir şekilde sipariş modül üzerinde silindi!"];
    }
    public function hetznerdedicated_clientarea($params = []){
        beLanguage::beReadLang("hetznerdedicated");
        $server = $params["server"];
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        if($updata["transaction_status"] == "in process"){
            $response = $this->beSendApiRequest([
                "apiurl" => $server["surl"],
                "method" => "get_market_transaction",
                "data" => [
                    "transaction_id" => $updata["transaction_id"],
                    "login_username" => $server["susername"],
                    "login_password" => $server["spassword"]
                ]
            ]);
            if(!$response["status"]){
                return beAjaxError(["message" => "Sunucu üzerinde başlatma komutu gönderilirken bir sorun oluştu"]);
            }
            switch($response["transaction"]["status"]){
                case "in process" :
                    return [
                        "status" => true,
                        "title" => "Sunucuyu Yönetimi",
                        "content" => beGetView("modules.hetznerdedicated.creating")
                    ];
                    break;
                case "ready" :
                    $updata["transaction_id"] = $response["transaction"]["id"];
                    $updata["transaction_status"] = "ready";
                    $updata["server_number"] = $response["transaction"]["server_number"];
                    $updata["server_ip"] = $response["transaction"]["server_ip"];
                    $updatedata["uptag"] = $response["transaction"]["server_ip"];
                    $updatedata["updata"] = json_encode($updata,JSON_UNESCAPED_UNICODE);
                    UserProductModel::beUpdate($updatedata)->beWhere("upid",$userproduct["upid"])->beExecute();
            }
        }
        if(!$updata["server_ip"]){
            $response = $this->beSendApiRequest([
                "apiurl" => $server["surl"],
                "method" => "get_market_server",
                "data" => [
                    "server_number" => $updata["server_number"],
                    "login_username" => $server["susername"],
                    "login_password" => $server["spassword"]
                ]
            ]);
            if(!$response["status"]){
                return beAjaxError(["message" => "Sunucu üzerinde başlatma komutu gönderilirken bir sorun oluştu"]);
            }
            $updata["server_ip"] = $response["server"]["server_ip"];
            UserProductModel::beUpdate(["updata" => json_encode($updata,JSON_UNESCAPED_UNICODE)])->beWhere("upid",$userproduct["upid"])->beExecute();
        }
        $server = [
            "server_ip" => $updata["server_ip"],
            "password" => beDecryptData($updata["password"])
        ];
        return [
            "status" => true,
            "title" => "Sunucuyu Yönetimi",
            "content" => beGetView("modules.hetznerdedicated.server",[
                "server" => $server,
                "userproduct" => $userproduct
            ])
        ];
    }
    public function hetznerdedicated_wake_on_lan($params){
        beLanguage::beReadLang("hetznerdedicated");
        $server = $params["server"];
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $server["surl"],
            "method" => "wakeonlan_market_server",
            "data" => [
                "server_number" => $updata["server_number"],
                "login_username" => $server["susername"],
                "login_password" => $server["spassword"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => "Sunucu üzerinde başlatma komutu gönderilirken bir sorun oluştu"]);
        }
        return beAjaxSuccess(["message" => "Başarılı bir şekilde sunucu üzerinde başlatma komutu uygulandı"]);
    }
    public function hetznerdedicated_restart($params){
        beLanguage::beReadLang("hetznerdedicated");
        $server = $params["server"];
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $server["surl"],
            "method" => "restart_market_server",
            "data" => [
                "server_number" => $updata["server_number"],
                "login_username" => $server["susername"],
                "login_password" => $server["spassword"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => "Sunucu üzerinde yeniden başlatma komutu gönderilirken bir sorun oluştu"]);
        }
        return beAjaxSuccess(["message" => "Başarılı bir şekilde sunucu üzerinde yeniden başlatma komutu uygulandı"]);
    }
    public function hetznerdedicated_rescue($params){
        beLanguage::beReadLang("hetznerdedicated");
        $server = $params["server"];
        $userproduct = $params["userproduct"];
        $updata = json_decode($userproduct["updata"],true);
        $response = $this->beSendApiRequest([
            "apiurl" => $server["surl"],
            "method" => "rescue_market_server",
            "data" => [
                "server_number" => $updata["server_number"],
                "login_username" => $server["susername"],
                "login_password" => $server["spassword"]
            ]
        ]);
        if(!$response["status"]){
            return beAjaxError(["message" => "Sunucu üzerinde yeniden başlatma komutu gönderilirken bir sorun oluştu"]);
        }
        $updata["password"] = beEncryptData($response["password"]);
        UserProductModel::beUpdate(["updata" => json_encode($updata,JSON_UNESCAPED_UNICODE)])->beWhere("upid",$userproduct["upid"])->beExecute();
        return beAjaxSuccess(["message" => "Başarılı bir şekilde sunucu rescue moduna alındı","refresh" => 1]);
    }
    public function beSendApiRequest($data = []){
        global $be;
        $settings = $be->settings;
        $data["data"] = array_merge($data["data"],[
            "cid" => $settings["system_id"],
            "ctoken" => $settings["system_token"],
            "secret" => $settings["system_secret"],
            "acces_token" => substr(md5($settings["system_id"].BE_TIME),0,8),
            "time" => BE_TIME
        ]);
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,"https://{$data['apiurl']}/api/hetznerdedicated/{$data['method']}");
        curl_setopt($ch,CURLOPT_POST,1);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($data["data"]));
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response,true);
    }
}