<?php
    namespace App\System\Plugin;
    use App\System\Basic\beModel;
    use App\System\Basic\beRouter;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;
    use App\System\Vendor\Auth;
    use App\System\Vendor\beModule;
    use App\System\Vendor\bePlugin;

    class livesupport {
        public function plugin_info(){
            return [
                "name" => "Canlı Destek",
                "description" => "Sisteminizde canlı destek sistemini düzenleyerek daha düzgün çalışmasını sağlar",
                "version" => "1.0",
                "vercode" => 1,
                "author" => "ITenGriTR"
            ];
        }
        public function plugin_hooks(){
            return [
                "template_preparation_footer" => "my_template_preparation_footer"
            ];
        }
        public function plugin_settings(){
            $settinggroup = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","livesupport")->beGet();
            return ["status" => true,"url" => beGetRoute("admin.settings.settinggroup.show",["sgid" => $settinggroup["sgid"]])];
        }
        public function plugin_install(){
            $sgid = bePlugin::beCreateSettingGroup("livesupport","Canlı Destek Ayarları","Canlı destek sistemi için özelliştirmeleri yapmanızı sağlar");
            bePlugin::beCreateSetting($sgid,"livesupport_status","Durum","Canlı destek sisteminin durumunu belirler","select\n0=Kapalı\n1=Açık\n2=Saat Modu","0");
            bePlugin::beCreateSetting($sgid,"livesupport_user_status","Müşteri Seçimi","Canlı destek sisteminin kimlere gözükeceğini belirler","select\n0=Herkese\n1=Ziyaretçilere\n2=Müşterilere","0");
            bePlugin::beCreateSetting($sgid,"livesupport_time_start","Başlangıç Saati(0-24)","Saat modundayken canlı desteğin gözükmeye başlayacağı saati belirleyiniz.","int","");
            bePlugin::beCreateSetting($sgid,"livesupport_time_end","Bitiş Saati(0-24)","Saat modundayken canlı desteğin kapanacağı saati belirleyiniz.","int","");
            bePlugin::beCreateSetting($sgid,"livesupport_javascript","JavaScript Kodu","Kullanacağınız canlı destek sisteminin JavaScript kodunu ekleyiniz.","str","");
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
        }
        public function plugin_remove(){
            $sgid = SettingGroupsModel::beSelect("sgid")->beWhere("sgcode","livesupport")->beGet()["sgid"];
            SettingGroupsModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            SettingModel::beDelete()->beWhere("sgid",$sgid)->beExecute();
            return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
        }
        public static function my_template_preparation_footer($data = []){
            $settings = SettingModel::beGetSettings("livesupport_status,livesupport_user_status,livesupport_time_start,livesupport_time_end,livesupport_javascript");
            switch($settings["livesupport_status"]){
                case 0 :
                    return $data;
                    break;
                case 2 :
                    $hour = date("H",BE_TIME);
                    $start = (int)$settings["livesupport_time_start"];
                    $end = (int)$settings["livesupport_time_end"];
                    $inrage = false;
                    if($start < $end){
                        if($hour >= $start && $hour < $end){
                            $inrage = true;
                        }
                    } 
                    else{
                        if($hour >= $start || $hour < $end){
                            $inrage = true;
                        }
                    }
                    if (!$inrage) {
                        return $data;
                    }
                    break;
            }
            $user = Auth::beGetUser();
            switch($settings["livesupport_user_status"]){
                case 1 :
                    if($user["uid"]){
                        return $data;
                    }
                    break;
                case 2 :
                    if(!$user["uid"]){
                        return $data;
                    }
                    break;
            }
            $data["footer"] = $settings["livesupport_javascript"].$data["footer"];
            return $data;
        }
    }

?>