@extend('admin.layout')
@section('headerinclude')
<title>Banka Hesabı Ekle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Banka Hesabı Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="bankForm">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Banka Adı</label>
                            <input type="text" class="form-control" name="bname">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Hesap Sahibi</label>
                            <input type="text" class="form-control" name="buser">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Banka Açıklaması</label>
                            <input type="text" class="form-control" name="bdescription">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Hesap Iban</label>
                            <input type="text" class="form-control" name="biban">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Banka Resim</label>
                            <input type="file" class="form-control" name="file">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addBank">Ekle</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".addBank").on("click",function(){
        if(!wait){
            $(".addBank").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.accounting.bank.add.post') }}",
                type: "post",
                async: true,
                data: new FormData($("#bankForm")[0]),
                dataType: "json",
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function(response){
                    $(".addBank").html("Ekle");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection