@extend('admin.layout')
@section('headerinclude')
<title>Periyodik İşlemler</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="{{ beGetRoute('admin.accounting.periodic.list') }}" class="d-inline-flex align-items-center btn btn-primary mb-5">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Periyodik İşlemler
            </a>
            <button type="button" class="d-inline-flex align-items-center btn btn-primary mb-5 mx-3" data-bs-toggle="modal" data-bs-target="#beNewFinance">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Giriş Ekle
            </button>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">İşlem Adı</label>
                        <input type="text" class="form-control" id="searchAccountingName" placeholder="Aramak istediğiniz muhasebe işleminin adını giriniz">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Tip</label>
                        <select class="form-control form-control-select" id="searchAccountingStatus">
                            <option value="all">Hepsi</option>
                            <option value="expense">Gider</option>
                            <option value="income">Gelir</option>
                        </select>
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Başlangıç Vakti</label>
                        <input type="datetime-local" class="form-control" id="searchAccountingStartDate" value="{{ date('Y-m-d\T00:00',strtotime('first day of this month')) }}">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Bitiş Vakti</label>
                        <input type="datetime-local" class="form-control" id="searchAccountingEndDate" value="{{ date('Y-m-d\TH:i',BE_TIME) }}">
                    </div>
                    <div class="col-2">
                        <label class="fs-6 fw-semibold mb-2">Sıralama Türü</label>
                        <select class="form-control form-control-select" id="searchAccountingSort">
                            <option value="1">Sondan Başa</option>
                            <option value="2">Baştan Sona</option>
                        </select>
                    </div>
                    <div class="col-12 d-flex justify-content-center mt-5">
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFind btn-primary mx-2">
                            <i class="fonticon-equalizer fs-4 me-1"></i>
                            Ara
                        </a>
                        <a data-bs-toggle="tooltip" href="#" class="btn btnFindEmpty btn-warning mx-2">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>
                            Temizle
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-3">
                <div class="card bg-light-warning card-xl-stretch mb-xl-8">
                    <div class="card-body my-3">
                        <span class="card-title fw-bold text-warning fs-5 mb-3 d-block">Kasa Durumu</span>
                        <div class="py-1">
                            <span class="text-dark fs-1 fw-bold me-2"><span id="financeTotal">0.0</span>{{ $systemcurrency['cicon'] }}</span>
                            <span class="fw-semibold text-muted fs-7">{{ $systemcurrency['cname'] }}</span>
                        </div>
                        <span class="fw-semibold text-muted fs-7">Bu veri <span class="dayCount">0</span> günün gelir ve giderine göre hesaplanmıştır.</span>
                    </div>
                </div>
            </div>
            <div class="col-xl-3">
                <div class="card bg-light-success card-xl-stretch mb-xl-8">
                    <div class="card-body my-3">
                        <span class="card-title fw-bold text-success fs-5 mb-3 d-block">Gelir</span>
                        <div class="py-1">
                            <span class="text-dark fs-1 fw-bold me-2"><span id="incomeTotal">0.0</span>{{ $systemcurrency['cicon'] }}</span>
                            <span class="fw-semibold text-muted fs-7">{{ $systemcurrency['cname'] }}</span>
                        </div>
                        <span class="fw-semibold text-muted fs-7">Bu veri <span class="dayCount">0</span> günün gelirine göre hesaplanmıştır.</span>
                    </div>
                </div>
            </div>
            <div class="col-xl-3">
                <div class="card bg-light-danger card-xl-stretch mb-xl-8">
                    <div class="card-body my-3">
                        <span class="card-title fw-bold text-danger fs-5 mb-3 d-block">Gider</span>
                        <div class="py-1">
                        <span class="text-dark fs-1 fw-bold me-2"><span id="expenseTotal">0.0</span>{{ $systemcurrency['cicon'] }}</span>
                            <span class="fw-semibold text-muted fs-7">{{ $systemcurrency['cname'] }}</span>
                        </div>
                        <span class="fw-semibold text-muted fs-7">Bu veri <span class="dayCount">0</span> günün giderine göre hesaplanmıştır.</span>
                    </div>
                </div>
            </div>
            <div class="col-xl-3">
                <div class="card bg-light-info card-xl-stretch mb-xl-8">
                    <div class="card-body my-3">
                        <span class="card-title fw-bold text-info fs-5 mb-3 d-block">Ortalama Veriler</span>
                        <div class="py-1">
                            <span class="text-dark fs-1 fw-bold me-2"><span id="moneyPerDay">0.0</span>{{ $systemcurrency['cicon'] }}</span>
                            <span class="fw-semibold text-muted fs-7">Günlük Ortalama Gelir</span>
                        </div>
                        <div class="py-1">
                            <span class="text-dark fs-1 fw-bold me-2"><span id="monthMoney">0.0</span>{{ $systemcurrency['cicon'] }}</span>
                            <span class="fw-semibold text-muted fs-7">Ay Sonu Tahmini Gelir</span>
                        </div>
                        <span class="fw-semibold text-muted fs-7">Bu veriler <span class="dayCount">0</span> günün gelirine göre hesaplanmıştır.</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="alert alert-warning d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor"></rect>
                    <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor"></path>
                </svg>
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-warning">Toplam İşlem Adedi</h4>
                <span id="accountingCount"></span>
            </div>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">İşlem</th>
                            <th class="text-center align-middle">Tür</th>
                            <th class="text-center align-middle">Miktar</th>
                            <th class="text-center align-middle">Tarih</th>
                        </tr>
                    </thead>
                    <tbody id="accountingList">

                    </tbody>
                </table>
            </div>
        </div>
        <div class="card mb-4">
            <div class="card-body">
                <div class="row" id="paganation">
                    
                </div>
            </div>
        </div>
        <div class="modal fade" id="beNewFinance" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered mw-650px">
                <div class="modal-content">
                    <form class="form" id="financeForm">
                        <div class="modal-header">
                            <h2 class="fw-bold">Yeni Giriş Ekle</h2>
                            <div class="btn btn-icon btn-sm btn-active-icon-primary" data-bs-dismiss="modal">
                                <span class="svg-icon svg-icon-1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="currentColor"/>
                                        <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="currentColor"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <div class="modal-body py-10 px-lg-17">
                            <div class="d-flex flex-column scroll-y me-n7 pe-7" id="kt_modal_update_user_scroll" data-kt-scroll="true" data-kt-scroll-activate="{default: false, lg: true}" data-kt-scroll-max-height="auto" data-kt-scroll-dependencies="#kt_modal_update_user_header" data-kt-scroll-wrappers="#kt_modal_update_user_scroll" data-kt-scroll-offset="300px">
                                <div class="collapse show">
                                    <div class="row mb-7">
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">İşlem</label>
                                            <input type="text" class="form-control form-control-solid" name="name">
                                        </div>
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Tarih</label>
                                            <input type="datetime-local" class="form-control form-control-solid" name="time" value="{{ date('Y-m-d\TH:i',BE_TIME) }}">
                                        </div>
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Tutar</label>
                                            <input type="text" class="form-control form-control-solid" name="total">
                                        </div>
                                        <div class="col-md-6 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Para Birimi</label>
                                            <select class="form-control form-control-select" name="currencie">
                                                @foreach($currencies as $currencie)
                                                    <option value="{{ $currencie['cid'] }}"{{ $systemcid == $currencie['cid'] ? ' selected':'' }}>{{ $currencie['cname'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-12">
                                            <label class="fs-6 fw-semibold mb-2">Türü</label>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="radio" name="type" value="income" id="beAddMoney" checked="checked" />
                                                        <label class="form-check-label" for="beAddMoney">
                                                            Giriş
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="radio" name="type" value="expense" id="beRemoveMoney"/>
                                                        <label class="form-check-label" for="beRemoveMoney">
                                                            Çıkış
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer flex-center">
                            <button type="reset" class="btn btn-light me-3" data-bs-dismiss="modal">
                                İptal
                            </button>
                            <button class="btn btn-primary financeSaveForm">Ekle</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var page = 1;
    $(".btnFind").on("click",function(){
        var name = $("#searchAccountingName").val();
        var status = $("#searchAccountingStatus").val();
        var start = $("#searchAccountingStartDate").val();
        var end = $("#searchAccountingEndDate").val();
        var sort = $("#searchAccountingSort").val();
        if(!sort){
            sort = 0;
        }
        beSearchAccounting(name,status,start,end,sort);
        return false;
    });
    $(".btnFindEmpty").on("click",function(){
        $("#searchAccountingName").val("");
        $("#searchAccountingStatus option:first").attr("selected","selected");
        $("#searchAccountingStartDate").val("");
        $("#searchAccountingEndDate").val("");
        $("#searchAccountingSort option:first").attr("selected","selected");
        beSearchAccounting("","all","","",0);
        return false;
    });
    $("#paganation").on("click",".goPaganation",function(){
        page = parseInt($(this).data("page"));
        $(".btnFind").trigger("click");
        return false;
    });
    $(document).ready(function(){
        var start = $("#searchAccountingStartDate").val();
        var end = $("#searchAccountingEndDate").val();
        beSearchAccounting("","all",start,end,0);
    });
    function beSearchAccounting(name,status,start,end,sort){
        $.ajax({
            url: "{{ beGetRoute('admin.accounting.search.post') }}",
            type: "post",
            data: {name:name,status:status,start:start,end:end,sort:sort,page:page},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#paganation").empty().append(response.paganation);
                    $("#accountingList").empty().append(response.html);
                    $("#financeTotal").empty().append(response.financetotal);
                    $("#incomeTotal").empty().append(response.incomemoneytotal);
                    $("#expenseTotal").empty().append(response.expensemoneytotal);
                    $("#moneyPerDay").empty().append(response.moneyperday);
                    $("#monthMoney").empty().append(response.monthmoney);
                    $(".dayCount").empty().append(response.daycount);
                    $("#accountingCount").empty().append(response.accountingcount+" Adet");
                    $(".form-control-select").select2();
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
    var wait1 = false;
    $(".financeSaveForm").on("click",function(){
        if(!wait1){
            wait1 = true;
            $(".financeSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.accounting.add.post') }}",
                type: "post",
                async: true,
                data: $("#financeForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait1 = false;
                    $(".financeSaveForm").html("Ekle");
                    $("#beNewFinance").modal("hide");
                    if(response.status){
                        setTimeout(function(){
                            location.reload();
                        },1000);
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection