@extend('laylout')
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card">
            <div class="card-body p-lg-15">
                <div class="d-flex flex-column flex-lg-row">
                    <div class="flex-column flex-lg-row-auto w-100 w-lg-275px mb-10 me-lg-20">
                        <div class="mb-15">
                            <h4 class="text-dark mb-7">Kategoriler</h4>
                            <div class="menu menu-rounded menu-column menu-title-gray-700 menu-state-title-primary menu-active-bg-light-primary fw-semibold">
                                <div class="menu-item mb-1">
                                    <a href="#" class="menu-link py-3 tabmenu active" data-tab="security">Güvenlik Modülleri</a>
                                </div>
                                <div class="menu-item mb-1">
                                    <a href="#" class="menu-link py-3 tabmenu" data-tab="server">Sunucu Modülleri</a>
                                </div>    
                                <div class="menu-item mb-1">
                                    <a href="#" class="menu-link py-3 tabmenu" data-tab="rdns">rDns Modülleri</a>
                                </div>
                                <div class="menu-item mb-1">
                                    <a href="#" class="menu-link py-3 tabmenu" data-tab="ads">Reklam Modülleri</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-lg-row-fluid">
                        <div id="security">
                            <div class="row">
                                @foreach($applications as $application)
                                @if($application['akey'] != 'security')
                                    @php continue; @endphp
                                @endif
                                <div class="col-xl-6 mb-xl-10">
                                    <div class="card bg-light">
                                        <div class="card-header pt-6">
                                            <h4 class="card-title d-flex align-items-start flex-column">
                                                <span class="card-label fw-bold text-gray-800">{{ $application['aname'] }}</span>
                                            </h4>
                                        </div>
                                        <div class="card-body pt-6">
                                            <div class="d-flex align-items-center mb-10">
                                                <img src="https://sc1.diyosoftware.com/assets/diyovm/logos/{{ $application['aimage'] }}?v=10" alt="{{ $application['aname'] }}" style="width:100px;height:80px">
                                            </div>
                                            <div class="d-flex align-items-center mb-5">
                                                <div class="m-0">
                                                    <h4 class="fw-bold text-gray-800 mb-3">Özellikler</h4>
                                                    <div>
                                                        @php $aaddons = json_decode($application['aaddons'],true) @endphp
                                                        @foreach($aaddons as $addon)
                                                        <span class="d-block fs-7 fw-bold text-gray-600 mb-2">
                                                            <span class="svg-icon svg-icon-6 svg-icon-gray-600 me-2">
                                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                                                    <path d="M11.9343 12.5657L9.53696 14.963C9.22669 15.2733 9.18488 15.7619 9.43792 16.1204C9.7616 16.5789 10.4211 16.6334 10.8156 16.2342L14.3054 12.7029C14.6903 12.3134 14.6903 11.6866 14.3054 11.2971L10.8156 7.76582C10.4211 7.3666 9.7616 7.42107 9.43792 7.87962C9.18488 8.23809 9.22669 8.72669 9.53696 9.03696L11.9343 11.4343C12.2467 11.7467 12.2467 12.2533 11.9343 12.5657Z" fill="currentColor"></path>
                                                                </svg>
                                                            </span>
                                                            {{ $addon }}
                                                        </span>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-5">
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Version: v-{{ $application['aversioncode'] }}</span>
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Oluşturulma: {{ date('d.m.Y',$application['adateline']) }}</span>
                                            </div>
                                            <div class="mb-1">
                                                <a href="{{ beGetRoute('client.application.show',['slug' => $application['aslug']]) }}" class="btn btn-sm btn-primary">İncele</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        <div id="server" style="display:none">
                            <div class="row">
                                @foreach($applications as $application)
                                @if($application['akey'] != 'server')
                                    @php continue; @endphp
                                @endif
                                <div class="col-xl-6 mb-xl-10">
                                    <div class="card bg-light">
                                        <div class="card-header pt-6">
                                            <h4 class="card-title d-flex align-items-start flex-column">
                                                <span class="card-label fw-bold text-gray-800">{{ $application['aname'] }}</span>
                                            </h4>
                                        </div>
                                        <div class="card-body pt-6">
                                            <div class="d-flex align-items-center mb-10">
                                                <img src="https://sc1.diyosoftware.com/assets/diyovm/logos/{{ $application['aimage'] }}?v=10" alt="{{ $application['aname'] }}" style="width:100px;height:80px">
                                            </div>
                                            <div class="d-flex align-items-center mb-5">
                                                <div class="m-0">
                                                    <h4 class="fw-bold text-gray-800 mb-3">Özellikler</h4>
                                                    <div>
                                                        @php $aaddons = json_decode($application['aaddons'],true) @endphp
                                                        @foreach($aaddons as $addon)
                                                        <span class="d-block fs-7 fw-bold text-gray-600 mb-2">
                                                            <span class="svg-icon svg-icon-6 svg-icon-gray-600 me-2">
                                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                                                    <path d="M11.9343 12.5657L9.53696 14.963C9.22669 15.2733 9.18488 15.7619 9.43792 16.1204C9.7616 16.5789 10.4211 16.6334 10.8156 16.2342L14.3054 12.7029C14.6903 12.3134 14.6903 11.6866 14.3054 11.2971L10.8156 7.76582C10.4211 7.3666 9.7616 7.42107 9.43792 7.87962C9.18488 8.23809 9.22669 8.72669 9.53696 9.03696L11.9343 11.4343C12.2467 11.7467 12.2467 12.2533 11.9343 12.5657Z" fill="currentColor"></path>
                                                                </svg>
                                                            </span>
                                                            {{ $addon }}
                                                        </span>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-5">
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Version: v-{{ $application['aversioncode'] }}</span>
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Oluşturulma: {{ date('d.m.Y',$application['adateline']) }}</span>
                                            </div>
                                            <div class="mb-1">
                                                <a href="{{ beGetRoute('client.application.show',['slug' => $application['aslug']]) }}" class="btn btn-sm btn-primary">İncele</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        <div id="rdns" style="display:none">
                            <div class="row">
                                @foreach($applications as $application)
                                @if($application['akey'] != 'rdns')
                                    @php continue; @endphp
                                @endif
                                <div class="col-xl-6 mb-xl-10">
                                    <div class="card bg-light">
                                        <div class="card-header pt-6">
                                            <h4 class="card-title d-flex align-items-start flex-column">
                                                <span class="card-label fw-bold text-gray-800">{{ $application['aname'] }}</span>
                                            </h4>
                                        </div>
                                        <div class="card-body pt-6">
                                            <div class="d-flex align-items-center mb-10">
                                                <img src="https://sc1.diyosoftware.com/assets/diyovm/logos/{{ $application['aimage'] }}?v=10" alt="{{ $application['aname'] }}" style="width:100px;height:80px">
                                            </div>
                                            <div class="d-flex align-items-center mb-5">
                                                <div class="m-0">
                                                    <h4 class="fw-bold text-gray-800 mb-3">Özellikler</h4>
                                                    <div>
                                                        @php $aaddons = json_decode($application['aaddons'],true) @endphp
                                                        @foreach($aaddons as $addon)
                                                        <span class="d-block fs-7 fw-bold text-gray-600 mb-2">
                                                            <span class="svg-icon svg-icon-6 svg-icon-gray-600 me-2">
                                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                                                    <path d="M11.9343 12.5657L9.53696 14.963C9.22669 15.2733 9.18488 15.7619 9.43792 16.1204C9.7616 16.5789 10.4211 16.6334 10.8156 16.2342L14.3054 12.7029C14.6903 12.3134 14.6903 11.6866 14.3054 11.2971L10.8156 7.76582C10.4211 7.3666 9.7616 7.42107 9.43792 7.87962C9.18488 8.23809 9.22669 8.72669 9.53696 9.03696L11.9343 11.4343C12.2467 11.7467 12.2467 12.2533 11.9343 12.5657Z" fill="currentColor"></path>
                                                                </svg>
                                                            </span>
                                                            {{ $addon }}
                                                        </span>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-5">
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Version: v-{{ $application['aversioncode'] }}</span>
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Oluşturulma: {{ date('d.m.Y',$application['adateline']) }}</span>
                                            </div>
                                            <div class="mb-1">
                                                <a href="{{ beGetRoute('client.application.show',['slug' => $application['aslug']]) }}" class="btn btn-sm btn-primary">İncele</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        <div id="ads" style="display:none">
                            <div class="row">
                                @foreach($applications as $application)
                                @if($application['akey'] != 'ads')
                                    @php continue; @endphp
                                @endif
                                <div class="col-xl-6 mb-xl-10">
                                    <div class="card bg-light">
                                        <div class="card-header pt-6">
                                            <h4 class="card-title d-flex align-items-start flex-column">
                                                <span class="card-label fw-bold text-gray-800">{{ $application['aname'] }}</span>
                                            </h4>
                                        </div>
                                        <div class="card-body pt-6">
                                            <div class="d-flex align-items-center mb-10">
                                                <img src="https://sc1.diyosoftware.com/assets/diyovm/logos/{{ $application['aimage'] }}?v=10" alt="{{ $application['aname'] }}" style="width:100px;height:80px">
                                            </div>
                                            <div class="d-flex align-items-center mb-5">
                                                <div class="m-0">
                                                    <h4 class="fw-bold text-gray-800 mb-3">Özellikler</h4>
                                                    <div>
                                                        @php $aaddons = json_decode($application['aaddons'],true) @endphp
                                                        @foreach($aaddons as $addon)
                                                        <span class="d-block fs-7 fw-bold text-gray-600 mb-2">
                                                            <span class="svg-icon svg-icon-6 svg-icon-gray-600 me-2">
                                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                                                    <path d="M11.9343 12.5657L9.53696 14.963C9.22669 15.2733 9.18488 15.7619 9.43792 16.1204C9.7616 16.5789 10.4211 16.6334 10.8156 16.2342L14.3054 12.7029C14.6903 12.3134 14.6903 11.6866 14.3054 11.2971L10.8156 7.76582C10.4211 7.3666 9.7616 7.42107 9.43792 7.87962C9.18488 8.23809 9.22669 8.72669 9.53696 9.03696L11.9343 11.4343C12.2467 11.7467 12.2467 12.2533 11.9343 12.5657Z" fill="currentColor"></path>
                                                                </svg>
                                                            </span>
                                                            {{ $addon }}
                                                        </span>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-5">
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Version: v-{{ $application['aversioncode'] }}</span>
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Oluşturulma: {{ date('d.m.Y',$application['adateline']) }}</span>
                                            </div>
                                            <div class="mb-1">
                                                <a href="{{ beGetRoute('client.application.show',['slug' => $application['aslug']]) }}" class="btn btn-sm btn-primary">İncele</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var oldtab = "security";
    $(".tabmenu").on("click",function(){
        var tab = $(this).data("tab");
        $(".tabmenu.active").removeClass("active");
        $(this).addClass("active");
        $("#"+oldtab).hide();
        $("#"+tab).show();
        oldtab = tab;
        return false;
    });
</script>
@endsection