@extend('admin.layout')
@section('headerinclude')
<title>Kategori Ekle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Kategori Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="categoryForm">
                    <div class="row">
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Adı</label>
                            <input type="text" class="form-control" name="pcname">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Tasarımı</label>
                            <select class="form-control form-control-select" name="pcpagetype">
                                @foreach($themepages as $themepage)
                                <option value="{{ $themepage['tpid'] }}">{{ $themepage['tpname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Tablo Tasarımı</label>
                            <select class="form-control form-control-select" name="pcpagetabletype">
                                @foreach($themepages as $themepage)
                                <option value="{{ $themepage['tpid'] }}">{{ $themepage['tpname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Ürün Tasarımı</label>
                            <select class="form-control form-control-select" name="pcpageitemtype">
                                @foreach($themepages as $themepage)
                                <option value="{{ $themepage['tpid'] }}">{{ $themepage['tpname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sayfa Adı</label>
                            <input type="text" class="form-control" name="pname">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sayfa Kodu</label>
                            <input type="text" class="form-control" name="pcode">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addCategory">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".addCategory").on("click",function(){
        if(!wait){
            $(".addCategory").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.category.add.post') }}",
                type: "post",
                async: true,
                data: $("#categoryForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".addCategory").html("Kaydet");
                    wait = false;
                    if(response.status){
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000)
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection