@extend('admin.layout')
@section('headerinclude')
<title>Dosya Ekle</title>
@endsection
@section('content')
<style>
    #beUploadArea {
        width: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 60px;
        border: 1px dotted var(--bs-text-danger);
    }
    #fileForm #beFileInput {
        display: none;
    }   
</style>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Dosya Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="fileForm">
                    <div class="row">
                        <div class="col-12 mb-9" id="beUploadArea">
                            <label class="fs-6 fw-semibold mb-2">Dosyaları Sürükleyin Yada Seçin</label>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Dosyaları Gizli Olarak Yükle</label>
                            <div class="form-check form-check-custom form-check-solid">
                                <input class="form-check-input" type="checkbox" value="1" name="secret" id="secret">
                                <label class="form-check-label" for="secret">
                                    Dosyalar gizli olarak yüklenirken dosya isimleri değiştirilir ve sadece link ile erişilebilir. Buda yavaş açılmasına sebep olur. Eğer sayfalarda kullanılacaksa dosyaları normal yükleyiniz.
                                    <br>
                                    Dosyalar gizli yüklenirken link: {{ beGetConfig('siteurl') }}/resources/uploads/dosyaadi
                                    <br>
                                    Dosyalar normal yüklenirken link: {{ beGetConfig('siteurl') }}/dosyaadi-dosyaid
                                </label>
                            </div>
                        </div>
                    </div>
                    <input type="file" class="form-control" name="files[]" multiple id="beFileInput">
                </form>
                <div class="table-responsive mb-9">
                    <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                        <thead>
                            <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                <th class="text-center align-middle">#</th>
                                <th class="text-center align-middle">Dosya Adı</th>
                                <th class="text-center align-middle">Boyut</th>
                                <th class="text-center align-middle">Yüklenme</th>
                                <th class="text-center align-middle"></th>
                            </tr>
                        </thead>
                        <tbody id="beFileList">

                        </tbody>
                    </table>
                </div>
                <div>
                    <button class="btn btn-success beUploadComplated d-none">Kullanacağım Dosyaları Yükledim</button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var beFileCounter = 0;
    var beUploadedFiles = [];
    $("#beUploadArea").on("click",function(){
        $("#beFileInput").click();
        return false;
    });
    $(document).ready(function(){
        var beDropArea = document.getElementById("beUploadArea");
        ["dragenter","dragover","dragleave","drop"].forEach(evt => {
            beDropArea.addEventListener(evt,function(e){
                e.preventDefault()
                e.stopPropagation()	
            },false);
        });
        beDropArea.addEventListener("drop",function(e){
            var beFiles = e.dataTransfer.files;
            beUploadFiles(beFiles);
        },false);
        $("#beFileInput").change(function(e){
            var beFiles = e.target.files;
            beUploadFiles(beFiles);
        });
    })
    function beUploadFiles(beFiles){
        var beFormData = null;
        for(var i = 0; i < beFiles.length; i++) {
            beFileCounter += 1;
            let beLocalCounter = beFileCounter;
            beFormData = new FormData();
            beFormData.append("files[]",beFiles[i]);
            beFormData.append("secret",$("#secret").is(":checked") ? 1:0);
            $("#beFileList").prepend('\
                <tr id="beFileRow'+beLocalCounter+'">\
                    <td class="text-center align-middle">'+beLocalCounter+'</td>\
                    <td class="text-center align-middle">'+beFiles[i]['name']+'</td>\
                    <td class="text-center align-middle">'+beFiles[i]['size']+'</td>\
                    <td class="text-center align-middle">%0</td>\
                    <td class="text-center align-middle"></td>\
                </tr>\
            ');
            $.ajax({
                url : "{{ beGetRoute('admin.file.upload.post') }}",
                type : "post",
                data : beFormData,
                async: true,
                cache: false,
                contentType : false,
                processData : false,
                dataType : "json",
                crossDomain: true,
                xhr: function() {
                    var beXHRRequest = new window.XMLHttpRequest();
                    beXHRRequest.upload.addEventListener("progress",function(beEvent){
                        if(beEvent.lengthComputable){
                            var bePercentComplate = (beEvent.loaded/beEvent.total)*100;
                            $("#beFileRow"+beLocalCounter+">td:nth-child(4)").html("%"+Number((bePercentComplate).toFixed(1)))
                        }
                    }, false);
                    return beXHRRequest;
                },
                success:function(beResponse){
                    $.each(beResponse.uploads,function(beIndex,beData){
                        if(beData.status){
                            beUploadedFiles.push(beData.aid);
                            var beExtraText = '<br><span>'+beData.fileurl+'</span><br><span>'+beData.fileclassicurl+'</span>';
                            $("#beFileRow"+beLocalCounter+">td:nth-child(5)").html('<span class="text-success">'+beResponse.message+'</span><div class="mt-2"><a href="" class="btn btn-danger beDeleteFile" data-filelistid="'+beLocalCounter+'" data-aid="'+beData.aid+'">Dosyayı Sil</a></div>'+beExtraText);
                        }
                        else{
                            $("#beFileRow"+beLocalCounter+">td:nth-child(5)").html('<span class="text-danger">'+beResponse.message+"</span>");
                        }
                    });
                }
            });
        }	
    }
    $("#beFileList").on("click",".beDeleteFile",function(){
        var filelistid = $(this).data("filelistid");
        var aid = $(this).data("aid");
        $.ajax({
            url: "{{ beGetRoute('admin.file.delete.post') }}",
            type: "post",
            data: {aid:aid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#beFileRow"+filelistid).remove();
                    beUploadedFiles = beUploadedFiles.filter(function(beValue){ return beValue !== aid})
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        return false;
    });
    if(window.opener){
        $(".beUploadComplated").removeClass("d-none");
    }
    $(".beUploadComplated").on("click",function(){
        window.opener.postMessage({
            beSelectedFiles: beUploadedFiles,
        },"*");
        window.close();
    });
</script>
@endsection