@extend('admin.layout')
@section('headerinclude')
<title>Fatura #{{ $invoice['iid'] }}</title>
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
</style>
@endsection
@section('content')
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="row g-5 g-xl-8 mb-7">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            Fatura
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <div class="d-flex flex-wrap py-5">
                            <div class="flex-equal me-5">
                                <table class="table table-flush fw-semibold gy-1">
                                    <tbody>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Fatura ID</td>
                                            <td class="text-gray-800"># {{ $invoice['iid'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Sahip Bilgileri</td>
                                            <td class="text-gray-800">
                                                {{ $invoice['name'].' '.$invoice['surname'] }}
                                                <a href="{{ beGetRoute('admin.user.show',['uid' => $invoice['uid']]) }}">
                                                    <span class="svg-icon svg-icon-2 text-warning">
                                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" d="M4.7 17.3V7.7C4.7 6.59543 5.59543 5.7 6.7 5.7H9.8C10.2694 5.7 10.65 5.31944 10.65 4.85C10.65 4.38056 10.2694 4 9.8 4H5C3.89543 4 3 4.89543 3 6V19C3 20.1046 3.89543 21 5 21H18C19.1046 21 20 20.1046 20 19V14.2C20 13.7306 19.6194 13.35 19.15 13.35C18.6806 13.35 18.3 13.7306 18.3 14.2V17.3C18.3 18.4046 17.4046 19.3 16.3 19.3H6.7C5.59543 19.3 4.7 18.4046 4.7 17.3Z" fill="currentColor"></path>
                                                            <rect x="21.9497" y="3.46448" width="13" height="2" rx="1" transform="rotate(135 21.9497 3.46448)" fill="currentColor"></rect>
                                                            <path d="M19.8284 4.97161L19.8284 9.93937C19.8284 10.5252 20.3033 11 20.8891 11C21.4749 11 21.9497 10.5252 21.9497 9.93937L21.9497 3.05029C21.9497 2.498 21.502 2.05028 20.9497 2.05028L14.0607 2.05027C13.4749 2.05027 13 2.52514 13 3.11094C13 3.69673 13.4749 4.17161 14.0607 4.17161L19.0284 4.17161C19.4702 4.17161 19.8284 4.52978 19.8284 4.97161Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                                </a>    
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Sahip Mail</td>
                                            <td class="text-gray-800">{{ $invoice['email'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Oluşturulma Tarihi</td>
                                            <td class="text-gray-800">{{ beSpecialTime($invoice['idateline']) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Ödenme Tarihi</td>
                                            <td class="text-gray-800">{{ $invoice['ipaydate'] ? (beSpecialTime($invoice['ipaydate'],' H:i')):'<span class="text-danger">Ödenmedi</span>' }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Zaman Aşımı Tarihi</td>
                                            <td class="text-gray-800">{{ beSpecialTime($invoice['iexpiredate'],' H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Baz Fiyat Tutarı</td>
                                            <td class="text-gray-800">{{ beMoneyFormat($invoice['iprice']).' '.$currencies[$invoice['cid']]['cicon'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Vergi Tutarı</td>
                                            <td class="text-gray-800">{{ beMoneyFormat($invoice['itaxprice']).' '.$currencies[$invoice['cid']]['cicon'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">İndirim Tutarı</td>
                                            <td class="text-gray-800">{{ beMoneyFormat($invoice['idiscount']).' '.$currencies[$invoice['cid']]['cicon'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Toplam Tutar</td>
                                            <td class="text-gray-800">{{ beMoneyFormat($invoice['iprice']+$invoice['itaxprice']-$invoice['idiscount']).' '.$currencies[$invoice['cid']]['cicon'] }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="flex-equal me-5">
                                <table class="table table-flush fw-semibold gy-1">
                                    <tbody>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Durum:</td>
                                            <td class="text-gray-800"><span class="text-{{ $status[$invoice['istatus']][1] }}">{{ $status[$invoice['istatus']][0] }}</span></td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Fatura Tipi:</td>
                                            <td class="text-gray-800"><span>{{ $types[$invoice['itype']] }}</span></td>
                                        </tr>
                                        <tr>
                                            <td class="text-muted min-w-125px w-125px">Fatura Durumu:</td>
                                            <td class="text-gray-800"><span class="text-{{ $bills[$invoice['ibill']][1] }}">{{ $bills[$invoice['ibill']][0] }}</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <hr>
                        <div class="d-flex flex-wrap py-5">
                            <div class="flex-equal me-5">
                                <div class="d-flex flex-wrap py-5">
                                    <div class="flex-equal me-5">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <p class="fs-6 fw-semibold text-gray-600">Fatura Durumu:</p>
                                                <p class="fs-6 fw-semibold text-gray-600"><span class="badge badge-{{ $status[$invoice['istatus']][1] }}">{{ $status[$invoice['istatus']][0] }}</span></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-equal me-5">
                                        <form id="statusForm">
                                            <div class="row">
                                                <div class="col-12 mb-9">
                                                    <select class="form-control form-control-select" name="status" id="statusSelect">
                                                        @foreach($status as $key => $name)
                                                        <option value="{{ $key }}"{{ $key == $invoice['istatus'] ? ' selected':'' }}>{{ $name[0] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-12 mb-9" id="statusFormExtend" style="display: none;">
                                                    <div class="row align-items-center">
                                                        <div class="col-md-12 mb-6">
                                                            <div class="form-check form-switch">
                                                                <input type="hidden" name="oncontent" value="0">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="activateContent" name="oncontent" value="1">
                                                                <label class="form-check-label" for="activateContent">İçeriği Onayla</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12 mb-6">
                                                            <div class="form-check form-switch">
                                                                <input type="hidden" name="onaccounting" value="0">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="activateAccounting" name="onaccounting" value="1">
                                                                <label class="form-check-label" for="activateAccounting">Muhasebe de işlem olarak ekle</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12 mb-6">
                                                            <div class="form-check form-switch">
                                                                <input type="hidden" name="onmoney" value="0">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="activateMoney" name="onmoney" value="1">
                                                                <label class="form-check-label" for="activateMoney">Kullanıcının bakiyesi ile ödeme sağla</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <button class="btn btn-success d-block m-auto statusSaveForm">Kaydet</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-equal me-5">
                            <div class="d-flex flex-wrap py-5">
                                    <div class="flex-equal me-5">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <p class="fs-6 fw-semibold text-gray-600">Resmi Fatura Durumu:</p>
                                                <p class="fs-6 fw-semibold text-gray-600"><span class="badge badge-{{ $bills[$invoice['ibill']][1] }}">{{ $bills[$invoice['ibill']][0] }}</span></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-equal me-5">
                                        <form id="statusBillForm">
                                            <div class="row">
                                                <div class="col-12 mb-9">
                                                    <select class="form-control form-control-select" name="status" id="statusBillSelect">
                                                        @foreach($bills as $key => $name)
                                                        <option value="{{ $key }}"{{ $key == $invoice['ibill'] ? ' selected':'' }}>{{ $name[0] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                @if($invoice['ibilldate'])
                                                <div class="col-12 mb-9">
                                                    <div class="row">
                                                        <div class="mb-3">
                                                            Resmi Fatura Kesilme Tarihi: {{ beSpecialTime($invoice['ibilldate'],' H:i') }}
                                                        </div>
                                                        @if($invoice['ibilldata']['aid'])
                                                        <div class="col-12">
                                                            <a class="btn btn-info" href="{{ beGetAttachmentUrl($invoice['ibilldata']['aid']) }}" target="_blank">Faturayı Görüntüle</a>
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                @endif
                                                <div class="col-12 mb-9" id="statusBillFormExtend" style="display: none;">
                                                    <div class="row align-items-center">
                                                        <div class="col-md-8">
                                                            <div class="form-check form-switch">
                                                                <input type="hidden" name="onrealinvoice" value="0">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="activateRealInvoice" name="onrealinvoice" value="1">
                                                                <label class="form-check-label" for="activateRealInvoice">Faturayı resmiyet üzerinde oluştur</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <button class="btn btn-success d-block m-auto statusBillSaveForm">Kaydet</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5 active" href="#" data-tab="Global">Genel</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Content">İçerik</a>
                            </li>
                            <li class="nav-item mt-2">
                                <a class="nav-link text-active-primary ms-0 me-10 py-5" href="#" data-tab="Options">Fiyat & Tarih</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="tabs">
            <div class="tab active" id="tabGlobal">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card mb-7">
                            <div class="card-header">
                                <div class="card-title">
                                    Fatura İsimlendirmesi
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="nameForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Fatura Adı</label>
                                            <input type="text" class="form-control" name="name" value="{{ $invoice['iname'] }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Fatura Açıklaması</label>
                                            <input type="text" class="form-control" name="description" value="{{ $invoice['idescription'] }}">
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto nameSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Fatura Notları
                                </div>
                            </div>
                            <form id="noteForm" class="card-body">
                                <div class="row">
                                    <div class="col-12 mb-9">
                                        <textarea class="form-control" name="note" rows="7">{{ $invoice['inote'] }}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-success d-block m-auto noteSaveForm">Kaydet</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabContent">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Fatura İçeriği
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="addonForm">
                                    <div class="row">
                                        <div class="row col-12 dragable-zone" id="itemArea">
                                            @foreach($invoiceitems as $item)
                                            <div class="col-12 mb-9 dragable" id="itemRow{{ $item['iiid'] }}" data-key="{{ $item['iiid'] }}">
                                                <div class="row">
                                                    <div class="col-md-1">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Seçim</label>
                                                        <input class="form-control form-check-input beInvoiceItemCheckbox" type="checkbox" value="1" data-iiid="{{ $item['iiid'] }} id="invoiceCheckbox{{ $item['iiid'] }}">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Ürün</label>
                                                        <input type="text" class="form-control" id="rowName{{ $item['iiid'] }}" value="{{ $item['iiname'] }}">
                                                    </div>
                                                    <div class="col-md-1">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Fiyat</label>
                                                        <input type="text" class="form-control" id="rowPrice{{ $item['iiid'] }}" value="{{ $item['iiunitprice'] }}">
                                                    </div>
                                                    <div class="col-md-1">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Adet</label>
                                                        <input type="text" class="form-control" id="rowCount{{ $item['iiid'] }}" value="{{ $item['iiunitcount'] }}">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Birim</label>
                                                        <select class="form-control form-control-select" id="rowUnitType{{ $item['iiid'] }}">
                                                            @foreach($unittypes as $unittype => $name)
                                                            <option value="{{ $unittype }}"{{ $unittype == $item['iiunittype'] ? ' selected':'' }}>{{ $name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Fiyati Birimi</label>
                                                        <select class="form-control form-control-select" id="rowCurrency{{ $item['iiid'] }}">
                                                            @foreach($currencies as $currency)
                                                            <option value="{{ $currency['cid'] }}"{{ $currency['cid'] == $item['cid'] ? ' selected':'' }}>{{ $currency['cname'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">Vergi Oranı(%)</label>
                                                        <input type="text" class="form-control" id="rowTax{{ $item['iiid'] }}" value="{{ $item['iitaxrate'] }}">
                                                    </div>
                                                    <div class="col-md-1">
                                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">İşlemler</label>
                                                        <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteRow" data-key="{{ $item['iiid'] }}">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">
                                                                <path fill="none" d="M0 0h24v24H0z"/>
                                                                <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>
                                                            </svg>
                                                            Sil
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            @endforeach
                                        </div>
                                        <div class="col-12 d-flex align-items-center">
                                            <button class="btn btn-success d-block m-auto invoiceItemAdd">Yeni Satır Ekle</button>
                                            <button class="btn btn-success d-block m-auto invoiceItemSave">Kaydet</button>
                                        </div>
                                    </div>
                                </form> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="tabOptions">
                <div class="row g-5 g-xl-8 mb-7">
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Fatura Fiyatlandırması
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="priceForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Fatura Fiyat Birimi</label>
                                            <select class="form-control form-control-select" name="currency">
                                                @foreach($currencies as $currency)
                                                <option value="{{ $currency['cid'] }}"{{ $currency['cid'] == $invoice['cid'] ? ' selected':'' }}>{{ $currency['cname'] }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-success d-block m-auto priceSaveForm">Kaydet</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Fatura Tarihleri
                                </div>
                            </div>
                            <div class="card-body">
                                <form id="timeForm">
                                    <div class="row">
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Fatura Oluşturulma Tarihi</label>
                                            <input type="datetime-local" class="form-control" name="dateline" value="{{ date('Y-m-d\TH:i',$invoice['idateline']) }}">
                                        </div>
                                        <div class="col-12 mb-9">
                                            <label class="fs-6 fw-semibold mb-2">Fatura Zaman Aşımı Tarihi</label>
                                            <input type="datetime-local" class="form-control" name="expiredate" value="{{ date('Y-m-d\TH:i',$invoice['iexpiredate']) }}">
                                        </div>
                                        <div class="col-12 row">
                                            <div class="col-4 mb-9">
                                                <button class="btn btn-success d-block m-auto timeSaveForm">Kaydet</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    var module = "{{ $order['upmodule'] }}";
    $(".nav-link").on("click",function(){
        var tab = $(this).data("tab");
        $(".nav-link.active").removeClass("active");
        $(this).addClass("active");
        $(".tab.active").removeClass("active");
        $("#tab"+tab).addClass("active");
        return false;
    });
    $("#statusSelect").change(function(){
        $("#statusFormExtend").show("slow");
    });
    $("#statusBillSelect").change(function(){
        $("#statusBillFormExtend").show("slow");
    });
    var wait1 = false;
    $(".statusSaveForm").on("click",function(){
        if(!wait1){
            wait1 = true;
            $(".statusSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.invoice.status.save.post') }}",
                type: "post",
                async: true,
                data: $("#statusForm").serialize()+"&iid={{ $invoice['iid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait1 = false;
                    $(".statusSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait2 = false;
    $(".statusBillSaveForm").on("click",function(){
        if(!wait2){
            wait2 = true;
            $(".statusBillSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.invoice.billstatus.save.post') }}",
                type: "post",
                async: true,
                data: $("#statusBillForm").serialize()+"&iid={{ $invoice['iid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait2 = false;
                    $(".statusBillSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait3 = false;
    $(".nameSaveForm").on("click",function(){
        if(!wait3){
            wait3 = true;
            $(".nameSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.invoice.name.save.post') }}",
                type: "post",
                async: true,
                data: $("#nameForm").serialize()+"&iid={{ $invoice['iid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait3 = false;
                    $(".nameSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait4 = false;
    $(".noteSaveForm").on("click",function(){
        if(!wait4){
            wait4 = true;
            $(".noteSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.invoice.note.save.post') }}",
                type: "post",
                async: true,
                data: $("#noteForm").serialize()+"&iid={{ $invoice['iid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait4 = false;
                    $(".noteSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".invoiceItemAdd").on("click",function(){
        var data = "iid={{ $invoice['iid'] }}";
        $.ajax({
            url: "{{ beGetRoute('admin.invoice.item.add.post') }}",
            type: "post",
            async: true,
            data: data,
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    var iiid = response.iiid;
                    var content = '<div class="col-12 mb-9 dragable" id="itemRow'+iiid+'" data-key="'+iiid+'">\
                        <div class="row">\
                            <div class="col-md-1">\
                                <label class="fs-6 fw-semibold mb-2 text-gray-500">Sıralama</label>\
                                <a href="#" class="btn btn-icon btn-sm btn-hover-light-primary draggable-handle">\
                                    <span class="svg-icon svg-icon-2x">\
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">\
                                            <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z" fill="currentColor"></path>\
                                            <path opacity="0.3" d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z" fill="currentColor"></path>\
                                        </svg>\
                                    </span>\
                                </a>\
                            </div>\
                            <div class="col-md-2">\
                                <label class="fs-6 fw-semibold mb-2 text-gray-500">Ürün</label>\
                                <input type="text" class="form-control" id="rowName'+iiid+'">\
                            </div>\
                            <div class="col-md-1">\
                                <label class="fs-6 fw-semibold mb-2 text-gray-500">Fiyat</label>\
                                <input type="text" class="form-control" id="rowPrice'+iiid+'">\
                            </div>\
                            <div class="col-md-1">\
                                <label class="fs-6 fw-semibold mb-2 text-gray-500">Adet</label>\
                                <input type="text" class="form-control" id="rowCount'+iiid+'">\
                            </div>\
                            <div class="col-md-2">\
                                <label class="fs-6 fw-semibold mb-2 text-gray-500">Birim</label>\
                                <select class="form-control form-control-select" id="rowUnitType'+iiid+'">\
                                    @foreach($unittypes as $unittype => $name)
                                    <option value="{{ $unittype }}">{{ $name }}</option>\
                                    @endforeach
                                </select>\
                            </div>\
                            <div class="col-md-2">\
                                <label class="fs-6 fw-semibold mb-2 text-gray-500">Fiyat Birimi</label>\
                                <select class="form-control form-control-select" id="rowCurrency'+iiid+'">\
                                    @foreach($currencies as $currency)
                                    <option value="{{ $currency['cid'] }}"{{ $currency['cid'] == $system_currency ? ' selected':'' }}>{{ $currency['cname'] }}</option>\
                                    @endforeach
                                </select>\
                            </div>\
                            <div class="col-md-2">\
                                <label class="fs-6 fw-semibold mb-2 text-gray-500">Vergi Oranı(%)</label>\
                                <input type="text" class="form-control" id="rowTax'+iiid+'" value="{{ $system_taxrate }}">\
                            </div>\
                            <div class="col-md-1">\
                                <label class="fs-6 fw-semibold mb-2 text-gray-500">İşlemler</label>\
                                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteRow" data-key="'+iiid+'">\
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">\
                                        <path fill="none" d="M0 0h24v24H0z"/>\
                                        <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>\
                                    </svg>\
                                    Sil\
                                </a>\
                            </div>\
                        </div>\
                    </div>';
                    $("#itemArea").append(content);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        return false;
    });
    var wait5 = false;
    $(".invoiceItemSave").on("click",function(){
        if(!wait5){
            wait5 = true;
            $(".invoiceItemSave").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            var iiid = "";
            var data = "iid={{ $invoice['iid'] }}&";
            $("#itemArea > div").each(function(){
                iiid = $(this).data("key");
                data += "item["+iiid+"][rowName]="+$("#rowName"+iiid).val()+"&";
                data += "item["+iiid+"][rowPrice]="+$("#rowPrice"+iiid).val()+"&";
                data += "item["+iiid+"][rowCount]="+$("#rowCount"+iiid).val()+"&";
                data += "item["+iiid+"][rowTax]="+$("#rowTax"+iiid).val()+"&";
                data += "item["+iiid+"][rowUnitType]="+$("#rowUnitType"+iiid).val()+"&";
                data += "item["+iiid+"][rowCurrency]="+$("#rowCurrency"+iiid).val()+"&";
            });
            $.ajax({
                url: "{{ beGetRoute('admin.invoice.item.save.post') }}",
                type: "post",
                async: true,
                data: data,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait5 = false;
                    $(".invoiceItemSave").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $("#itemArea").on("click",".btnDeleteRow",function(){
        var iiid = $(this).data("key");
        var data = "iid={{ $invoice['iid'] }}&iiid="+iiid
        $.ajax({
            url: "{{ beGetRoute('admin.invoice.item.delete.post') }}",
            type: "post",
            async: true,
            data: data,
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#itemRow"+iiid).remove();
                    Swal.fire("Başarılı",response.message,"success");
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    });
    var wait6 = false;
    $(".priceSaveForm").on("click",function(){
        if(!wait6){
            wait6 = true;
            $(".priceSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.invoice.price.save.post') }}",
                type: "post",
                async: true,
                data: $("#priceForm").serialize()+"&iid={{ $invoice['iid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait6 = false;
                    $(".priceSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var wait7 = false;
    $(".timeSaveForm").on("click",function(){
        if(!wait7){
            wait7 = true;
            $(".timeSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            $.ajax({
                url: "{{ beGetRoute('admin.invoice.time.save.post') }}",
                type: "post",
                async: true,
                data: $("#timeForm").serialize()+"&iid={{ $invoice['iid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait7 = false;
                    $(".timeSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var altcontainers = null;
    altcontainers = document.querySelectorAll(".dragable-zone");
    if(altcontainers.length !== 0) {
        swappable = new Sortable.default(altcontainers, {
            draggable: ".dragable",
            handle: ".dragable .draggable-handle",
            mirror: {
                appendTo: ".maindraggable",
                constrainDimensions: true
            }
        });
    }
</script>
@endsection