@extend('admin.layout')
@section('headerinclude')
<title>Diller</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="{{ beGetRoute('admin.language.add') }}" class="d-inline-flex align-items-center btn btn-primary mb-5">
                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"/>
                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"/>
                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"/>
                    </svg>
                </span>
                Yeni Ekle
            </a>
        </div>
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Dil</th>
                            <th class="text-center align-middle">Eklenme Tarihi</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($languages as $language)
                        <tr id="{{ $language['lid'] }}Row">
                            <td class="text-center align-middle">{{ $language['lid'] }}</td>
                            <td class="text-center align-middle">{{ $language['lname'] }}</td>
                            <td class="text-center align-middle">{{ date('d.m.Y H:i',$language['ldateline']) }}</td>
                            <td class="text-center align-middle">
                                <a data-bs-toggle="tooltip" title="Düzenle" href="{{ beGetRoute('admin.language.edit.text',['lid' => $language['lid']]) }}" class="btn btn-primary">Yazıları Düzenle</a>
                                <a data-bs-toggle="tooltip" title="Düzenle" href="{{ beGetRoute('admin.language.edit',['lid' => $language['lid']]) }}" class="btn btn-primary">Düzenle</a>
                                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDelete" data-lid="{{ $language['lid'] }}">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"/><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/></svg>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    $(".btnDelete").on("click",function(){
        var lid = $(this).data("lid");
        Swal.fire({
            html: "Bu işlem sonucunda dil kalıcı olarak silincektir onaylıyor musunuz?",
            icon: "info",
            buttonsStyling: false,
            showCancelButton: true,
            confirmButtonText: "Onaylıyorum",
            cancelButtonText: "Vazgeçtim",
            customClass: {
                confirmButton: "btn btn-primary",
                cancelButton: "btn btn-danger"
            }
        }).then((result) => {
            if(result.isConfirmed) {
                $.ajax({
                    url: "{{ beGetRoute('admin.language.delete.post') }}",
                    type: "post",
                    data: {lid:lid},
                    dataType: "json",
                    crossDomain: true,
                    success: function(response){
                        if(response.status){
                            $("#"+lid+"Row").remove();
                            Swal.fire("Başarılı",response.message,"success");
            
                        }
                        else{
                            Swal.fire("Bir Hata Oluştu",response.message,"error");
                        }
                    }
                });	
            }
        });
        return false;
    });
</script>

@endsection
