@extend('admin.layout')
@section('headerinclude')
<title>Lisans Yönetimi</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-5 mb-xxl-10">
            <div class="card-header">
                <div class="card-title">
                    <h3>Lisans Bilgileri</h3>
                </div>
            </div>
            <div class="card-body py-10">
                <div class="row">
                <div class="col-md-6 pb-10 pb-lg-0">
                        <h2>Lisans Anahtarı</h2>
                        <p class="fs-6 fw-semibold py-2">{{ $lisance }}</p>
                        <p class="fs-6 fw-semibold text-gray-600">
                            <span class="badge badge-info">Lisans Bitiş Tarihi: {{ date('d.m.Y',$userproduct['upetime']) }}</span>
                        </p>
                        <p class="fs-6 fw-semibold text-gray-600 py-2">
                            @php $endtime = $be->settings['system_data']['product']['upetime']-BE_TIME; @endphp
                            @if($endtime > 0)
                            <span class="badge badge-info">DiyoCP Ürününüzün kalan lisans süresi {{ round($endtime/86400) }} gün</span>
                            @else
                            <span class="badge badge-danger">DiyoCP Ürününüzün süresi doldu sistem her an kapanabilir</span>
                            @endif
                        </p>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex align-items-center mb-5">
                            <span class="fw-semibold fs-6 text-gray-800 flex-grow-1 pe-3">Güncel Fatura Fiyatı</span>
                            <span class="fw-semibold fs-6 text-gray-800 pe-3">{{ $userproduct['upprice'].' '.$userproduct['cicon'] }}</span>
                        </div>
                        <div class="d-flex align-items-center mb-5">
                            <span class="fw-semibold fs-6 text-gray-800 flex-grow-1 pe-3">DiyoCP Sürümü</span>
                            <span class="fw-semibold fs-6 text-gray-800 pe-3">DiyoCP-v{{ $version }} - Yama:{{ $build }}</span>
                        </div>
                        <div class="d-flex align-items-center mb-5">
                            <span class="fw-semibold fs-6 text-gray-800 flex-grow-1 pe-3"></span>
                            <a href="https://www.diyosoftware.com/musteri-paneli/hizmet/{{ $userproduct['upid'] }}" class="d-inline-flex align-items-center btn btn-primary mb-5">
                                <span class="svg-icon svg-icon-muted d-flex align-items-center">
                                    <svg width="23" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="currentColor"></rect>
                                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"></rect>
                                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                Görüntüle
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Api Adreslerini Düzenleyin
                </div>
            </div>
            <div class="card-body">
                <form id="addonForm">
                    <div class="row">
                        <div class="row col-12 dragable-zone" id="itemArea">
                            @foreach($apis as $key => $api)
                            <div class="col-12 mb-9 dragable" id="row{{ $key }}" data-key="{{ $key }}">
                                <div class="row">
                                    <div class="col-md-3">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500 d-block">Sıralama</label>
                                        <a href="#" class="btn btn-icon btn-sm btn-hover-light-primary draggable-handle">
                                            <span class="svg-icon svg-icon-2x">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z" fill="currentColor"></path>
                                                    <path opacity="0.3" d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z" fill="currentColor"></path>
                                                </svg>
                                            </span>
                                        </a>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500">API Adresi</label>
                                        <input type="text" class="form-control" id="rowName{{ $key }}" value="{{ $api }}">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="fs-6 fw-semibold mb-2 text-gray-500 d-block">İşlemler</label>
                                        <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteRow" data-key="{{ $key }}">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">
                                                <path fill="none" d="M0 0h24v24H0z"/>
                                                <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>
                                            </svg>
                                            Sil
                                        </a>
                                    </div>
                                </div>
                            </div>
                            @php $lastkey = $key+1; @endphp
                            @endforeach
                        </div>
                        <div class="col-12 d-flex align-items-center">
                            <button class="btn btn-success d-block m-auto addApi">Yeni API Adresi</button>
                            <button class="btn btn-success d-block m-auto apiSaveForm">Kaydet</button>
                        </div>
                    </div>
                </form> 
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    $(".dragable-zone").on("click",".btnDeleteRow",function(){
        var key = $(this).data("key");
        $("#row"+key).remove();
    });
    var lastkey = {{ $lastkey }};
    $(".addApi").on("click",function(){
        var content = '<div class="col-12 mb-9 dragable" id="row'+lastkey+'" data-key="'+lastkey+'">\
            <div class="row">\
                <div class="col-md-3">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500 d-block">Sıralama</label>\
                    <a href="#" class="btn btn-icon btn-sm btn-hover-light-primary draggable-handle">\
                        <span class="svg-icon svg-icon-2x">\
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">\
                                <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z" fill="currentColor"></path>\
                                <path opacity="0.3" d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z" fill="currentColor"></path>\
                            </svg>\
                        </span>\
                    </a>\
                </div>\
                <div class="col-md-6">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500">API Adresi</label>\
                    <input type="text" class="form-control" id="rowName'+lastkey+'">\
                </div>\
                <div class="col-md-3">\
                    <label class="fs-6 fw-semibold mb-2 text-gray-500 d-block">İşlemler</label>\
                    <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteRow" data-key="'+lastkey+'">\
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor">\
                            <path fill="none" d="M0 0h24v24H0z"/>\
                            <path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"/>\
                        </svg>\
                        Sil\
                    </a>\
                </div>\
            </div>\
        </div>';
        $("#itemArea").append(content);
        lastkey += 1;
        return false;
    });
    var wait4 = false;
    $(".apiSaveForm").on("click",function(){
        if(!wait4){
            wait4 = true;
            $(".apiSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            var key = 0;
            var data = "";
            var counter = 0;
            $("#itemArea > div").each(function(){
                key = $(this).data("key");
                data += "rowName"+counter+"="+$("#rowName"+key).val()+"&";
                counter += 1;
            });
            data += "itemCount="+counter;
            $.ajax({
                url: "{{ beGetRoute('admin.license.edit.post') }}",
                type: "post",
                async: true,
                data: data,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait4 = false;
                    $(".apiSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    var altcontainers = null;
    altcontainers = document.querySelectorAll(".dragable-zone");
    if(altcontainers.length !== 0) {
        swappable = new Sortable.default(altcontainers, {
            draggable: ".dragable",
            handle: ".dragable .draggable-handle",
            mirror: {
                appendTo: ".maindraggable",
                constrainDimensions: true
            }
        });
    }
</script>
@endsection
@endsection