@extend('admin.layout')
@section('headerinclude')
<title>Menü Düzenle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Menü Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="menuForm">
                    <div class="row">
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Tip</label>
                            <select class="form-control form-control-select" name="type">
                                @foreach($menutypes as $key => $menutype)
                                <option value="{{ $key }}"{{ $menu['mtype'] == $key ? ' selected':'' }}>{{ $menutype }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4">
                            <label class="fs-6 fw-semibold mb-2">Konum</label>
                            <select class="form-control form-control-select" name="position">
                                @foreach($menupositions as $key => $menuposition)
                                <option value="{{ $key }}"{{ $menu['mposition'] == $key ? ' selected':'' }}>{{ $menuposition }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4">
                            <label class="fs-6 fw-semibold mb-2">Dil</label>
                            <select class="form-control form-control-select" name="language">
                                @foreach($languages as $language)
                                    <option value="{{ $language['lid'] }}"{{ $menu['lid'] == $language['lid'] ? ' selected':'' }}>{{ $language['lname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Menü Adı</label>
                            <input type="text" class="form-control" name="name" value="{{ $menu['mname'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Menü Alt Adı</label>
                            <input type="text" class="form-control" name="altname" value="{{ $menu['maltname'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Menü Sıralaması</label>
                            <input type="text" class="form-control" name="queque" value="{{ $menu['mqueque'] }}">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Açıklama</label>
                            <textarea class="form-control" name="description" rows="3">{{ $menu['mdescription'] }}</textarea>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Menü Icon Yada URL</label>
                            <input type="text" class="form-control" name="icon" value="{{ $menu['micon'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Rota Yada URL</label>
                            <input type="text" class="form-control" name="route" value="{{ $menu['mroute'] }}">
                        </div>
                        @php $madversiment = json_decode($menu['madversiment'],true) @endphp
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kampanya Başlığı</label>
                            <input type="text" class="form-control" name="adversiment[name]" value="{{ $madversiment['text'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kampanya Arka Planı</label>
                            <input type="text" class="form-control" name="adversiment[background]" value="{{ $madversiment['class'] }}" placeholder="betag-red betag-blinker">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">Durum</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Menünün aktif olup olmayacağını belirler</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="status" value="0">
                                <input class="form-check-input" type="checkbox" role="switch" name="status" value="1"{{ $menu['mstatus'] == 1 ? ' checked':'' }}>
                            </div>
                        </div>
                        @if($menu['mtype'] != 'menu')
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ana Kategori</label>
                            <select class="form-control form-control-select" name="mainmenu">
                                @foreach($menu['uppermenus'] as $uppermenu)
                                    <option value="{{ $uppermenu['mid'] }}"{{ $uppermenu['mid'] == $menu['pid'] ? ' selected':'' }}>{{ $uppermenu['mname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        @endif
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editMenu">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        @if($menu['mtype'] == 'menu')
        <div class="card mb-4">
            <div class="table-responsive">
                <table class="table w-100 table-rounded table-striped border gy-7 gs-7 mb-0">
                    <thead>
                        <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                            <th class="text-center align-middle">#</th>
                            <th class="text-center align-middle">Dil</th>
                            <th class="text-center align-middle">Menü</th>
                            <th class="text-center align-middle">Tür</th>
                            <th class="text-center align-middle">Durum</th>
                            <th class="text-center align-middle">Açılış Tarihi</th>
                            <th class="text-center align-middle"></th>
                        </tr>
                    </thead>
                    <tbody id="pageList">
                        @foreach($menu['altmenus'] as $item)
                        <tr id="{{ $item['mid'] }}Row">
                            <td class="text-center align-middle">{{ $item['mid'] }}</td>
                            <td class="text-center align-middle">{{ $languages[$item['lid']]['lname'] }}</td>
                            <td class="text-center align-middle">{{ $item['mname'] }}</td>
                            <td class="text-center align-middle">{{ $menutypes[$item['mtype']] }}</td>
                            <td class="text-center align-middle"><span class="badge badge-{{ $menustatus[$item['mstatus']][1] }}">{{ $menustatus[$item['mstatus']][0] }}</span></td>
                            <td class="text-center align-middle">{{ beSpecialTime($item['mdateline']) }}</td>
                            <td class="text-center align-middle">
                                <a data-bs-toggle="tooltip" title="Görüntüle" href="{{ beGetRoute('admin.menu.edit',['mid' => $item['mid']]) }}" class="btn btn-warning"><i class="far fa-eye"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".editMenu").on("click",function(){
        if(!wait){
            $(".editMenu").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.menu.edit.post') }}",
                type: "post",
                async: true,
                data: $("#menuForm").serialize()+"&mid={{ $menu['mid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    if(response.status){
                        $(".editMenu").html('Kaydet');
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.reload();
                        },1000)
                    }
                    else{
                        $(".editMenu").html('Kaydet');
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection