@extend('admin.layout')
@section('headerinclude')
<title>Sayfa Düzenle</title>
<link href="assets/plugins/codemirror/codemirror.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/codemirror/material.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/codemirror/material-darker.css" rel="stylesheet" type="text/css"/>
<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
<script src="assets/plugins/global/plugins.bundle.js"></script>
<script src="assets/plugins/codemirror/codemirror.js"></script>
<script src="assets/plugins/codemirror/active-line.js"></script>
<script src="assets/plugins/codemirror/matchbrackets.js"></script>
<script src="assets/plugins/codemirror/xml.js"></script>
<script src="assets/plugins/codemirror/css.js"></script>
<script src="assets/plugins/codemirror/htmlmixed.js"></script>
<style>
.tabs .tab {
    display: none;
}
.tabs .tab.active {
    display: block;
}
.accordpool.active {
    display: flex;
    flex-shrink: 0;
    transition: all 0.2s ease-in-out;
    transform: rotate(90deg);
    align-items: center;
    justify-content: center;
    color: var(--kt-primary);
}
.accordpool.active > span {
    color: var(--kt-primary);
}
</style>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="row g-5 g-xl-8 mb-7">
            <div class="col-xl-12">
                <div class="card mb-7">
                    <div class="card-header">
                        <div class="card-title mt-5 d-block mb-0">
                            <div class="d-block">
                                Sayfa Bilgileri
                            </div>
                            <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold">
                                @foreach($languages as $language)
                                <li class="nav-item mt-2">
                                    <a class="nav-link nav-language text-active-primary ms-0 me-10 py-5 {{ $language['lid'] == $systemlid ? 'active':'' }}" href="#" data-lang="{{ $language['lid'] }}">{{ $language['lname'] }}</a>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <form id="pageForm">
                            @foreach($languages as $language)
                            @php $findlang = false; @endphp
                            @foreach($pagetranslations as $pagetranslation)
                                @php
                                    if($pagetranslation['lid'] == $language['lid']){
                                        $findlang = true;
                                        break;
                                    }
                                @endphp
                            @endforeach
                            @php
                                if(!$findlang){
                                    $pagetranslation = [];
                                }
                            @endphp
                            <div class="row languageTab languageTab{{ $language['lid'] }}">
                                <div class="col-3 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Kodu</label>
                                    <input type="text" class="form-control" name="ptcode[{{ $language['lid'] }}]" value="{{ $pagetranslation['ptcode'] }}">
                                </div>
                                <div class="col-3 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Adı</label>
                                    <input type="text" class="form-control" name="ptname[{{ $language['lid'] }}]" value="{{ $pagetranslation['ptname'] }}">
                                </div>
                                <div class="col-3 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Başlığı(Title)</label>
                                    <input type="text" class="form-control" name="pttitle[{{ $language['lid'] }}]" value="{{ $pagetranslation['pttitle'] }}">
                                </div>
                                <div class="col-3 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Link</label>
                                    <input type="text" class="form-control" name="ptslug[{{ $language['lid'] }}]" value="{{ $pagetranslation['ptslug'] }}" placeholder="/link-url">
                                </div>
                                <div class="col-12 mb-9">
                                    <label class="fs-6 fw-semibold mb-2">Sayfa Açıklama</label>
                                    <input type="text" class="form-control" name="ptdescription[{{ $language['lid'] }}]" value="{{ $pagetranslation['ptdescription'] }}">
                                </div>
                                @if($category['pcpagetype'])
                                <div class="col-12 mb-9">
                                    <div class="form-check form-switch">
                                        <input type="hidden" name="advancemode[{{ $language['lid'] }}]" value="0">
                                        <input class="form-check-input beActiveAdvancedMode" type="checkbox" role="switch" name="advancemode[{{ $language['lid'] }}]" value="1" data-lid="{{ $language['lid'] }}">
                                        <label class="fs-6 fw-semibold mb-2">Kategori sayfasını gelişmiş mod ile düzenle<span class="text-danger">(Tasarımda Bozulmalara Yol Açabilir Dikkatli Olmalısınız)</span></label>
                                    </div>
                                </div>
                                @endif
                                <div class="row beSetNoneAfterLoad beAdvancedArea">
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Sayfa İçerik(HTML)<span class="text-danger">*</span></label>
                                        <textarea class="form-control html-code" name="ptcontent[{{ $language['lid'] }}]" rows="5">{{ $pagetranslation['ptcontent'] }}</textarea>
                                    </div>
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Sayfa Kodu(PHP)<span class="text-danger">*</span></label>
                                        <textarea class="form-control php-code" name="pteval[{{ $language['lid'] }}]" rows="5">{{ $pagetranslation['pteval'] }}</textarea>
                                    </div>    
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Sayfa Başlık(HTML)<span class="text-danger">*</span></label>
                                        <textarea class="form-control html-code" name="ptheader[{{ $language['lid'] }}]" rows="5">{{ $pagetranslation['ptheader'] }}</textarea>
                                    </div>
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Sayfa Slider(HTML)<span class="text-danger">*</span></label>
                                        <textarea class="form-control html-code" name="ptcontentup[{{ $language['lid'] }}]" rows="5">{{ $pagetranslation['ptcontentup'] }}</textarea>
                                    </div>
                                    <div class="col-12 mb-9">
                                        <label class="fs-6 fw-semibold mb-2">Sayfa Kodu(JavaScript)<span class="text-danger">*</span></label>
                                        <textarea class="form-control html-code" name="ptjavascript[{{ $language['lid'] }}]" rows="5">{{ htmlspecialchars($pagetranslation['ptjavascript']) }}</textarea>
                                    </div>
                                    <div class="col-12 d-flex align-items-center">
                                        <button class="btn btn-success d-block m-auto pageSaveForm">Kaydet</button>
                                    </div>
                                </div>
                                @if($category['pcpagetype'])
                                <div class="row beClassicArea">
                                    <div class="btnarea mb-10">
                                        @foreach($themepage['tppagedata']['pageitems'] as $key => $item)
                                            <a href="#" class="btn btn-primary beAddBlcok m-2" data-itemname="{{ $key }}" data-lid="{{ $language['lid'] }}">{{ $item['name'] }}</a>
                                        @endforeach
                                    </div>
                                    <div class="row col-12 dragable-zone" id="itemArea">
                                        @foreach($pagetranslation['ptdata'] as $position => $itemdata)
                                        {{ $itemdata['html'] }}
                                        @endforeach
                                    </div>
                                    <div class="col-12 d-flex align-items-center">
                                        <button class="btn btn-success d-block m-auto pageSaveForm">Kaydet</button>
                                    </div>
                                </div>
                                @endif
                            </div>
                            @endforeach
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script src="assets/plugins/custom/tinymce/tinymce.bundle.js"></script>
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    var codemirrorInstance = [];
    var length = 0;
    $(document).ready(function(){
        var foundtextareasarr = document.getElementsByClassName("php-code");
        for(var i = 0; foundtextareasarr[i]; ++i) { 
            codemirrorInstance[i] = CodeMirror.fromTextArea(foundtextareasarr[i], {
                lineNumbers: true,
                mode: "php",
                theme: "material-darker"   
            });
            length += 1;
        }
        var foundtextareasarr = document.getElementsByClassName("html-code");
        for(var i = 0; foundtextareasarr[i]; ++i) { 
            codemirrorInstance[length+i] = CodeMirror.fromTextArea(foundtextareasarr[i], {
                lineNumbers: true,
                mode: "htmlmixed",
                theme: "material-darker"   
            });
        }
        length = codemirrorInstance.length;
        $(".languageTab").addClass("d-none");
        $(".languageTab{{ $systemlid }}").removeClass("d-none").addClass("d-flex");
        $(".beSetNoneAfterLoad").addClass("d-none");
        @if(!$category['pcpagetype'])
        $(".beAdvancedArea").removeClass("d-none");
        @endif
    });
    $(".beActiveAdvancedMode").on("change",function(){
        if($(this).is(":checked")){
            $(".beClassicArea").addClass("d-none");
            $(".beAdvancedArea").removeClass("d-none");
        }
        else{
            $(".beAdvancedArea").addClass("d-none");
            $(".beClassicArea").removeClass("d-none");
        }
    });
    $(".form-control-select").select2();
    $(".nav-language").on("click",function(){
        var lang = $(this).data("lang");
        $(".nav-language.active").removeClass("active");
        $(this).addClass("active");
        $(".languageTab.d-flex").removeClass("d-flex").addClass("d-none");
        $(".languageTab"+lang).addClass("d-flex").removeClass("d-none");
        return false;
    });
    var wait1 = false;
    var quequelist = "",counter = 1;
    $(".pageSaveForm").on("click",function(){
        if(!wait1){
            for(var i = 0; i < length; ++i) { 
                codemirrorInstance[i].save();
            }
            wait1 = true;
            $(".pageSaveForm").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            @if($category['pcpagetype'])
            quequelist = "";
            @foreach($languages as $language)
            counter = 1;
            $(".dragitems{{ $language['lid'] }}").each(function(index,item){
                quequelist += "&queque[{{ $language['lid'] }}]["+counter+"]="+$(item).data("itemname");
                counter += 1;
            });
            @endforeach
            @endif
            $.ajax({
                url: "{{ beGetRoute('admin.page.edit.post') }}",
                type: "post",
                async: true,
                data: $("#pageForm").serialize()+quequelist+"&pid={{ $page['pid'] }}",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait1 = false;
                    $(".pageSaveForm").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    @if($category['pcpagetype'])
    var lastblock = 900;
    $(".accordpool").on("click",function(){
        var areaname = $(this).attr("data-areaname");
        var content = document.getElementById("areacontent-"+areaname);
        if(content.dataset.status == "0"){
            content.dataset.status = "1";
            $(this).addClass("active");
            content.style.display = "block";
        }
        else{
            content.dataset.status = "0";
            $(this).removeClass("active");
            content.style.display = "none";
        }
        return false;
    });
    $("#itemArea").on("click",".beDeleteArea",function(){
        var areaname = $(this).attr("data-areaname");
        console.log("area-"+areaname);
        document.getElementById("area-"+areaname).remove();
        return false;
    });
    $("#itemArea").on("click",".addNewLine",function(){
        var lastkey = parseInt($(this).attr("data-lastkey"));
        $(this).attr("data-lastkey",(lastkey+1));
        var areaname = $(this).attr("data-lastkeydata");
        var classname = $(this).attr("data-class");
        var labelname = $(this).attr("data-labelname");
        var type = $(this).attr("data-type");
        if(type == "input"){
            document.getElementById("area-"+areaname).innerHTML += '<div class="'+classname+'" id="area-'+areaname+'['+(lastkey+1)+']"><label class="fs-6 fw-semibold mb-2 text-gray-500">'+labelname+'</label><div class="d-flex flex-center"><input type="text" class="form-control" name="'+areaname+'['+(lastkey+1)+']"><a data-bs-toggle="tooltip" class="btn btn-danger beDeleteArea mx-3" data-areaname="'+areaname+'['+(lastkey+1)+']" data-kt-initialized="1"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg></a></div></div>';;
        }
        else{
            document.getElementById("area-"+areaname).innerHTML += '<div class="'+classname+' mb-1"><label class="fs-6 fw-semibold mb-2 text-gray-500">'+labelname+'</label><textarea class="form-control" name="'+areaname+'['+(lastkey+1)+']"></textarea></div>';;
        }
        console.log("#area-"+areaname);
        return false;
    });
    $(".copyAreaLine").on("click",function(){
        var lastkey = parseInt($(this).attr("data-lastkey"));
        $(this).attr("data-lastkey",(lastkey+1));
        var areaname = $(this).attr("data-areaname");
        var lastitem = $(this).attr("data-lastitem");
        var itemtext = document.getElementById("area-"+lastitem).outerHTML;
        var lastitemkey = $(this).attr("data-lastitemkey");
        var nextkey = "["+lastitemkey.split("][")[0].replace("[","")+"]["+(lastkey+1)+"]";
        var lastkey = "\\["+lastitemkey.split("][")[0].replace("[","")+"\\]\\["+(lastkey)+"\\]";
        var regex = new RegExp(lastkey,"g");
        itemtext = itemtext.replaceAll(regex,nextkey);
        itemtext = itemtext.replaceAll(/value="(.*?)"/g,' ');
        var maindivarea = areaname+"["+lastitemkey.split("][")[0].replace("[","")+"]";
        $(this).attr("data-lastitem",lastitem.replaceAll(regex,nextkey));
        $(this).attr("data-lastitemkey",lastitemkey.replaceAll(regex,nextkey));
        let objectarea = document.getElementById("area-"+maindivarea);
        var elements = objectarea.getElementsByTagName("input");
        for (var i = 0; i < elements.length; i++) {
            elements[i].setAttribute("value",elements[i].value);
        }
        objectarea.innerHTML += itemtext;
        return false;
    });
    $(".beAddBlcok").on("click",function(){
        var lid = $(this).data("lid");
        var itemname = $(this).data("itemname");
        $.ajax({
            url: "{{ beGetRoute('admin.page.newarea.post') }}",
            type: "post",
            async: true,
            data: "lid="+lid+"&itemname="+itemname+"&lastblock="+lastblock+"&tpid={{ $category['pcpagetype'] }}",
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    lastblock += 1;
                    $("#itemArea").prepend(response.html);
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
        return false;
    })
    var altcontainers = null;
    altcontainers = document.querySelectorAll(".dragable-zone");
    if(altcontainers.length !== 0) {
        swappable = new Sortable.default(altcontainers, {
            draggable: ".dragable",
            handle: ".dragable .draggable-handle",
            mirror: {
                appendTo: ".maindraggable",
                constrainDimensions: true
            }
        });
    }
    @endif
</script>
@endsection