@extend('admin.layout')
@section('headerinclude')
<title>Ürün Ekle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Ürün Oluştur(Adım 1)
                </div>
            </div>
            <div class="card-body">
                <form id="addProductForm" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ürün Adı Giriniz</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Kategori Seçiniz</label>
                            <select class="form-control form-control-select" name="categories[]" multiple>
                                @foreach($categories as $category)
                                <option value="{{ $category['pcid'] }}">{{ $category['pcname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Ürün Resmi Seçiniz</label>
                            <input type="file" class="form-control" name="image">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Stok Adedi Giriniz(Sınırsız -1)</label>
                            <input type="number" class="form-control" name="stock">
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addProduct">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="assets/plugins/custom/draggable/draggable.bundle.js"></script>
<script>
    var wait = false;
    $(".form-control-select").select2();
    $(".addProduct").on("click",function(){
        if(!wait){
            $(".addProduct").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.product.add.post') }}",
                type: "post",
                async: true,
                data: new FormData($("#addProductForm")[0]),
                dataType: "json",
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function(response){
                    $(".addProduct").html("Kaydet");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection