@extend('admin.layout')
@section('headerinclude')
<title>Ayarlar</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="d-flex justify-content-end">
            <a href="#" class="beClearCache d-inline-flex align-items-center btn btn-warning mb-5 mx-3">
                Ön Belleği Temizle
            </a>
        </div>
        <div class="d-flex justify-content-end">
            <a href="#" class="beClearCacheAll d-inline-flex align-items-center btn btn-danger mb-5 mx-3">
                Tüm Belleği Temizle
            </a>
        </div>
        <div class="row">
            @foreach($settinggroups as $settinggroup)
            <div class="col-6">
                <div class="card mb-4">
                    <div class="card-body pb-0">
                        <div class="d-flex align-items-center">
                            <div class="d-flex align-items-center flex-grow-1">
                                <div class="d-flex flex-column">
                                    <a href="{{ beGetRoute('admin.settings.settinggroup.show',['sgid' => $settinggroup['sgid']]) }}" class="text-gray-900 text-hover-primary fs-6 fw-bold mb-3">{{ $settinggroup['sgname'] }}</a>
                                    <span class="text-gray-500 fw-bold">{{ $settinggroup['sgdescription'] }}</span>
                                </div>
                            </div>		 
                        </div>
                        <div class="separator pt-3"></div>
                        <div class="d-flex flex-end py-2">
                            <div class="me-2">
                                <a href="{{ beGetRoute('admin.settings.settinggroup.show',['sgid' => $settinggroup['sgid']]) }}" class="d-inline-flex align-items-center btn btn-info mb-5 mx-3">
                                    Düzenle
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".beClearCache").on("click",function(){
        if(!wait){
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.cache.clear.post') }}",
                type: "post",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
    $(".beClearCacheAll").on("click",function(){
        if(!wait){
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.cache.clearall.post') }}",
                type: "post",
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection