@extend('admin.layout')
@section('headerinclude')
<title>Ayar Düzenle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    {{ $settinggroup['sgname'] }}
                </div>
            </div>
            <div class="card-body">
                <form id="settingForm"  enctype="multipart/form-data">
                    <input type="hidden" name="sgid" value="{{ $settinggroup['sgid'] }}">
                    <div class="row">
                        @foreach($settings as $key => $setting)
                        @php 
                            $types = explode(PHP_EOL,$setting['stype']);
                            $type = trim($types[0]);
                            unset($types[0]);
                            $selects = $types;
                            $setting['svalue'] = htmlspecialchars($setting['svalue']);
                        @endphp
                        @if(in_array($type,['float','str']))
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">{{ $setting['sname'] }}</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">{{ $setting['sdescription'] }}</label>
                            <input type="text" class="form-control" name="{{ $setting['scode'] }}" value="{{ $setting['svalue'] }}">
                        </div>
                        @endif
                        @if($type == 'int')
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">{{ $setting['sname'] }}</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">{{ $setting['sdescription'] }}</label>
                            <input type="number" class="form-control" name="{{ $setting['scode'] }}" value="{{ $setting['svalue'] }}">
                        </div>
                        @endif
                        @if(in_array($type,['select','multipleselect']))
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">{{ $setting['sname'] }}</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">{{ $setting['sdescription'] }}</label>
                            @if($type == 'multipleselect')
                            <select class="form-control form-control-select" name="{{ $setting['scode'] }}[]" multiple>
                                @php $values = explode(',',$setting['svalue']); @endphp
                                @foreach($selects as $select)
                                @php $select = explode('=',$select); @endphp
                                <option value="{{ $select[0] }}"{{ in_array($select[0],array_values($values)) ? ' selected':'' }}>{{ $select[1] }}</option>
                                @endforeach
                            </select>
                            @else
                            <select class="form-control form-control-select" name="{{ $setting['scode'] }}">
                                @foreach($selects as $select)
                                @php $select = explode('=',$select); @endphp
                                <option value="{{ $select[0] }}"{{ $setting['svalue'] == $select[0] ? ' selected':'' }}>{{ $select[1] }}</option>
                                @endforeach
                            </select>
                            @endif
                        </div>
                        @endif
                        @if($type == 'bool')
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">{{ $setting['sname'] }}</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">{{ $setting['sdescription'] }}</label>
                            <input class="form-check-input" name="{{ $setting['scode'] }}" type="checkbox" {{ $setting['svalue'] == 1 ? ' checked':''}}>
                        </div>
                        @endif
                        @if($type == 'img')
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">{{ $setting['sname'] }}</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">{{ $setting['sdescription'] }}</label>
                            <img src="{{ $setting['svalue'] }}" width="150" height="150">
                            <input type="file" class="form-control" name="{{ $setting['scode'] }}">
                        </div>
                        @endif
                        @if($key != array_key_last($settings))
                        <hr class="py-5">
                        @endif
                        @endforeach
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto saveSettings">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var wait = false;
    $(".saveSettings").on("click",function(){
        if(!wait){
            $(".saveSettings").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.settings.save.post') }}",
                type: "post",
                async: true,
                data: new FormData($("#settingForm")[0]),
                dataType: "json",
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function(response){
                    wait = false;
                    $(".saveSettings").html('Kaydet');
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection