asdasd@extend('admin.layout')
@section('headerinclude')
<title>Görev Ekle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Görev Ekle
                </div>
            </div>
            <div class="card-body">
                <form id="taskForm">
                    <div class="row">
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Adı</label>
                            <input type="text" class="form-control" name="tname">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Dosyası</label>
                            <input type="text" class="form-control" name="tfilename">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Sırası</label>
                            <input type="text" class="form-control" name="tqueque">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Dakikası</label>
                            <input type="text" class="form-control" name="tcronminute">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Saati</label>
                            <input type="text" class="form-control" name="tcronhour">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Günü</label>
                            <input type="text" class="form-control" name="tcronday">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">Görev Log Kayıt Durumu</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Görevin işlem hatalarını ve bilgilerinin kayıt olmasını sağlar</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="tlogs" value="0">
                                <input class="form-check-input" type="checkbox" role="switch" name="tlogs" value="1">
                            </div>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">Görev Durumu</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Görevin aktif olup olmadığını belirler</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="tstatus" value="0">
                                <input class="form-check-input" type="checkbox" role="switch" name="tstatus" value="1">
                            </div>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto createTask">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".createTask").on("click",function(){
        if(!wait){
            $(".createTask").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.task.add.post') }}",
                type: "post",
                async: true,
                data: $("#taskForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".createTask").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection