asdasd@extend('admin.layout')
@section('headerinclude')
<title>Görev Düzenle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Görev Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="taskForm">
                    <input type="hidden" name="tid" value="{{ $task['tid'] }}">
                    <div class="row">
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Adı</label>
                            <input type="text" class="form-control" name="tname" value="{{ $task['tname'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Dosyası</label>
                            <input type="text" class="form-control" name="tfilename" value="{{ $task['tfilename'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Sırası</label>
                            <input type="text" class="form-control" name="tqueque" value="{{ $task['tqueque'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Dakikası</label>
                            <input type="text" class="form-control" name="tcronminute" value="{{ $task['tcronminute'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Saati</label>
                            <input type="text" class="form-control" name="tcronhour" value="{{ $task['tcronhour'] }}">
                        </div>
                        <div class="col-4 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Görev Günü</label>
                            <input type="text" class="form-control" name="tcronday" value="{{ $task['tcronday'] }}">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">Görev Log Kayıt Durumu</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Görevin işlem hatalarını ve bilgilerinin kayıt olmasını sağlar</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="tlogs" value="0">
                                <input class="form-check-input" type="checkbox" role="switch" name="tlogs" value="1"{{ $task['tlogs'] == 1 ? ' checked':'' }}>
                            </div>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2 d-block">Görev Durumu</label>
                            <label class="fs-7 fw-semibold mb-2 d-block text-gray-700">Görevin aktif olup olmadığını belirler</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="tstatus" value="0">
                                <input class="form-check-input" type="checkbox" role="switch" name="tstatus" value="1"{{ $task['tstatus'] == 1 ? ' checked':'' }}>
                            </div>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editTask">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".editTask").on("click",function(){
        if(!wait){
            $(".editTask").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.task.edit.post') }}",
                type: "post",
                async: true,
                data: $("#taskForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    $(".editTask").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection