@extend('admin.layout')
@section('headerinclude')
<title>Departman Oluştur</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Departman Oluştur
                </div>
            </div>
            <div class="card-body">
                <form id="depertmentForm">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Departman</label>
                            <input type="text" class="form-control" name="name">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Dil</label>
                            <select class="form-control form-control-select" name="language">
                                @foreach($languages as $language)
                                    <option value="{{ $language['lid'] }}">{{ $language['lname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Sorumlular</label>
                            <select class="form-control form-control-select" name="users[]" multiple>
                                @foreach($ticketusers as $user)
                                <option value="{{ $user['uid'] }}">{{ $user['name'].' '.$user['surname'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto addDepertment">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    $(".form-control-select").select2();
    var wait = false;
    $(".addDepertment").on("click",function(){
        if(!wait){
            $(".addDepertment").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.ticket.depertment.add.post') }}",
                type: "post",
                async: true,
                data: $("#depertmentForm").serialize(),
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $(".addDepertment").html("Kaydet");
                    wait = false;
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            window.location.href = response.url;
                        },1000)
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection