@extend('admin.layout')
@section('headerinclude')
<title>Güncellemeler</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="docs-content d-flex flex-column flex-column-fluid" id="kt_docs_content">
            <div class="container d-flex flex-column flex-lg-row" id="kt_docs_content_container">
                <div class="card card-docs flex-row-fluid mb-2">
                    <div class="card-body fs-6 py-15 px-10 py-lg-15 px-lg-15 text-gray-700">
                        <div class="d-flex align-items-center rounded py-5 px-4 bg-light-info">
                            <div class="d-flex h-80px w-80px flex-shrink-0 flex-center position-relative ms-3 me-6">
                                <span class="svg-icon svg-icon-info position-absolute opacity-10">
                                    <svg class=". w-80px h-80px ." xmlns="http://www.w3.org/2000/svg" width="70px" height="70px" viewBox="0 0 70 70" fill="none">
                                        <path d="M28 4.04145C32.3316 1.54059 37.6684 1.54059 42 4.04145L58.3109 13.4585C62.6425 15.9594 65.3109 20.5812 65.3109 25.5829V44.4171C65.3109 49.4188 62.6425 54.0406 58.3109 56.5415L42 65.9585C37.6684 68.4594 32.3316 68.4594 28 65.9585L11.6891 56.5415C7.3575 54.0406 4.68911 49.4188 4.68911 44.4171V25.5829C4.68911 20.5812 7.3575 15.9594 11.6891 13.4585L28 4.04145Z" fill="currentColor"></path>
                                    </svg>
                                </span>
                                <span class="svg-icon svg-icon-3x svg-icon-info position-absolute">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.3" d="M22 19V17C22 16.4 21.6 16 21 16H8V3C8 2.4 7.6 2 7 2H5C4.4 2 4 2.4 4 3V19C4 19.6 4.4 20 5 20H21C21.6 20 22 19.6 22 19Z" fill="currentColor"></path>
                                        <path d="M20 5V21C20 21.6 19.6 22 19 22H17C16.4 22 16 21.6 16 21V8H8V4H19C19.6 4 20 4.4 20 5ZM3 8H4V4H3C2.4 4 2 4.4 2 5V7C2 7.6 2.4 8 3 8Z" fill="currentColor"></path>
                                    </svg>
                                </span>
                            </div>
                            <div class="text-gray-700 fw-bold fs-6 lh-lg">
                                <span class="d-block">Sistem Versiyonu: v{{ $version }}</span>
                                <span class="d-block">Sistem Versiyonu(Build): {{ $build }}</span>
                                <span class="d-block">Sistem Güncel Versiyonu: {{ $update['process'] == true ? $update['update']['uversion']:$version }}</span>
                            </div>
                        </div>
                        @if($update['process'] == true)
                            <div class="py-10">
                                <h1 class="anchor fw-bold mb-5" id="gulp-quick-start" data-kt-scroll-offset="50">
                                <a href="#"></a>{{ $update['update']['uname'] }}</h1>
                                {{ $update['update']['udescription'] }}
                            </div>
                            @if($update['update']['ustatus'] == 1)
                            <div class="d-flex align-items-center rounded py-5 px-5 bg-light-primary">
                                <span class="svg-icon svg-icon-3x svg-icon-info me-5">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="10" fill="currentColor"></rect>
                                        <rect x="11" y="14" width="7" height="2" rx="1" transform="rotate(-90 11 14)" fill="currentColor"></rect>
                                        <rect x="11" y="17" width="2" height="2" rx="1" transform="rotate(-90 11 17)" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                <div class="text-gray-700 fw-bold fs-6">Güncellemenin yayına alınacağı tarih {{ date('d.m.Y H:i',$update['update']['upatchdateline']) }}.</div>
                            </div>
                            @endif
                            @if($update['update']['ustatus'] == 2 && $build != $update['update']['ubuild'])
                            <div class="rounded border p-10 d-flex align-items-center p-5 mt-10">
                                <div class="d-flex flex-column">
                                    <h4 class="mb-1">{{ $update['message'] }}</h4>
                                    <span class="d-block text-white">
                                        Yeni güncellemeyi kurmak için aşağıdaki butona basınız ve sayfadan ayrılmayınız!
                                    </span>
                                    <a href="#" class="btn btn-info mt-10 btnUpdate"><i class="bi bi-vector-pen fs-4 me-2"></i> Güncelle</a>
                                </div>
                            </div>
                            @endif
                        @else
                        <div class="alert alert-success d-flex align-items-center p-5 mt-10">
                            <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.3" d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z" fill="currentColor"></path>
                                    <path d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z" fill="currentColor"></path>
                                </svg>
                            </span>
                            <div class="d-flex flex-column">
                                <h4 class="mb-1 text-success">Sürüm Bilgisi</h4>
                                <span>{{ $update['message'] }}</span>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    $(".btnUpdate").on("click",function(){
        if(!wait){
            $(".btnUpdate").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.update.post') }}",
                type: "post",
                async: true,
                data: {},
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    if(response.status){
                        $(".btnUpdate").html('<i class="bi bi-vector-pen fs-4 me-2"></i> Güncelle');
                        Swal.fire("Başarılı",response.message,"success");
                        setTimeout(function(){
                            location.reload();
                        },3000);
                    }
                    else{
                        $(".btnUpdate").html('<i class="bi bi-vector-pen fs-4 me-2"></i> Güncelle');
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                        wait = false;
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection