@extend('admin.layout')
@section('headerinclude')
<title>Grup Düzenle</title>
@endsection
@section('content')
<div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-xxl">
        <div class="card mb-10">
            <div class="card-header">
                <div class="card-title">
                    Grup Düzenle
                </div>
            </div>
            <div class="card-body">
                <form id="userGroupForm">
                    <input type="hidden" class="form-control" name="ugid" value="{{ $usergroup['ugid'] }}">
                    <div class="row">
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Grup Adı</label>
                            <input type="text" class="form-control" name="ugname" value="{{ $usergroup['ugname'] }}">
                        </div>
                        <div class="col-6 mb-9">
                            <label class="fs-6 fw-semibold mb-2">Grup Açıklaması</label>
                            <input type="text" class="form-control" name="ugdescription" value="{{ $usergroup['ugdescription'] }}">
                        </div>
                        <div class="col-12 mb-9">
                            <label class="fs-6 fw-semibold mb-2">İsim Şekli</label>
                            <textarea class="form-control" name="ugnamestyle" rows="7">{{ $usergroup['ugnamestyle'] }}</textarea>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editUserGroup">Kaydet</button>
                        </div>
                        <hr class="py-4 my-4">
                        <div class="row">
                            <div class="col-12 mb-10">
                                <div class="form-check form-check-custom form-check-solid">
                                    <input class="form-check-input selectToggle" type="checkbox" value="1" id="toggle_select">
                                    <label class="form-check-label" for="toggle_select">
                                        Tüm Yetkileri Ver                                               
                                    </label>
                                </div>
                            </div>
                            @foreach($usergroupcategories as $usergroupcategory)
                            <div class="col-6 col-md-6 mb-9">
                                <div class="card card-bordered">
                                    <div class="card-header">
                                        <div class="card-title">
                                            <h3 class="card-label">{{ __('usergroup_category_'.$usergroupcategory) }}</h3>
                                        </div>
                                    </div>
                                    <div class="card-body px-5 pt-5 pb-0">
                                        <div class="row">
                                            <div class="col-12 mb-9">
                                                @foreach($grouppermissions as $key => $grouppermission)
                                                @php
                                                    if(!preg_match('/'.$usergroupcategory.'/',$grouppermission['ugpcode'])){
                                                        continue;
                                                    }
                                                    unset($grouppermissions[$key]);
                                                @endphp
                                                <div class="col-12 mb-3">
                                                    @if($grouppermission['ugptype'] == 'bool')
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <input type="hidden" value="0" name="{{ $grouppermission['ugpcode'] }}">
                                                        <input class="form-check-input checkAll" type="checkbox" value="1" name="{{ $grouppermission['ugpcode'] }}" id="{{ $grouppermission['ugpcode'] }}"{{ $usergroup['ugpermissions'][$grouppermission['ugpcode']] == 1 ? ' checked':'' }}>
                                                        <label class="form-check-label" for="{{ $grouppermission['ugpcode'] }}">
                                                            {{ __('usergroup_'.$grouppermission['ugpcode']) }}
                                                        </label>
                                                    </div>
                                                    @endif
                                                    @if($grouppermission['ugptype'] == 'number')
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <label class="fs-6 fw-semibold mb-2">{{ __('usergroup_'.$grouppermission['ugpcode']) }}</label>
                                                        <input type="text" class="form-control" name="{{ $grouppermission['ugpcode'] }}" value="{{ isset($usergroup['ugpermissions'][$grouppermission['ugpcode']]) ? $usergroup['ugpermissions'][$grouppermission['ugpcode']]:'0' }}">
                                                    </div>
                                                    @endif
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                            <div class="col-6 col-md-6 mb-9">
                                <div class="card card-bordered">
                                    <div class="card-header">
                                        <div class="card-title">
                                            <h3 class="card-label">{{ __('usergroup_category_admin_other') }}</h3>
                                        </div>
                                    </div>
                                    <div class="card-body px-5 pt-5 pb-0">
                                        <div class="row">
                                            <div class="col-12">
                                                @foreach($grouppermissions as $key => $grouppermission)
                                                <div class="col-6 mb-3">
                                                    @if($grouppermission['ugptype'] == 'bool')
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <input type="hidden" value="0" name="{{ $grouppermission['ugpcode'] }}">
                                                        <input class="form-check-input checkAll" type="checkbox" value="1" name="{{ $grouppermission['ugpcode'] }}" id="{{ $grouppermission['ugpcode'] }}"{{ $usergroup['ugpermissions'][$grouppermission['ugpcode']] == 1 ? ' checked':'' }}>
                                                        <label class="form-check-label" for="{{ $grouppermission['ugpcode'] }}">
                                                            {{ __('usergroup_'.$grouppermission['ugpcode']) }}
                                                        </label>
                                                    </div>
                                                    @endif
                                                    @if($grouppermission['ugptype'] == 'number')
                                                    <div class="form-check form-check-custom form-check-solid">
                                                        <label class="fs-6 fw-semibold mb-2">{{ __('usergroup_'.$grouppermission['ugpcode']) }}</label>
                                                        <input type="text" class="form-control" name="{{ $grouppermission['ugpcode'] }}" value="{{ isset($usergroup['ugpermissions'][$grouppermission['ugpcode']]) ? $usergroup['ugpermissions'][$grouppermission['ugpcode']]:'0' }}">
                                                    </div>
                                                    @endif
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-success d-block m-auto editUserGroup">Kaydet</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
    var wait = false;
    var selected = false;
    $(".selectToggle").on("change",function(){
        selected = !selected;
        if(selected){
            $(".checkAll").prop("checked",true);
        }
        else{
            $(".checkAll").prop("checked",false);
        }
    });
    $(".editUserGroup").on("click",function(){
        if(!wait){
            $(".editUserGroup").html('Bekleyin <span class="spinner-border spinner-border-sm align-middle ms-2"></span>');
            wait = true;
            $.ajax({
                url: "{{ beGetRoute('admin.user.group.edit.post') }}",
                type: "post",
                async: true,
                data: new FormData($("#userGroupForm")[0]),
                dataType: "json",
                crossDomain: true,
                processData: false,
                contentType: false,
                success: function(response){
                    wait = false;
                    $(".editUserGroup").html("Kaydet");
                    if(response.status){
                        Swal.fire("Başarılı",response.message,"success");
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });	
        }	
        else{
            Swal.fire("Bir Hata Oluştu","Lütfen işlemin tamamlanmasını bekleyin","error");
        }
        return false;
    });
</script>
@endsection