@extend('clientarea.layout')
@section('title')Fatura #{{ $invoice['iid'] }} - {{ beGetConfig('sitename') }}@endsection
@section('headerinclude')
<style>
.invoice-key {
    display: block;
    font-size: 18px;
    color: #464d51;
}
.invoice-val {
    display: block;
    font-size: 14px;
    color: #464d51;
}
</style>
@endsection
@section('content')
<div class="card">
    <div class="card-header p-min">
        <div>
            <span>Makbuz Detayları</span>
        </div>
        <div>
        <img src="{{ $be->settings['system_logo_footer'] }}" width="200" height="48" title="{{ beGetConfig('sitename') }}" alt="{{ beGetConfig('sitename') }}" crossorigin="anonymous">
        </div>
    </div>
    <div class="row mb-5 mt-5">
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Makbuz No</span>
            <span class="invoice-val">#{{ $invoice['iid'] }}</span>
        </div>		
        <div class="col-4 text-center my-3">
            <span class="invoice-key">İsim</span>
            <span class="invoice-val">{{ $invoice['iname'] }}</span>
        </div>	
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Açıklama</span>
            <span class="invoice-val">{{ $invoice['idescription'] }}</span>
        </div>
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Ödeme Durumu</span>
            <span class="invoice-val">{{ $istatus[$invoice['istatus']] }}</span>
        </div>
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Oluşturulma Tarihi</span>
            <span class="invoice-val">{{ date('d.m.Y',$invoice['idateline']) }}</span>
        </div>
        <div class="col-4 text-center my-3">
            <span class="invoice-key">Son Ödeme Tarihi</span>
            <span class="invoice-val">{{ date('d.m.Y H:i',$invoice['iexpiredate']) }}</span>
        </div>
    </div>	
    <div class="mt-3 p-5" style="overflow-x: auto;">
        <table class="btable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Hizmet Adı</th>
                    <th>Adet</th>
                    <th>Adet Fiyat</th>
                    <th>Vergi Oranı</th>
                    <th>Toplam Fiyat</th>
                </tr>
            </thead>
            <tbody>
                @php 
                $counter = 1;
                @endphp
                @foreach($invoiceitems as $item)
                <tr>
                    <td>{{ $counter }}</td>
                    <td>{{ $item['iiname'] }}</td>
                    <td>{{ $item['iiunitcount'] }} Adet</td>
                    <td>{{ $item['iiunitprice'] }} {{ $currencies[$item['cid']]['cicon'] }}</td>
                    <td>
                        {{ $item['iitaxrate'] > 0 ? ('%'.$item['iitaxrate']):'-' }}
                    </td>
                    <td>{{ beMoneyFormat($item['iiunitprice']*$item['iiunitcount']) }} {{ $currencies[$item['cid']]['cicon'] }}</td>
                </tr>
                @php $counter += 1 @endphp
                @endforeach
            </tbody>
        </table>			
    </div>
    <hr>
    <div class="row-flex row-end">
        <div class="px-5 my-2 text-end">
            @if($invoice['itaxprice'] > 0)
            <div class="my-2">
                <span class="text-normal text-lg mr-1">Vergi:</span>
                <span class="text-normal text-lg">{{ beMoneyFormat($invoice['itaxprice']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</span>
            </div>
            @endif
            @if($invoice['idiscount'] > 0)
            <div class="my-2">
                <span class="text-normal text-lg mr-1">İndirim:</span>
                <span class="text-normal text-lg">{{ beMoneyFormat($invoice['idiscount']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</span>
            </div>
            @endif
            <div>
                <span class="text-normal text-lg mr-1">Toplam:</span>
                <span class="text-normal text-lg">{{ beMoneyFormat($invoice['itotal']) }} {{ $currencies[$invoice['cid']]['cicon'] }}</span>
            </div>
        </div>
    </div>
    @if($invoice['istatus'] == '0')
    <div class="row-flex row-center pb-4">
        <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}?action=pay" class="btn btn-primary">Öde</a>
    </div>
    @endif
</div>
@endsection