@extend('clientarea.layout')
@section('title')Ödeme Yöntemi Seçiniz - {{ beGetConfig('sitename') }}@endsection
@section('headerinclude')
<style>
.payment-options {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 15px;
    border: 1px solid rgb(230 230 230);
    background: white;
    cursor: pointer;
    border-radius: 6px;
    margin-bottom: 15px;
}
.payment-options.active {
    border: 1px solid rgb(43 215 104)!important;
}
.payment-options .info {
    display: flex;
    margin-right: 20px;
}
.payment-options .info .logo {
    margin-right: 20px;
    padding-right: 20px;
    border-right: 1px solid rgb(230 230 230);
}
.payment-options .info .text span:first-child {
    font-weight: 600;
    margin-bottom: 6px;
    font-size: 16px;
}
.payment-options .info .text span:last-child {
    opacity: 0.5;
    font-size: 12px;
}
.payment-options .info .text span {
    display: block;
}
.payment-options .info img {
    width: 65px;
    height: 50px;
}
.payment-options .price {
    width: 8%;
    font-weight: 500;
    font-size: 18px;
}
@media screen and (max-width: 992px) {
    .payment-options {
        flex-direction: column;
    }
    .payment-options .info {
        margin-right: 0;
    }
    .payment-options .price {
        margin-top: 30px;
        width: 100%;
        text-align: end;
    }
}

</style>
@endsection
@section('content')
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-git-repository-line"></i> Son Bir Adım Kaldı</span>
        </div>
    </div>
    <div class="card-content">
        <form action="" method="post">
            <div class="form-group">
                @foreach($methods as $method)
                    {{ $method }}
                @endforeach
            </div>
            <div class="text-center mt-3">
                <div class="col-12 row-stack">
                    <button class="btn btn-transparent btnPay" name="send" value="1">Makbuzu Öde</button>
                </div>
            </div>
        </form>
    </div>
</div>
<div id="dataContent">

</div>
@endsection
@section('js')
<script>
    var method = "",timer = null;
    $(".payment-options").on("click",function(){
        if(timer){
            clearInterval(timer);
        }
        $(".payment-options.active").removeClass("active");
        $(this).addClass("active");
        method = $(this).data("method")
        timer = setInterval(function(){
            $(".btnPay").trigger("click");
        },2000);
    });
    var wait = false;
    $(".btnPay").on("click",function(){
        beClassRequestItem($(this),"{{ beGetRoute('client.invoice.invoice.post') }}",{iid:{{ $invoice['iid'] }},method:method});
		return false;
    });
</script>
@endsection
