@extend('clientarea.layout')
@section('title')Bildirim Kayıtlarım - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-notification-line"></i> Bildirim Kayıtlarım</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Kayıt No</th>
                    <th style="width:25%">Bildirim</th>
                    <th>Gönderen</th>
                    <th>Durum</th>
                    <th>Tarih</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @if($items)
                @foreach($items as $item)
                @php $ainfo = json_decode($item['ainfo'],true); @endphp
                <tr>
                    <td>
                        <span># dPa-{{ $item['aid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <a href="{{ beGetRoute('client.alert',['aid' => $item['aid']]) }}" target="_blank"><span class="first-row">{{ $ainfo['message'] }}</span></a>
                        </div>
                    </td>
                    <td>
                        <span class="first-row">{{ beSpecialTime($item['adateline']) }}</span>
                    </td>
                    <td>
                        @if($item['astatus'] == 1)
                        <span class="text-success">Okundu({{ beSpecialTime($item['areadtime']) }})</span>
                        @else
                        <span class="text-danger">Okunmadı</span>
                        @endif
                    </td>
                    <td>
                        <span class="first-row">{{ beSpecialTime($item['adateline']) }}</span>
                    </td>
                    <td>
                        <div class="buttons">
                            <a href="{{ beGetRoute('client.alert',['aid' => $item['aid']]) }}" class="btn btn-transparent btn-sm">
                                <i class="ri-eye-line"></i>
                                Görüntüle
                            </a>
                        </div>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
@if($itemcount > 15)
<div class="card row-flex row-center">
    {{ $paganation['paganation'] }}
</div>
@endif
@endsection