@extend('clientarea.layout')
@section('title')E-Mail Kayıtlarım - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-mail-send-line"></i> E-Mail Kayıtlarım</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Kayıt No</th>
                    <th>Başlık</th>
                    <th>Tarih</th>
                </tr>
            </thead>
            <tbody>
                @if($items)
                @foreach($items as $item)
                <tr>
                    <td>
                        <span># dPm-{{ $item['mid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $item['msubject'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span class="first-row">{{ beSpecialTime($item['mdateline']) }}</span>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
@if($itemcount > 15)
<div class="card row-flex row-center">
    {{ $paganation['paganation'] }}
</div>
@endif
@endsection