@extend('clientarea.layout')
@section('title')Yeni Destek Talebi Oluştur - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-coupon-3-line"></i> Yeni Talep Oluştur</span>
        </div>
    </div>
    <div class="card-content">
        <form id="beTicketForm">
            <div class="row">
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Talep Başlığı</label>
                        <input type="text" class="form-control" name="subject" required="required" placeholder="Destek Talebi Basliginiz">
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Departman</label>
                        <select class="form-control" name="depertment">
                            @foreach($depertments as $depertment)
                            <option value="{{ $depertment['tdid'] }}">{{ $depertment['tdname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Hizmet</label>
                        <select class="form-control" name="userproduct">
                            <option value="0">Hizmet Seçiniz</option>
                            @foreach($userproducts as $userproduct)
                            <option value="{{ $userproduct['upid'] }}">{{ $userproduct['upname'].' # '.$userproduct['uptag'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Mesaj İçeriği</label>
                        <textarea class="form-control" name="message" id="messageArea" rows="8" placeholder="Talep içeriğini giriniz"></textarea>
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beSendTicket">Gönder</a>
                </div>
                @if($ticket_user_files)
                <div class="col-12">
                    <div class="form-group">
                        <label for="#">Dosya Yükle</label>
                        <input type="file" id="fileUpload" multiple>
                    </div>
                    <div class="row flex-column p-3" id="uploadList">

                    </div>
                </div>
                @endif
            </div>
        </form>
    </div>
</div>
@endsection
@section('js')
<script>
    var counter = 0;
    /*var options = {
        selector: "#messageArea",
        height: "480",
        entity_encoding: "raw"
    };
    tinymce.init(options);*/
    $(".beSendTicket").on("click",function(){
        var data = $("#beTicketForm").serialize();
        for(let i = 0; i < counter+1; i++){
            var aid = $("#uploadItemProcess"+i).data("aid");
            if(aid){
                data += "&aidlist[]="+aid;
            }
        }
        beClassRequestItem($(this),"{{ beGetRoute('client.ticket.newticket.post') }}",data);
        return false;
    });
    @if($ticket_user_files)
    $("#fileUpload").change(function(e){
        uploadFiles(e.target.files);
    });
    $("#uploadList").on("click",".btnDeleteUploadItem",function(){
        var aid = $(this).data("aid");
        var key = $(this).data("key");
        $.ajax({
            url: "{{ beGetRoute('client.file.delete') }}",
            type: "post",
            async: true,
            data: {aid:aid},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    $("#uploadItem"+key).remove();
                }
                else{
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    });
    function uploadFiles(files){
        var formdata = null;
        var length = files.length;
        var i;
        for (i = 0; i < length; i++) {
            formdata = new FormData();
            counter += 1;
            formdata.append("file",files[i]);
            uploadFile(formdata,counter);
            $("#uploadList").append('\
                <div class="card card-blue col-md-12 mb-3 p-3" id="uploadItem'+counter+'">\
                    <div>\
                        <span>'+files[i]["name"]+'<span>\
                        <span class="d-block">'+Number((files[i]["size"]/1000000).toFixed(1))+' MB<span>\
                    </div>\
                    <div>\
                        <div class="row-flex flex-column w-100">\
                            <div class="row-flex row-space mt-3 mb-2 w-100">\
                                <span class="fw-bold fs-6" id="uploadItemProgess'+counter+'">0%</span>\
                                <a data-bs-toggle="tooltip" title="Sil" class="btn btn-danger btnDeleteUploadItem" id="uploadItemProcess'+counter+'">\
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="15" fill="currentColor"><path fill="none" d="M0 0h24v24H0z"></path><path d="M7 4V2h10v2h5v2h-2v15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6H2V4h5zM6 6v14h12V6H6zm3 3h2v8H9V9zm4 0h2v8h-2V9z"></path></svg>\
                                </a>\
                            </div>\
                        </div>\
                    </div>\
                </div>\
            ');
        }	
    }
    function uploadFile(file,i){
        $.ajax({
            url: "{{ beGetRoute('client.file.upload') }}",
            type : "post",
            data : file,
            contentType : false,
            processData : false,
            dataType : "json",
            crossDomain: true,
            xhr: function() {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener("progress",function(e){
                    if(e.lengthComputable){
                        var percentComplete = (e.loaded/e.total)*100;
                        $("#uploadItemProgess"+i).html(Number((percentComplete).toFixed())+"%");
                    }
                }, false);
                return xhr;
            },
            success:function(response){
                if(response.status){
                    $("#uploadItemProcess"+i).attr("data-aid",response.aid);
                    $("#uploadItemProcess"+i).attr("data-key",i);
                }
                else{
                    $("#uploadItem"+i).removeClass("bg-light-primary").addClass("bg-light-danger");
                    Swal.fire("Bir Hata Oluştu",response.message,"error");
                }
            }
        });
    }
    @endif
</script>
@endsection