@extend('clientarea.layout')
@section('title')Destek Taleplerim - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-git-repository-line"></i> Aktif Destek Taleplerim</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Talep No</th>
                    <th>Talep</th>
                    <th>Durum</th>
                    <th>Son Cevap</th>
                    <th>Departman</th>
                    <th>Tarih</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @if($ticketsactive)
                @foreach($ticketsactive as $ticket)
                <tr>
                    <td>
                        <span># dPt-{{ $ticket['tid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $ticket['tsubject'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span class="btn btn-{{ $ticketstatus[$ticket['tstatus']][1] }}">
                            {{ $ticketstatus[$ticket['tstatus']][0] }}
                        </span>
                    </td>
                    <td>
                        <span class="btn btn-special">
                            {{ $ticketreplystatus[$ticket['tlastreply']][0] }}
                        </span>
                    </td>
                    <td>
                        <span class="first-row">{{ $depertmens[$ticket['tdepertment']]['tdname'] }}</span>
                    </td>
                    <td>
                        <span class="first-row">{{ beSpecialTime($ticket['tdateline']) }}</span>
                    </td>
                    <td>
                        <div class="buttons">
                            <a href="{{ beGetRoute('client.ticket.ticket',['tid' => $ticket['tid']]) }}" class="btn btn-transparent btn-sm">
                                <i class="ri-eye-line"></i>
                                Görüntüle
                            </a>
                        </div>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
<div class="card mb-5">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-git-repository-line"></i> Kapatılmış Destek Taleplerim</span>
        </div>
    </div>
    <div class="card-content">
        <table class="btable">
            <thead>
                <tr>
                    <th>Talep No</th>
                    <th>Talep</th>
                    <th>Durum</th>
                    <th>Departman</th>
                    <th>Tarih</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @if($ticketsclose)
                @foreach($ticketsclose as $ticket)
                <tr>
                    <td>
                        <span># dPt-{{ $ticket['tid'] }}</span>
                    </td>
                    <td>
                        <div>
                            <span class="first-row">{{ $ticket['tsubject'] }}</span>
                        </div>
                    </td>
                    <td>
                        <span class="btn btn-special">
                            {{ $ticketstatus[$ticket['tstatus']][0] }}
                        </span>
                    </td>
                    <td>
                        <span class="first-row">{{ $depertmens[$ticket['tdepertment']]['tdname'] }}</span>
                    </td>
                    <td>
                        <span class="first-row">{{ beSpecialTime($ticket['tdateline']) }}</span>
                    </td>
                    <td>
                        <div class="buttons">
                            <a href="{{ beGetRoute('client.ticket.ticket',['tid' => $ticket['tid']]) }}" class="btn btn-transparent btn-sm">
                                <i class="ri-eye-line"></i>
                                Görüntüle
                            </a>
                        </div>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="6">
                        <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                    </td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
@endsection