@extend('clientarea.layout')
@section('title')Kullanıcı Ayarlarım - {{ beGetConfig('sitename') }}@endsection
@section('content')
<div class="card mb-3">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-git-repository-private-line"></i> Kullanıcı Ayarları</span>
        </div>
    </div>
    <div class="card-content">
        <form id="beLanguageForm">
            <div class="row">
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Sistem Dili</label>
                        <select class="form-control" name="language">
                            @foreach($languages as $language)
                            <option value="{{ $language['lid'] }}"{{ $be->user['lid'] == $language['lid'] ? ' selected':'' }}>{{ $language['lname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beCallRequest" data-form="beLanguage" data-url="{{ beGetRoute('client.set.language.post') }}">Değiştir</a>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="card mb-3">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-git-repository-private-line"></i> Şifremi Değiştir</span>
        </div>
    </div>
    <div class="card-content">
        <form id="bePasswordForm">
            <div class="row">
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Eski Şifreniz</label>
                        <input type="password" class="form-control" name="oldpassword" required="required">
                    </div>
                </div>
                <div class="col-12">
                    <hr>
                </div>
                <div class="col-12 mb-3">
                    <div class="form-group form-group-button">
                        <label for="#">Yeni Şifreniz</label>
                        <div class="form-input-area">
                            <input type="text" class="form-control set-password" name="password1"  required="required">
                            <button class="btn btn-special beCreatePassword" data-area=".set-password">Şifre Üret</button>
                        </div>
                    </div>
                </div>
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Yeni Şifreniz Tekrar</label>
                        <input type="password" class="form-control set-password" name="password2" required="required">
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beCallRequest" data-form="bePassword" data-url="{{ beGetRoute('client.change.password.post') }}">Değiştir</a>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="card">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-map-pin-line"></i> Adresimi Güncelle</span>
        </div>
    </div>
    <div class="card-content">
        <form id="beAddressForm">
            <div class="row">
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Adres Bilgisi</label>
                        <textarea class="form-control" name="address" rows="8" placeholder="Talep içeriğini giriniz">{{ $data['userinfo']['uiaddress'] }}</textarea>
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beCallRequest" data-form="beAddress" data-url="{{ beGetRoute('client.change.address.post') }}">Güncelle</a>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@foreach($data['plugindata']['pluginstemplate'] as $template)
{{ $template }}
@endforeach

@section('js')

@foreach($data['plugindata']['pluginsscript'] as $script)
{{ $script }}
@endforeach

@endsection