<!DOCTYPE html>
<html xml:lang="tr" lang="tr" xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta charset="UTF-8">
        <title>{{ $title }}</title>
        {{ $headerinclude }}
        <link href="assets/betheme/css/clientarea.css?ver=24" rel="stylesheet">
        <link href="assets/betheme/css/card.css?ver=22" rel="stylesheet">
        <link href="assets/betheme/css/col.css?ver=16" rel="stylesheet">
        <link href="assets/betheme/css/forms.css?ver=21" rel="stylesheet">
        @yield('headerinclude')
    </head>
    <body>
        <main>
            {{ $header }}
            <div class="content">
                <div class="container-xxl bclientarea">
                    <div class="col-3 col-md-12">
                        @foreach($menus as $menu)
                        <div class="bmenu">
                            <div class="bmenu-header">
                                <span>{{ $menu['name'] }}</span>
                            </div>
                            <div class="bmenu-content">
                                <ul>
                                    @foreach($menu['menuitems'] as $menuitem)
                                    <li>
                                        @if($menuitem['altmenu'])
                                        <a href="#" class="bmenu-altmenu-button">
                                            <div>
                                                {{ $menuitem['icon'] }}
                                                <span>{{ $menuitem['name'] }}</span>
                                            </div>
                                            <div>
                                                <i class="ri-arrow-down-s-line"></i>
                                            </div>
                                        </a>
                                        <div class="bmenu-altmenu">
                                            <ul>
                                                @foreach($menuitem['altmenu'] as $altmenuitem)
                                                @if(!$altmenuitem['showmenu'])
                                                @php continue; @endphp
                                                @endif
                                                <li class="has-mainmenu">
                                                    <a href="{{ $altmenuitem['url'] }}"  class="{{ $altmenuitem['class'] }}" {{ $altmenuitem['extra'] }}>
                                                        <div>
                                                            {{ $altmenuitem['icon'] }}
                                                            <span>{{ $altmenuitem['name'] }}</span>
                                                        </div>
                                                    </a>
                                                </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                        @else
                                        <a href="{{ $menuitem['url'] }}" class="{{ $menuitem['class'] }}" {{ $menuitem['extra'] }}>
                                            <div>
                                                {{ $menuitem['icon'] }}
                                                <span>{{ $menuitem['name'] }}</span>
                                            </div>
                                        </a>
                                        @endif
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        @endforeach
                        <div class="bmenu">
                            <div class="bmenu-header">
                                <span>Hızlı Erişim</span>
                            </div>
                            <div class="bmenu-content">
                                <ul>
                                    <li data-page="client.dashboard.alternative">
                                        <a href="{{ beGetRoute('client.dashboard.alternative') }}">
                                            <div>
                                                <i class="ri-service-line"></i>
                                                <span>Ana Sayfa</span>
                                            </div>
                                        </a>
                                    </li>
                                    @if($userproduct['pupgrade'])
                                    <li data-page="client.dashboard.alternative">
                                        <a href="{{ beGetRoute('client.userproduct.userproduct.upgrade',['upid' => $userproduct['upid']]) }}">
                                            <div>
                                                <i class="ri-upload-cloud-2-fill"></i>
                                                <span>Hizmetimi Yükselt</span>
                                            </div>
                                        </a>
                                    </li>
                                    @endif
                                    <li data-page="client.dashboard.alternative">
                                        <a href="{{ beGetRoute('client.userproduct.userproduct.cancellation',['upid' => $userproduct['upid']]) }}">
                                            <div>
                                                <i class="ri-close-circle-line"></i>
                                                <span>Hizmetimi İptal Et</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li data-page="client.userproduct.userproducts">
                                        <a href="{{ beGetRoute('client.userproduct.userproducts') }}">
                                            <div>
                                                <i class="ri-shopping-cart-line"></i>
                                                <span>Hizmetlerim</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="has-mainmenu" data-page="client.ticket.tickets" data-mainmenu="clientarea-ticketmenu">
                                        <a href="{{ beGetRoute('client.ticket.tickets') }}">
                                            <div>
                                                <i class="ri-ticket-line"></i>
                                                <span>Destek Taleplerim</span>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="has-mainmenu" data-page="client.ticket.newticket" data-mainmenu="clientarea-ticketmenu">
                                        <a href="{{ beGetRoute('client.ticket.newticket') }}">
                                            <div>
                                                <i class="ri-coupon-3-line"></i>
                                                <span>Yeni Destek Talebi</span>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-9 col-md-12">
                        <div class="bcontent">
                            {{ $content }}
                        </div>
                    </div>
                </div>
            </div>
            @yield('js')
            <script>
                $(document).ready(function(){
                    var routename = "{{ beGetRouteName() }}";
                    var item = $("li[data-page='"+routename+"']");
                    if(item.hasClass("has-mainmenu")){
                        $("#"+item.data("mainmenu")).trigger("click");
                    }
                    item.addClass("active");
                });
            </script>
            {{ $footer }}
        </main>
    </body>
</html>