<!DOCTYPE html>
<html lang="tr">
    <head>
        <base href="{{ beGetConfig('siteurl') }}">
        <title>DiyoCP Sistemine Hoşgeldiniz</title>
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1" />
		<link rel="shortcut icon" href="assets/media/logos/favicon.ico" />
		<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
		<link href="assets/plugins/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet" type="text/css" />
		<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
		<link href="assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
		<link href="assets/css/style.bundle.css?v=3" rel="stylesheet" type="text/css" />
    </head>
	<body data-kt-name="metronic" id="kt_body" class="header-tablet-and-mobile-fixed aside-enabled">
	<script>if ( document.documentElement ) { const defaultThemeMode = "system"; const name = document.body.getAttribute("data-kt-name"); let themeMode = localStorage.getItem("kt_" + ( name !== null ? name + "_" : "" ) + "theme_mode_value"); if ( themeMode === null ) { if ( defaultThemeMode === "system" ) { themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light"; } else { themeMode = defaultThemeMode; } } document.documentElement.setAttribute("data-theme", themeMode); }</script>
	<div class="d-flex flex-column flex-root">
		<div class="page d-flex flex-row flex-column-fluid">
			<div class="d-flex flex-column flex-row-fluid" id="kt_wrapper">
				<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
					<div class="post d-flex flex-column-fluid" id="kt_post">
						<div id="kt_content_container" class="container-xxl">
							<div class="stepper stepper-pills stepper-column d-flex flex-column flex-xl-row flex-row-fluid" id="kt_create_account_stepper">
								<div class="card d-flex justify-content-center justify-content-xl-start flex-row-auto w-100 w-xl-300px w-xxl-400px me-9">
									<div class="card-body px-6 px-lg-10 px-xxl-15 py-20">
										<div class="stepper-nav">
											<div class="stepper-item current" data-kt-stepper-element="nav">
												<div class="stepper-wrapper">
													<div class="stepper-icon w-40px h-40px">
														<i class="stepper-check fas fa-check"></i>
														<span class="stepper-number">1</span>
													</div>
													<div class="stepper-label">
														<h3 class="stepper-title">DiyoCP</h3>
														<div class="stepper-desc fw-semibold">DiyoCP Hakkında Bilgilendirme</div>
													</div>
												</div>
												<div class="stepper-line h-40px"></div>
											</div>
											<div class="stepper-item" data-kt-stepper-element="nav">
												<div class="stepper-wrapper">
													<div class="stepper-icon w-40px h-40px">
														<i class="stepper-check fas fa-check"></i>
														<span class="stepper-number">2</span>
													</div>
													<div class="stepper-label">
														<h3 class="stepper-title">Lisans</h3>
														<div class="stepper-desc fw-semibold">Lisans Kurulumu</div>
													</div>
												</div>
												<div class="stepper-line h-40px"></div>
											</div>
											<div class="stepper-item" data-kt-stepper-element="nav">
												<div class="stepper-wrapper">
													<div class="stepper-icon w-40px h-40px">
														<i class="stepper-check fas fa-check"></i>
														<span class="stepper-number">3</span>
													</div>
													<div class="stepper-label">
														<h3 class="stepper-title">Kullanıcı Bilgileri</h3>
														<div class="stepper-desc fw-semibold">Hesap Oluşturun</div>
													</div>
												</div>
												<div class="stepper-line h-40px"></div>
											</div>
											<div class="stepper-item" data-kt-stepper-element="nav">
												<div class="stepper-wrapper">
													<div class="stepper-icon w-40px h-40px">
														<i class="stepper-check fas fa-check"></i>
														<span class="stepper-number">4</span>
													</div>
													<div class="stepper-label">
														<h3 class="stepper-title">Tamamlandı</h3>
														<div class="stepper-desc fw-semibold">Kurulumu Bitirdik!</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="card d-flex flex-row-fluid flex-center">
									<form class="card-body py-20 w-100 w-xl-700px px-9" novalidate="novalidate" id="kt_create_account_form">
										<div class="current" data-kt-stepper-element="content">
											<div class="w-100">
												<div class="pb-10 pb-lg-15">
													<h2 class="fw-bold d-flex align-items-center text-dark">DiyoCP Satış Yönetim Sistemi</h2>
													<div class="text-muted fw-semibold fs-6">Sistem hakkında bilgilendirme</div>
												</div>
												<div class="fv-row">
													<div class="row">
														<div class="col-lg-12">
															<div class="pb-lg-20">
																<div class="fs-4 fw-semibold text-gray-700 mb-13">
                                                                DiyoCP, müşterileriniz hizmet almasını otomatikleştirmek, zamanında ödemelerinizi almak. Her şeyin otomatik olarak sistem taraflı yapılması için geliştirilmiş bir sistemdir. Bu sistemde temel ayarlar yapıldıktan sonra tüm işleyiş otomatiktir. Kolay ve anlaşılır yönetim paneli, hızlandırılmış yönetim otomasyonları ile müşterilerinize en üst seviyede deneyim sunmaya hazır mısınız?
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div data-kt-stepper-element="content">
											<div class="w-100">
												<div class="pb-10 pb-lg-15">
													<h2 class="fw-bold text-dark">Lisans İzinleri</h2>
													<div class="text-muted fw-semibold fs-6">Lisans sistemin korunması ve sürekliliği için gereklidir!</div>
												</div>
												<div class="mb-10 fv-row">
													<label class="form-label mb-3">Lisans Erişim Anahtarı</label>
													<input type="text" class="form-control form-control-lg form-control-solid" name="lisance_key" placeholder="Lisans anahtarınızı bu alana giriniz"/>
												</div>
											</div>
										</div>
										<div data-kt-stepper-element="content">
											<div class="w-100">
												<div class="pb-10 pb-lg-12">
													<h2 class="fw-bold text-dark">Admin Hesabı Oluşturun</h2>
												</div>
												<div class="fv-row mb-10">
													<label class="form-label required">Adınız</label>
													<input name="name" class="form-control form-control-lg form-control-solid" placeholder="Adınızı giriniz" />
												</div>
												<div class="fv-row mb-10">
													<label class="form-label required">Soy Adınız</label>
													<input name="surname" class="form-control form-control-lg form-control-solid" placeholder="Soy adınızı giriniz" />
												</div>
												<div class="fv-row mb-10">
													<label class="form-label required">E-Posta Adresi</label>
													<input name="email" class="form-control form-control-lg form-control-solid" placeholder="E-Posta adresinizi giriniz" />
												</div>
												<div class="fv-row mb-10">
													<label class="form-label required">Şifre</label>
													<input name="password1" type="password" class="form-control form-control-lg form-control-solid" placeholder="Şifrenizi giriniz" />
												</div>
												<div class="fv-row mb-10">
													<label class="form-label required">Şifre Tekrar</label>
													<input name="password2" type="password" class="form-control form-control-lg form-control-solid" placeholder="Şifrenizi giriniz" />
												</div>
											</div>
										</div>
										<div data-kt-stepper-element="content">
											<div class="w-100">
												<div class="pb-8 pb-lg-10">
													<h2 class="fw-bold text-dark">Nerdeyse Bitti</h2>
												</div>
												<div class="mb-0">
													<div class="fs-6 text-gray-600 mb-5"></div>
													<div class="notice d-flex bg-light-warning rounded border-warning border border-dashed p-6">
														<span class="svg-icon svg-icon-2tx svg-icon-warning me-4">
															<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
																<rect opacity="0.3" x="2" y="2" width="20" height="20" rx="10" fill="currentColor" />
																<rect x="11" y="14" width="7" height="2" rx="1" transform="rotate(-90 11 14)" fill="currentColor" />
																<rect x="11" y="17" width="2" height="2" rx="1" transform="rotate(-90 11 17)" fill="currentColor" />
															</svg>
														</span>
														<div class="d-flex flex-stack flex-grow-1">
															<div class="fw-semibold">
																<h4 class="text-gray-900 fw-bold">Tüm işlemleri başlat!</h4>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="d-flex flex-stack pt-10">
											<div class="mr-2">
												<button type="button" class="btn btn-lg btn-light-primary me-3" data-kt-stepper-action="previous">
												<span class="svg-icon svg-icon-4 me-1">
													<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
														<rect opacity="0.5" x="6" y="11" width="13" height="2" rx="1" fill="currentColor" />
														<path d="M8.56569 11.4343L12.75 7.25C13.1642 6.83579 13.1642 6.16421 12.75 5.75C12.3358 5.33579 11.6642 5.33579 11.25 5.75L5.70711 11.2929C5.31658 11.6834 5.31658 12.3166 5.70711 12.7071L11.25 18.25C11.6642 18.6642 12.3358 18.6642 12.75 18.25C13.1642 17.8358 13.1642 17.1642 12.75 16.75L8.56569 12.5657C8.25327 12.2533 8.25327 11.7467 8.56569 11.4343Z" fill="currentColor" />
													</svg>
												</span>
												Geri</button>
											</div>
											<div>
												<button type="button" class="btn btn-lg btn-primary me-3" data-kt-stepper-action="submit">
													<span class="indicator-label">Oluştur
													<span class="svg-icon svg-icon-3 ms-2 me-0">
														<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
															<rect opacity="0.5" x="18" y="13" width="13" height="2" rx="1" transform="rotate(-180 18 13)" fill="currentColor" />
															<path d="M15.4343 12.5657L11.25 16.75C10.8358 17.1642 10.8358 17.8358 11.25 18.25C11.6642 18.6642 12.3358 18.6642 12.75 18.25L18.2929 12.7071C18.6834 12.3166 18.6834 11.6834 18.2929 11.2929L12.75 5.75C12.3358 5.33579 11.6642 5.33579 11.25 5.75C10.8358 6.16421 10.8358 6.83579 11.25 7.25L15.4343 11.4343C15.7467 11.7467 15.7467 12.2533 15.4343 12.5657Z" fill="currentColor" />
														</svg>
													</span>
													<span class="indicator-progress">Bekleyin..
													<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
												</button>
												<button type="button" class="btn btn-lg btn-primary" data-kt-stepper-action="next">İleri
													<span class="svg-icon svg-icon-4 ms-1 me-0">
														<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
															<rect opacity="0.5" x="18" y="13" width="13" height="2" rx="1" transform="rotate(-180 18 13)" fill="currentColor" />
															<path d="M15.4343 12.5657L11.25 16.75C10.8358 17.1642 10.8358 17.8358 11.25 18.25C11.6642 18.6642 12.3358 18.6642 12.75 18.25L18.2929 12.7071C18.6834 12.3166 18.6834 11.6834 18.2929 11.2929L12.75 5.75C12.3358 5.33579 11.6642 5.33579 11.25 5.75C10.8358 6.16421 10.8358 6.83579 11.25 7.25L15.4343 11.4343C15.7467 11.7467 15.7467 12.2533 15.4343 12.5657Z" fill="currentColor" />
														</svg>
													</span>
												</button>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
                    <div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
                        <span class="svg-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <rect opacity="0.5" x="13" y="6" width="13" height="2" rx="1" transform="rotate(90 13 6)" fill="currentColor" />
                                <path d="M12.5657 8.56569L16.75 12.75C17.1642 13.1642 17.8358 13.1642 18.25 12.75C18.6642 12.3358 18.6642 11.6642 18.25 11.25L12.7071 5.70711C12.3166 5.31658 11.6834 5.31658 11.2929 5.70711L5.75 11.25C5.33579 11.6642 5.33579 12.3358 5.75 12.75C6.16421 13.1642 6.83579 13.1642 7.25 12.75L11.4343 8.56569C11.7467 8.25327 12.2533 8.25327 12.5657 8.56569Z" fill="currentColor" />
                            </svg>
                        </span>
                    </div>
                    <script>var hostUrl = "assets/";</script>
                    <script src="assets/plugins/global/plugins.bundle.js"></script>
                    <script src="assets/js/scripts.bundle.js"></script>
                    <script src="assets/plugins/custom/fullcalendar/fullcalendar.bundle.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/percent.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/radar.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/map.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/geodata/worldLow.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/geodata/continentsLow.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/geodata/usaLow.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/geodata/worldTimeZonesLow.js"></script>
                    <script src="https://cdn.amcharts.com/lib/5/geodata/worldTimeZoneAreasLow.js"></script>
                    <script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
                    <script src="assets/js/widgets.bundle.js"></script>
                    <script src="assets/js/custom/widgets.js"></script>
                    <script src="assets/js/custom/apps/chat/chat.js"></script>
                    <script src="assets/js/custom/utilities/modals/users-search.js"></script>
                    <script>
                        "use strict";
                        var KTCreateAccount = (function () {
                            var e,t,i,o,r,s,n = [];
                            return {
                                init: function () {
                                    (e = document.querySelector("#kt_modal_create_account")) && new bootstrap.Modal(e),
                                        (t = document.querySelector("#kt_create_account_stepper")) &&
                                            ((i = t.querySelector("#kt_create_account_form")),
                                            (o = t.querySelector('[data-kt-stepper-action="submit"]')),
                                            (r = t.querySelector('[data-kt-stepper-action="next"]')),
                                            (s = new KTStepper(t)).on("kt.stepper.changed", function (e) {
                                                4 === s.getCurrentStepIndex()
                                                    ? (o.classList.remove("d-none"), o.classList.add("d-inline-block"), r.classList.add("d-none"))
                                                    : 5 === s.getCurrentStepIndex()
                                                    ? (o.classList.add("d-none"), r.classList.add("d-none"))
                                                    : (o.classList.remove("d-inline-block"), o.classList.remove("d-none"), r.classList.remove("d-none"));
                                            }),
                                            s.on("kt.stepper.next",function(e){
                                                var step = e.getCurrentStepIndex();
												$.ajax({
													url: "{{ beGetRoute('install.post') }}",
													type: "post",
													data: $("#kt_create_account_form").serialize()+"&action=checkstep&step="+step,
													async: true,
													dataType: "json",
													crossDomain: true,
													success: function(response){
														if(response.status){
															e.goNext();
                                                			KTUtil.scrollTop();
														}	
														else{
															Swal.fire("Bir Hata Oluştu",response.message,"error");
														}
													}
												});	
                                            }),
                                            s.on("kt.stepper.previous", function (e) {
                                                e.goPrevious(), KTUtil.scrollTop();
                                            }),
                                            o.addEventListener("click", function (e) {
												$.ajax({
													url: "{{ beGetRoute('install.post') }}",
													type: "post",
													data: $("#kt_create_account_form").serialize()+"&action=create",
													async: true,
													dataType: "json",
													crossDomain: true,
													success: function(response){
														if(response.status){
															Swal.fire("Başarılı",response.message,"success");
															setTimeout(function(){
																window.location.href = response.url;
															},1000);
														}	
														else{
															Swal.fire("Bir Hata Oluştu",response.message,"error");
														}
													}
												});	
                                            })
                                        );
                                },
                            };
                        })();
                        KTUtil.onDOMContentLoaded(function () {
                            KTCreateAccount.init();
                        });
                    </script>
				</div>
			</div>
		</div>
	</body>
</html>