<div class="row">
    <div class="col-12">

    @foreach($iplist as $ip)
        <div class="card mb-3">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('manage_ip') }}</span>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>Süreç</th>
                            <th>{{ __('ippage_rdns_ip') }}</th>
                            <th>{{ __('ippage_rdns_type') }}</th>
                            <th>{{ __('ippage_rdns_content') }}</th>
                            <th>{{ __('ippage_rdns_priority') }}</th>
                            <th>{{ __('ippage_rdns_ttl') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($rdnslist)
                        @foreach($rdnslist as $rdns)
                        @if($rdns['iid'] == $ip['iid'])
                        <tr>
                            <td>
                                <div class="row-flex row-center">
                                    <a href="#" class="btn btn-sm btn-primary {{ $rdnsstatuslist[$rdns['rstatus']]['color'] }}">{{ $rdnsstatuslist[$rdns['rstatus']]['name'] }}</a>
                                </div>
                            </td>
                            <td>{{ $ip['iaddress'] }}</td>
                            <td>{{ $rdns['rtype'] }}</td>
                            <td>{{ $rdns['rdns'] }}</td>
                            <td>{{ $rdns['rpriority'] }}</td>
                            <td>{{ $rdns['rttl'] }}</td>
                            <td>
                                <div class="row-flex row-end row-align">
                                    <a href="{{ $url.'/rdns-kaydi-duzenle?rid='.$rdns['rid'] }}" class="btn btn-primary btn-sm be_button">{{ __('global_edit') }}</a>
                                    <a href="#" class="btn btn-warning btn-sm ml-1 beCallRequestx" data-method="rnds_delete" data-data="rid={{ $rdns['rid'] }}">{{ __('global_delete') }}</a>
                                </div>
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @else
                        <tr>
                            <td colspan="7">
                                <div class="my-3">Bu kısımda gösterilicek bir veri bulunamadı!</div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
        @endforeach

    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>