<style>
    .infoboxex {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .infobox {
        padding: 10px 14px;
        border-radius: 10px;
        box-shadow: 0 0 5px #e3e3e3;
        background-color: #ffff;
    }
    .infobox .name {
        margin-bottom: 14px;
        font-size: 16px;
    }
    .infobox i {
        margin-right: 4px;
    } 
    .infobox .value {
        font-size: 18px;
    }
    .accounting .finance {
        font-size: 32px;
    }
    .accounting .nextdue {
        font-size: 12px;
    }
    .besr_circle_chart {
        display: block;
        margin: 10px auto;
        max-height: 140px;
    }
    .besr_circle_bg {
        fill: none;
        stroke: #eee;
        stroke-width: 3.8;
    }
    .besr_circle {
        fill: none;
        stroke-width: 2.8;
        stroke-linecap: round;
        animation: progress 1s ease-out forwards;
    }
    @keyframes progress {
        0% {
            stroke-dasharray: 0 100;
        }
    }
    .besr_circle_percentage {
        fill: #59626d;
        font-size: 7px;
        text-anchor: middle;
    }
</style>
<div class="row row-center px-3">
    <div class="col-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-cpu-fill"></i> CPU</span>
                </div>
            </div>
            <div class="content text-center">
                <span class="text-hard">{{ $usageinfo['cpu_max'] }} MHZ</span>
            </div>
        </div>
    </div>
    <div class="col-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-keyboard-fill"></i> RAM</span>
                </div>
            </div>
            <div class="content text-center">
                <span class="text-hard">{{ $usageinfo['ram_max'] }} MB</span>
            </div>
        </div>
    </div>
    <div class="col-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-database-2-fill"></i> DISK</span>
                </div>
            </div>
            <div class="content text-center">
                <span class="text-hard">{{ $usageinfo['disk_max'] }} GB</span>
            </div>
        </div>
    </div>
    <div class="col-3">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-focus-3-fill"></i> Template</span>
                </div>
            </div>
            <div class="content text-center">
                @php
                    $extralogo = '';
                    if(preg_match('/windows/i',$vminfo['templatename'])){
                        $extralogo = 'ri-windows-line';
                    }
                    else if(preg_match('/ubuntu/i',$vminfo['templatename'])){
                        $extralogo = 'ri-ubuntu-line';
                    }
                    else if(preg_match('/centos/i',$vminfo['templatename'])){
                        $extralogo = 'ri-centos-line';
                    }
                    else if(preg_match('/ubuntu/i',$vminfo['templatename'])){
                        $extralogo = 'ri-ubuntu-line';
                    }
                @endphp
                @if($extralogo)
                <span class="text-hard"><i class="{{ $extralogo }}"></i>{{ $vminfo['templatename'] }}</span>
                @else
                <span class="text-hard">{{ $vminfo['templatename'] }}</span>
                @endif
            </div>
        </div>
    </div>
</div>
<div class="row my-3">
    <div class="col-8">
        <div class="row">
            <div class="col-6">
                <div class="card accounting">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-bank-line"></i> Muhasebe</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="row my-3">
                            <div class="col-6">
                                <span class="finance text-success">{{ beMoneyFormat($orderinfo['amount']).' '.$orderinfo['currencie']['cicon'] }}</span>
                            </div>
                            <div class="col-6 nextdue">
                                <span>Sonraki Ödeme Tarihi</span>
                                <span>{{ $orderinfo['nextduedate'] }}</span>
                            </div>
                        </div>
                        <hr>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span>{{ __('server_info_productname') }}</span>
                            </div>
                            <div class="col-6">
                                <span>{{ $orderinfo['product'] }}</span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span>{{ __('server_info_buydate') }}</span>
                            </div>
                            <div class="col-6">
                                <span>{{ $orderinfo['regdate'] }}</span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span>{{ __('server_info_basicprice') }}</span>
                            </div>
                            <div class="col-6">
                                <span>{{ beMoneyFormat($orderinfo['billingprice']).' '.$orderinfo['currencie']['cicon'] }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6">
                <div class="card accounting">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-earth-line"></i> İnternet</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="row my-2">
                            <div class="col-12">
                                <span>{{ __('server_info_ipaddress') }}:</span>
                            </div>
                            <div class="col-12 mt-1">
                                <span class="text-lg">{{ $vminfo['ipaddres'] }}<a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="{{ $vminfo['ipaddres'] }}"><i class="ri-clipboard-line"></i></a></span>
                            </div>
                            <div class="col-12 mt-1">
                                <a class="btn btn-primary btn-sm beCallRequestx" data-method="entegration" data-data="type=network">IPv4 Adreslerini Tekrar Ata!</a>
                            </div>
                        </div>
                        <hr>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span>Durum</span>
                            </div>
                            <div class="col-6">
                                <span class="text-{{ $vminfo['power'] == 1 ? 'success':'danger' }}">{{ $vminfo['power'] == 1 ? 'Bağlantı Mevcut':'Bağlanamadı' }}</span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span>Anlık Kullanım:</span>
                            </div>
                            <div class="col-6">
                                <span>{{ $usageinfo['network_usage'].' '.$usageinfo['network_type'] }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 my-3">
                <div class="card">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-line-chart-line"></i> Kullanım Bilgileri</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="row mb-3">
                            <div class="col-3">
                                <div class="text-center">{{ __('stats_cpu') }}</div>
                                <div class="besr_percent">
                                    <svg viewBox="0 0 36 36" class="besr_circle_chart">
                                        <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                                        <path class="besr_circle" id="cpuPercentPath" stroke-dasharray="{{ $usageinfo['cpu_percent'] }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: {{ $usageinfo['cpu_percent_color'] }}"/>
                                        <text class="besr_circle_percentage" x="18" y="20.35" id="cpuPercent">{{ $usageinfo['cpu_percent'] }}%</text>
                                    </svg>
                                </div>
                                <div class="text-center text-normal text-sm" id="cpuPercentText">{{ $usageinfo['cpu_usage'] }} {{ $usageinfo['cpu_type'] }} / {{ $usageinfo['cpu_max'] }} MHZ</div>
                            </div>
                            <div class="col-3">
                                <div class="text-center">{{ __('stats_ram') }}</div>
                                <div class="besr_percent">
                                    <svg viewBox="0 0 36 36" class="besr_circle_chart">
                                        <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                                        <path class="besr_circle" id="ramPercentPath" stroke-dasharray="{{ $usageinfo['ram_percent'] }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: {{ $usageinfo['ram_percent_color'] }}"/>
                                        <text class="besr_circle_percentage" x="18" y="20.35" id="ramPercent">{{ $usageinfo['ram_percent'] }}%</text>
                                    </svg>
                                </div>
                                <div class="text-center text-normal text-sm" id="ramPercentText">{{ $usageinfo['ram_usage'] }} {{ $usageinfo['ram_type'] }} / {{ $usageinfo['ram_max'] }} MB</div>
                            </div>
                            <div class="col-3">
                                <div class="text-center">{{ __('stats_disc') }}</div>
                                <div class="besr_percent">
                                    <svg viewBox="0 0 36 36" class="besr_circle_chart">
                                        <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                                        <path class="besr_circle" id="discPercentPath" stroke-dasharray="{{ $usageinfo['disk_percent'] }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: {{ $usageinfo['disc_percent_color'] }}"/>
                                        <text class="besr_circle_percentage" x="18" y="20.35" id="discPercent">{{ $usageinfo['disk_percent'] }}%</text>
                                    </svg>
                                </div>
                                <div class="text-center text-normal text-sm" id="discPercentText">{{ $usageinfo['disk_usage'] }} GB / {{ $usageinfo['disk_max'] }} GB</div>
                            </div>
                            <div class="col-3">
                                <div class="text-center">{{ __('stats_network') }}</div>
                                <div class="besr_percent">
                                    <svg viewBox="0 0 36 36" class="besr_circle_chart">
                                        <path class="besr_circle_bg" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831"/>
                                        <path class="besr_circle" id="netPercentPath" stroke-dasharray="0, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" style="stroke: #009ef7"/>
                                        <text class="besr_circle_percentage" x="18" y="20.35" id="netPercent">{{ $usageinfo['network_usage'].' '.$usageinfo['network_type'] }}</text>
                                    </svg>
                                </div>
                                <div class="text-center text-normal text-sm" id="netPercentText">{{ $usageinfo['network_usage'].' '.$usageinfo['network_type'] }}</div>
                            </div>
                        </div>
                        <div class="row row-center">
                            <span class="text-xsm">Veriler anlık olarak güncellenmektedir. Anlık güncellemelerden önceki son güncellenme {{ beSpecialTime(BE_TIME,' H:i:s') }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-4">
        <div class="card accounting">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-user-line"></i> Giriş Bilgileri</span>
                </div>
            </div>
            <div class="card-content">
                <div class="row mt-1">
                    <div class="col-12">
                        <span>{{ __('server_info_user') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>{{ $vminfo['username'] }}<a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="{{ $vminfo['username'] }}"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ __('server_info_password') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>{{ $vminfo['password'] }}<a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="{{ $vminfo['password'] }}"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ __('server_info_ipaddress') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>{{ $vminfo['ipaddres'] }}<a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="{{ $vminfo['ipaddres'] }}"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="text-center my-3">
                    <span class="text-xsm">Lütfen giriş bilgilerinizi hiç bir şahıs,firma ile paylaşmayınız! Sonuçlardan doğacak yükümlülüklerden {{ beGetConfig('sitename') }} sorumlu değildir!</span>
                </div>
            </div>
        </div>
        <div class="card my-3">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-server-line"></i> Sunucu Aktiflik Süresi</span>
                </div>
            </div>
            <div class="card-content">
                @php
                    $hour = round($vminfo['uptime']/60);
                    $day = 0;
                    while($hour > 24){
                        $day += 1;
                        $hour -= 24;	
                    }
                @endphp
                @if($day)
                <span class="text-hard">{{ $day }} Gün {{ $hour }} Saat</span>
                @else
                <span class="text-hard">{{ $hour }} Saat</span>
                @endif
            </div>
        </div>
        <div class="card my-3">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-server-line"></i> Sunucu İşlemleri</span>
                </div>
            </div>
            <div class="card-content">
                <div class="row">
                    @if($vminfo['power'] == 1)
                    <div class="col-4 mb-2 row-stack">
                        <a class="btn btn-warning" href="#"><i class="ri-stop-circle-line"></i> {{ __('manage_stop') }}</a>
                    </div>
                    <div class="col-8 mb-2 row-stack">
                        <a class="btn btn-primary" href="#"><i class="ri-restart-line"></i> {{ __('manage_restart') }}</a>
                    </div>
                    @else
                    <div class="col-6 mb-2 row-stack">
                        <a class="btn btn-success" href="#"><i class="ri-play-line"></i> {{ __('manage_start') }}</a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
    var more = true;
    setInterval(function(){ 
        if(more){
            more = false;
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: {action:"check_stat",upid:{{ $userproduct['upid'] }}},
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    $("#cpuPercentPath").get(0).setAttribute('stroke-dasharray',response.cpu_percent+", 100");
                    $("#cpuPercentPath").css("stroke",response.cpu_percent_color);
                    $("#cpuPercentText").html(response.cpu_usage+" "+response.cpu_type+" / "+response.cpu_max+" MHZ");
                    $("#cpuPercent").html(response.cpu_percent+"%");
                    $("#ramPercentPath").get(0).setAttribute('stroke-dasharray',response.ram_percent+", 100");
                    $("#ramPercentPath").css("stroke",response.ram_percent_color);
                    $("#ramPercentText").html(response.ram_usage+" "+response.ram_type+" / "+response.ram_max+"  MB");
                    $("#ramPercent").html(response.ram_percent+"%");
                    $("#discPercentPath").get(0).setAttribute('stroke-dasharray',response.disk_percent+", 100");
                    $("#discPercentPath").css("stroke",response.disc_percent_color);
                    $("#discPercentText").html(response.disk_usage+" GB / "+response.disk_max+" GB");
                    $("#discPercent").html(response.disk_percent+"%");
                    $("#netPercent").html(response.network_usage+" "+response.network_type);
                    $("#netPercentText").html(response.network_usage+" "+response.network_type);
                    more = true;
                }
            });	
        }	
    },10000);
    setTimeout(function(){
        location.reload();
    },300000)
</script>