<style>
    .infoboxex {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    .infobox {
        padding: 10px 14px;
        border-radius: 10px;
        box-shadow: 0 0 5px #e3e3e3;
        background-color: #ffff;
    }
    .infobox .name {
        margin-bottom: 14px;
        font-size: 16px;
    }
    .infobox i {
        margin-right: 4px;
    } 
    .infobox .value {
        font-size: 18px;
    }
    .accounting .finance {
        font-size: 32px;
    }
    .accounting .nextdue {
        font-size: 12px;
    }
    .besr_circle_chart {
        display: block;
        margin: 10px auto;
        max-height: 140px;
    }
    .besr_circle_bg {
        fill: none;
        stroke: #eee;
        stroke-width: 3.8;
    }
    .besr_circle {
        fill: none;
        stroke-width: 2.8;
        stroke-linecap: round;
        animation: progress 1s ease-out forwards;
    }
    @keyframes progress {
        0% {
            stroke-dasharray: 0 100;
        }
    }
    .besr_circle_percentage {
        fill: #59626d;
        font-size: 7px;
        text-anchor: middle;
    }
</style>
<div class="row row-center px-3">
    @if($invoice)
    <div class="col-12 mb-3">
        <div class="card" style="background-color:#f1416c">
            <div class="card-content p-3">
                <span class="text-white">
                Siparişiniz için ödenmemiş {{ $invoice['iname'] }} isminde {{ $invoice['iprice'] }} tutarında bir faturanız bulunmaktadır. Lütfen sipariş süreniz sona ermeden önce uzatım işlemini gerçekleştiriniz.
                </span>
            </div>
            <div class="p-3">
                <a href="{{ beGetRoute('client.invoice.invoice',['iid' => $invoice['iid']]) }}" class="btn btn-danger btn-sm mr-2">
                    <i class="ri-git-repository-line"></i>
                    Faturayı Görüntüle
                </a>
            </div>
        </div>
    </div>
    @endif
</div>
<div class="row mb-3">
    <div class="col-8 col-md-12">
        <div class="row">
            <div class="col-12 mb-3">
                <div class="card accounting">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-server-line"></i> {{ beGetLang('teamspeak_inspect') }}</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <ul>
                            @foreach($channellist as $channel)
                            <li>
                                {{ $channel['channel_name'] }}
                                @if($channel['clients'])
                                <ul class="ml-2 my-1">
                                    @foreach($channel['clients'] as $client)
                                    <li>
                                        <span>
                                            <img src="{{ $client['prefiximage'] }}" width="16" height="16">
                                            {{ $client['nickname'] }}
                                        </span>
                                    </li>
                                    @endforeach
                                </ul>
                                @endif
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-6 col-md-12 mb-3">
                <div class="card accounting">
                    <div class="card-header">
                        <div>
                            <span class="card-title"><i class="ri-bank-line"></i> {{ beGetLang('teamspeak_accounting') }}</span>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="row my-3">
                            <div class="col-6">
                                <span class="finance text-success">{{ beMoneyFormat($orderinfo['amount']).' '.$orderinfo['currencie']['cicon'] }}</span>
                            </div>
                            <div class="col-6 nextdue">
                                <span>Sonraki Ödeme Tarihi</span>
                                <span>{{ $orderinfo['nextduedate'] }}</span>
                            </div>
                        </div>
                        <hr>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span>{{ __('teamspeak_info_productname') }}</span>
                            </div>
                            <div class="col-6">
                                <span>{{ $orderinfo['product'] }}</span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span>{{ __('teamspeak_info_buydate') }}</span>
                            </div>
                            <div class="col-6">
                                <span>{{ $orderinfo['regdate'] }}</span>
                            </div>
                        </div>
                        <div class="row mt-1 nextdue">
                            <div class="col-6">
                                <span>{{ __('teamspeak_info_basicprice') }}</span>
                            </div>
                            <div class="col-6">
                                <span>{{ beMoneyFormat($orderinfo['billingprice']).' '.$orderinfo['currencie']['cicon'] }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-4 col-md-12">
        <div class="card accounting">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-user-line"></i> {{ beGetLang('teamspeak_info') }}</span>
                </div>
            </div>
            <div class="card-content">
                <div class="row">
                    <div class="col-12">
                        <span>{{ __('teamspeak_info_ipaddress') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>
                            {{ $serverdata['ip'].':'.$serverdata['port'] }}
                            <a href="ts3server://{{ $serverdata['ip'] }}?port={{ $serverdata['port'] }}" class="text-sm text-success ml-1" title="Giriş Yap"><i class="ri-login-box-line"></i></a>
                            <a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="{{ $serverdata['ip'].':'.$serverdata['port'] }}"><i class="ri-clipboard-line"></i></a></span>
                        </span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ __('teamspeak_info_name') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>{{ $serverdata['name'] }}<a href="#" class="beCopyText text-sm text-normal ml-1" title="Kopyala" data-content="{{ $serverdata['name'] }}"><i class="ri-clipboard-line"></i></a></span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ __('teamspeak_info_ping') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>{{ $serverdata['ping'] }}MS</span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ __('teamspeak_info_online_user') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>{{ $serverdata['onlineclients'] }} Kişi</span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ __('teamspeak_info_maximum_user') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>{{ $serverdata['maxclients'] }} Kişi</span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ __('teamspeak_info_percent_user') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>%{{ $serverdata['percentclient'] }}</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="card my-3">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-server-line"></i> {{ beGetLang('teamspeak_uptime') }}</span>
                </div>
            </div>
            <div class="card-content">
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ $serverdata['uptime'] }}</span>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <span>{{ __('teamspeak_info_created') }}:</span>
                    </div>
                    <div class="col-12 mt-1">
                        <span>{{ beSpecialTime($serverdata['created']) }}</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="card my-3">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-server-line"></i> {{ beGetLang('teamspeak_server_process') }}</span>
                </div>
            </div>
            <div class="card-content">
                <div class="row">
                    @if($serverdata['status'])
                    <div class="col-4 mb-2 row-stack">
                        <a href="#" class="btn btn-danger beCallRequestx" data-method="power_action" data-data="process=stop"><i class="ri-stop-circle-line"></i> {{ __('manage_stop') }}</a>
                    </div>
                    <div class="col-8 mb-2 row-stack">
                        <a href="#" class="btn btn-primary beCallRequestx" data-method="power_action" data-data="process=restart"><i class="ri-restart-line"></i> {{ __('manage_restart') }}</a>
                    </div>
                    @else
                    <div class="col-6 mb-2 row-stack">
                        <a href="#" class="btn btn-success beCallRequestx" data-method="power_action" data-data="process=start"><i class="ri-play-line"></i> {{ __('manage_start') }}</a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>