<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div>
                    <span class="card-title"><i class="ri-git-repository-line"></i> {{ __('teamspeak_menu_user') }}</span>
                </div>
            </div>
            <div class="card-content">
                <table class="btable">
                    <thead>
                        <tr>
                            <th>{{ __('teamspeak_user_nick') }}</th>
                            <th>{{ __('teamspeak_user_version') }}</th>
                            <th>{{ __('teamspeak_user_platform') }}</th>
                            <th>{{ __('teamspeak_user_ip') }}</th>
                            <th>{{ __('teamspeak_user_first_login') }}</th>
                            <th>{{ __('teamspeak_user_last_login') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($clientlist)
                        @foreach($clientlist as $client)
                        <tr>
                            <td>{{ $client['client_nickname'] }}</td>
                            <td>{{ $client['client_version'] }}</td>
                            <td>{{ $client['client_platform'] }}</td>
                            <td>{{ $client['connection_client_ip'] }}</td>
                            <td>{{ beSpecialTime($client['client_created']) }}</td>
                            <td>{{ beSpecialTime($client['client_lastconnected']) }}</td>
                            <td class="row-flex">
                                <a href="#" class="btn btn-warning btn-sm beCallRequestx" data-method="kick" data-data="clid={{ $client['clid'] }}">
                                    <i class="ri-eraser-line"></i>
                                    {{ __('teamspeak_user_kick') }}
                                </a>
                                <a href="#" class="btn btn-danger btn-sm ml-2 beCallRequestx" data-method="ban" data-data="clid={{ $client['clid'] }}">
                                    <i class="ri-forbid-line"></i>
                                    {{ __('teamspeak_user_ban') }}
                                </a>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="3">
                                <div class="beempty">
                                    <div>{{ __('teamspeak_user_empty') }}</div>
                                </div>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    var wait = false;
    $(".beCallRequestx").on("click",function(){
        if(!wait){
            wait = true;
            var item = $(this);
            var content = item.html();
            item.html('<span class="beSpinner"></span> Lütfen Bekleyiniz!');
            var method = item.data("method");
            var form = item.data("form");
            var data = item.data("data");
            var datacontent = "";
            if(form){
                datacontent = $("#"+form+"Form").serialize()+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            else{
                datacontent = data+"&action="+method+"&upid={{ $userproduct['upid'] }}";
            }
            $.ajax({
                url: "{{ beGetRoute('client.userproduct.userproduct.show.post') }}",
                type: "post",
                data: datacontent,
                dataType: "json",
                crossDomain: true,
                success: function(response){
                    wait = false;
                    item.html(content);
                    if(response.status){
                        $.Toast("Başarılı",response.message,"success");
                        if(response.refresh){
                            setTimeout(function(){
                                location.reload();
                            },1000);
                        }
                    }
                    else{
                        $.Toast("Bir Sorun Oluştu",response.message,"error");
                    }
                }
            });	
            return false;
        }
        else{
            $.Toast("Bir Sorun Oluştu","İşlem devam ediyor lütfen bekleyiniz","error");
        }
    });
</script>