@extend('clientarea.layout')
@section('title')Son Bir Adım Kaldı - {{ beGetConfig('sitename') }}@endsection
@section('content')
<style>
.payment-options {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 15px;
    border: 1px solid rgb(230 230 230);
    background: white;
    cursor: pointer;
    border-radius: 6px;
    margin-bottom: 15px;
}
.payment-options.active {
    border: 1px solid rgb(43 215 104)!important;
}
.payment-options .info {
    display: flex;
    margin-right: 20px;
}
.payment-options .info .logo {
    margin-right: 20px;
    padding-right: 20px;
    border-right: 1px solid rgb(230 230 230);
}
.payment-options .info .text span:first-child {
    font-weight: 600;
    margin-bottom: 6px;
    font-size: 16px;
}
.payment-options .info .text span:last-child {
    opacity: 0.5;
    font-size: 12px;
}
.payment-options .info .text span {
    display: block;
}
.payment-options .info img {
    width: 85px;
    height: 50px;
}
.payment-options .price {
    width: 8%;
    font-weight: 500;
    font-size: 18px;
}
.packets {
    background: rgba(102,112,147,.07);
    border-radius: 8px;
    display: inline-flex;
    padding: 7px 15px;
    width: 310px;
    margin: 15px 0;
    justify-content: space-between;
}
.packets > a {
    display: flex;
    padding: 4px;
    align-items: center;
    transition: .3s;
    width: 47%;
    font-size: 14px;
    color: #667093;
    background: #e3e3e3;
    border-radius: 8px;
    justify-content: center;
    padding: 10px;
}
.packets i {
    font-size: 18px;
    margin-right: 10px;
}
.packets > a.active {
    background: #fff;
    font-weight: 700;
    color: black;
}
.form-group:not(:first-child) {
    margin: 20px 0px;
}
.form-group label {
    color: #6c757d;
}
.input-select {
    display: flex;
    justify-content: space-between;
}
.input-select input {
    width: 70%!important;
}
.input-select select {
    width: 20%!important;
}
.sinfo-description {
    padding: 15px 20px;
    border-radius: 5px;
    background: var(--header-right);
    color: #fff;
    box-shadow: 0 0.125rem 0.25rem rgb(0 0 0 / 8%);
}
</style>
<div class="card">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-coupon-3-line"></i> Son Bir Adım Kaldı</span>
        </div>
    </div>
    <div class="card-content">
        <div class="row">
            <div class="col-12">
                <div class="row-flex row-center">
                    <div class="packets">
                        <a rel="nofollow noreferrer" title="Türkiye" alt="Türkiye" href="#" class="packets-item active" data-tab="individual">
                            <i class="ri-add-line"></i>
                            <span>Bireysel</span>
                        </a>
                        <a rel="nofollow noreferrer" title="Almanya" alt="Almanya" href="#" class="packets-item" data-tab="institutional">
                            <i class="ri-building-fill"></i>
                            <span>Kurumsal</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <form id="individualForm" method="post">
            <div class="row tab mb-3" id="individual" style="display: flex;">
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Adınız</label>
                        <input type="text" class="form-control" name="name" required="required">
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Soy Adınız</label>
                        <input type="text" class="form-control" name="surname" required="required">
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">TC Kimlik Numaranız</label>
                        <input type="text" class="form-control" name="tcno" required="required" maxlength="11">
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Doğum Tarihiniz</label>
                        <input type="date" class="form-control" name="birthdate" required="required">
                    </div>
                </div>
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">Ülke</label>
                        <select class="form-control" name="country">
                            @foreach($countries as $country)
                            <option value="{{ $country['acid'] }}"{{ $country['acid'] == $defcountry ? ' selected':'' }}>{{ $country['acname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">İl</label>
                        <select class="form-control" name="district" id="individualDistricte">
                            <option value="0">Seçiniz</option>
                            @foreach($districs as $distric)
                            <option value="{{ $distric['adid'] }}">{{ $distric['adname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">İlçe</label>
                        <select class="form-control" name="province" id="individualProvince">
                        </select>
                    </div>
                </div>
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Adresiniz</label>
                        <textarea class="form-control" name="address"></textarea>
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beCallRequest" data-form="individual" data-url="{{ beGetRoute('useridentity.insert.post') }}" data-data="&usertype=individual">Kaydet</a>
                </div>
            </div>
        </form>
        <form id="institutionalForm" method="post">
            <div class="row tab mb-3" id="institutional" style="display: none;">
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">Firma Ünvanı</label>
                        <input type="text" class="form-control" name="name" required="required">
                    </div>
                </div>
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">Vergi Numarası</label>
                        <input type="text" class="form-control" name="taxno" required="required">
                    </div>
                </div>
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">Vergi Dairesi</label>
                        <input type="text" class="form-control" name="taxadmin" required="required">
                    </div>
                </div>
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">Ülke</label>
                        <select class="form-control" name="country">
                            @foreach($countries as $country)
                            <option value="{{ $country['acid'] }}"{{ $country['acid'] == $defcountry ? ' selected':'' }}>{{ $country['acname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">İl</label>
                        <select class="form-control" name="district" id="institutionalDistrict">
                            <option value="0">Seçiniz</option>
                            @foreach($districs as $distric)
                            <option value="{{ $distric['adid'] }}">{{ $distric['adname'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-4 mb-3">
                    <div class="form-group">
                        <label for="#">İlçe</label>
                        <select class="form-control" name="province" id="institutionalProvince">
                        </select>
                    </div>
                </div>
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Adresiniz</label>
                        <textarea class="form-control" name="address"></textarea>
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beCallRequest" data-form="institutional" data-url="{{ beGetRoute('useridentity.insert.post') }}" data-data="&usertype=institutional">Kaydet</a>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    var type = "individual";
    $(".packets-item").on("click",function(){
        var tab = $(this).data("tab");
        $(".row.tab").hide();
        $(".packets-item.active").removeClass("active");
        $(this).addClass("active");
        $("#"+tab).css("display","flex");
        type = tab;
        return false;
    });
    $("select[name='country']").on("change",function(){
        var country = $(this).val();
        $.ajax({
            url: "{{ beGetRoute('useridentity.get.district.post') }}",
            type: "post",
            data: {country:country},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    var html = "";
                    $.each(response.districs, function( index, value ) {
                        html += '<option value="'+value.acid+'">'+value.acname+'</option>';
                    });
                    $("#"+type+"District").empty().append(html);
                }
                else{
                    toast("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
    });
    $("select[name='district']").on("change",function(){
        var district = $(this).val();
        $.ajax({
            url: "{{ beGetRoute('useridentity.get.province.post') }}",
            type: "post",
            data: {district:district},
            dataType: "json",
            crossDomain: true,
            success: function(response){
                if(response.status){
                    var html = "";
                    $.each(response.provinces, function( index, value ) {
                        html += '<option value="'+value.apid+'">'+value.apname+'</option>';
                    });
                    $("#"+type+"Province").empty().append(html);
                }
                else{
                    toast("Bir Hata Oluştu",response.message,"error");
                }
            }
        });	
    });
</script>
@endsection