@extend('clientarea.layout')
@section('title')Son Bir Adım Kaldı - {{ beGetConfig('sitename') }}@endsection
@section('content')
<style>
.payment-options {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 15px;
    border: 1px solid rgb(230 230 230);
    background: white;
    cursor: pointer;
    border-radius: 6px;
    margin-bottom: 15px;
}
.payment-options.active {
    border: 1px solid rgb(43 215 104)!important;
}
.payment-options .info {
    display: flex;
    margin-right: 20px;
}
.payment-options .info .logo {
    margin-right: 20px;
    padding-right: 20px;
    border-right: 1px solid rgb(230 230 230);
}
.payment-options .info .text span:first-child {
    font-weight: 600;
    margin-bottom: 6px;
    font-size: 16px;
}
.payment-options .info .text span:last-child {
    opacity: 0.5;
    font-size: 12px;
}
.payment-options .info .text span {
    display: block;
}
.payment-options .info img {
    width: 85px;
    height: 50px;
}
.payment-options .price {
    width: 8%;
    font-weight: 500;
    font-size: 18px;
}
.packets {
    background: rgba(102,112,147,.07);
    border-radius: 8px;
    display: inline-flex;
    padding: 7px 15px;
    width: 310px;
    margin: 15px 0;
    justify-content: space-between;
}
.packets > a {
    display: flex;
    padding: 4px;
    align-items: center;
    transition: .3s;
    width: 47%;
    font-size: 14px;
    color: #667093;
    background: #e3e3e3;
    border-radius: 8px;
    justify-content: center;
    padding: 10px;
}
.packets i {
    font-size: 18px;
    margin-right: 10px;
}
.packets > a.active {
    background: #fff;
    font-weight: 700;
    color: black;
}
.form-group:not(:first-child) {
    margin: 20px 0px;
}
.form-group label {
    color: #6c757d;
}
.input-select {
    display: flex;
    justify-content: space-between;
}
.input-select input {
    width: 70%!important;
}
.input-select select {
    width: 20%!important;
}
.sinfo-description {
    padding: 15px 20px;
    border-radius: 5px;
    background: var(--header-right);
    color: #fff;
    box-shadow: 0 0.125rem 0.25rem rgb(0 0 0 / 8%);
}
</style>
<div class="card">
    <div class="card-header">
        <div>
            <span class="card-title"><i class="ri-coupon-3-line"></i> Son Bir Adım Kaldı</span>
        </div>
    </div>
    <div class="card-content">
        @if($useridentity)
        @if($useridentity['uistatus'] == 0)
        <span class="text-normal">
        Hali hazırda zaten başvurunuz bulunuyor. Lütfen başrunuzun sonuçlanmasını bekleyiniz, eğer çok uzun süredir bu ekrandaysanız destek talebi oluşturunuz.
        </span>
        @else
        <span class="text-danger">
        Başvurunuz reddedilmiştir, durum hakkında bilgi almak için destek talebi oluşturmanız gerekmektedir.
        </span>
        @endif
        @else
        <form id="identityForm" method="post">
            <div class="row tab mb-3" style="display: flex;">
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Adınız</label>
                        <input type="text" class="form-control" name="name" required="required">
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="form-group">
                        <label for="#">Soy Adınız</label>
                        <input type="text" class="form-control" name="surname" required="required">
                    </div>
                </div>
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Kimlik Resminiz(Bir A4 kağıdına {{ beGetConfig('sitename') }} ve tarihi yazarak toplu olarak SELFIE şeklinde fotoğraf çekiniz)</label>
                        <input type="file" class="form-control" name="file" multiple>
                    </div>
                </div>
                <div class="col-12 mb-3">
                    <div class="form-group">
                        <label for="#">Adresiniz</label>
                        <textarea class="form-control" name="address"></textarea>
                    </div>
                </div>
                <div class="col-12 row-center row-flex">
                    <a href="#" class="btn btn-special beSendIdentity">Kaydet</a>
                </div>
            </div>
        </form>
        @endif
    </div>
</div>
<script>
    var aids = [];
    var waitfile = false;
    $(".beSendIdentity").on("click",function(){
        if(waitfile){
            $.Toast("Bir Sorun Oluştu","Lütfen işlemlerin tamamlanmasını bekleyiniz.","error");
        }
        waitfile = true;
        var formdata;
        var files = $("input[name='file']")[0].files;
        if(!files[0]){
            $.Toast("Bir Sorun Oluştu","{{ __('form_not_full') }}","error");
            return false;
        }
        for(var i = 0; i < files.length; i++){
            formdata = new FormData();
            formdata.append("file",files[i]);
            $.ajax({
                url: "{{ beGetRoute('client.file.upload') }}",
                type : "post",
                async: false,
                data : formdata,
                contentType : false,
                processData : false,
                dataType : "json",
                crossDomain: true,
                success:function(response){
                    waitfile = false;
                    if(response.status){
                        aids.push(response.aid);
                    }
                    else{
                        Swal.fire("Bir Hata Oluştu",response.message,"error");
                    }
                }
            });
        }
        if(aids){
            beClassRequest("{{ beGetRoute('useridentity.insert.other.post') }}",$("#identityForm").serialize()+"&aids="+(aids.join()));
        }
        return false;
    })
</script>
@endsection