<?php

use App\System\Basic\beRouter;
use App\System\Basic\beViewer;
use App\System\Basic\beCache;
use App\System\Basic\beConfigurator;
use App\System\Model\SettingModel;
use App\System\Vendor\beLanguage;
use App\System\Vendor\bePlugin;

function beGetConfigs($config = ""){
    if(empty($config)){
        $files = BE_APPPATH."config/*.php";
        foreach(glob($files,"*") as $file){
            require_once $file;
        }
    }
    else{
        $file = BE_APPPATH."config/{$config}.php";
        if(file_exists($file)){
            require_once $file;
        }
        else{
            echo "no";
        }
    }
}
function beFileExits($file = ""){
    if(file_exists(BE_ROOT.$file)){
        return true;
    }
    return false;
}
function bePrintPage($view){
    echo $view;
    exit;
}
function beLoadModule($name = ""){
    $controllers = BE_APPPATH."vendor/";
    $file = $controllers.$name;
    if(is_dir($file)){
        foreach(glob($file."/*.php") as $altfile){
            require_once $altfile;
        }
    }
    else{
        require_once $file.".php";
    }
}
function beGetRoute($name = "",$params = []){
    return beGetConfig("siteurl").beRouter::beGetRoute($name,$params);
}
function beGetConfig($name = ""){
    $config = beConfigurator::beGetConfig($name);
    if($config === false){
        global $be;
        if($be->settings[$name]){
            return $be->settings[$name];
        }
        $setting = SettingModel::beGetSettings($name);
        if($setting){
            $config = $setting[$name];
        }
    }
    return $config;
}
function beRunHook($name = "",$data = null){
    if($data){
        return bePlugin::beRunHook($name,$data);
    }
    else{
        bePlugin::beRunHook($name);
        return true;
    }
}
function beGetView($name = "",$params = []){
    return beViewer::beGetView($name,$params);
}
function beGetCache($name = ""){
    return beCache::beGetCache($name);
}
function beSetCache($name = "",$value){
    return beCache::beSetCache($name,$value);
}
function beCacheExits($name = ""){
    return beCache::beCacheExist($name);
}
function beGetLang($name,$words = []){
    $lang = beLanguage::beLang($name);
    if($words){
        foreach($words as $word => $value){
            $lang = str_replace("{".$word."}",$value,$lang);
        }
    }
    return $lang;
}
function __($name,$words = []){
    $lang = beLanguage::beLang($name);
    if($words){
        foreach($words as $word => $value){
            $lang = str_replace("{".$word."}",$value,$lang);
        }
    }
    return $lang;
}
function beCacheSpecial($cachename,$viewname,$time,$type = "view"){
    if(!beCache::beCacheExist($cachename."_info")){
        beCache::beSetCache($cachename."_info",json_encode([
            "cachetime" => BE_TIME+$time
        ]));
        if($type == "view"){
            $content = beGetView($viewname);
        }
        else{
            $content = $viewname;
        }
        beCache::beSetCache($cachename."_content",$content);
    }
    else{
        $page = json_decode(beCache::beGetCache($cachename."_info"),JSON_UNESCAPED_UNICODE);
        $content = beCache::beGetCache($cachename."_content");
        if($page["cachetime"] && BE_TIME > $page["cachetime"]){
            beCache::beDeleteCache([$cachename."_info",$cachename."_content"]);
        }
    }
    return $content;
}
function beError($subject,$message,$extra = []){
    beSetHeaderContent();
    $data = [
        "subject" => $subject,
        "message" => $message
    ];
    if($extra){
        $data = array_merge($data,$extra);
    }
    echo beGetView("error",["data" => $data]);
    exit;
}
function beConvertNumber($numbers){
   $readable = ["","B","M","T"];
   $index = 0;
   while($numbers > 1000){
      $numbers /= 1000;
      $index += 1;
   }
   return(round($numbers, 2)." ".$readable[$index]);
}
function beConvertSize($size){
    $units = ["B","KB","MB","GB","TB"];
    $power = $size > 0 ? floor(log($size,1024)):0;
    return number_format($size/pow(1024, $power),2,".",",")." ".$units[$power];
}
function bePaganation($activepage,$itemcount,$itemlink = "",$maxlimit = 0,$type = "admin"){
    $itemlimit = ($maxlimit > 0) ? $maxlimit:15;
    $pagecount = round($itemcount/$itemlimit);
    if(!$pagecount){
        $pagecount = 1;
    }
    if($itemcount-($pagecount*$itemlimit) > 0){
        $pagecount += 1;
    }
    if($activepage > $pagecount || $activepage < 1){
        $activepage = 1;
    }
    if($pagecount > 6){
        $golastpage = true;
    }
    if($pagecount > 5 && $activepage > 5){
        $gofirstpage = true;
        $startcount = $activepage-3;
        $endcount = $activepage+3;
        if($endcount > $pagecount){
            $endcount = $pagecount;
        }
    }
    if(!$startcount){
        $startcount = 1;
        $endcount = $pagecount > 6 ? 6:$pagecount;
    }
    $paganation = "";
    if($pagecount > 1){
        if($type == "admin"){
            $type = "";
        }
        else{
            $type = "-user";
        }
        $paganation = beGetView("paganation".$type,["itemlink" => $itemlink,"pagecount" => $pagecount,"activepage" => $activepage,"startcount" => $startcount,"endcount" => $endcount,"golastpage" => $golastpage,"gofirstpage" => $gofirstpage]);
    }
    return [
        "itemlimit" => $itemlimit,
        "pagecount" => $pagecount,
        "activepage" => $activepage,
        "itemstart" => $itemlimit*($activepage-1),
        "paganation" => $paganation
    ];
}
function beAjaxError($data){
    return json_encode(array_merge(["status" => false],$data),JSON_UNESCAPED_UNICODE);
}
function beAjaxSuccess($data){
    return json_encode(array_merge(["status" => true],$data),JSON_UNESCAPED_UNICODE);
}
function beEncryptData($text = "",$key = "beSystems"){
    return openssl_encrypt($text,"AES-128-CBC",$key);
}
function beDecryptData($text = "",$key = "beSystems"){
    return openssl_decrypt($text,"AES-128-CBC",$key);
}
?>