<?php

namespace App\System\Task;

use App\System\Basic\beModel;
use App\System\Vendor\beMail;
use \Exception;

class SendMailTask {
    public function run_task($task){
        $mails = beModel::beTable("be_mail as m")->beSelect("mid,msubject,mmessage,mtemplate,u.email")->beWhere("mstatus","0")->beJoin("INNER JOIN be_users as u ON u.uid = m.uid")->beLimit(5)->beOrder("mid","ASC")->beGetAll();
        $sendedmails = [];
        foreach($mails as $mail){
            $response = beMail::beSendMail($mail["email"],$mail["msubject"],$mail["mtemplate"] == 1 ? beMail::bePrepareMail($mail["mmessage"]):$mail["mmessage"]);
            if($response["status"]){
                $sendedmails[] = $mail["mid"];
            }
        }
        if($sendedmails){
            beModel::beUpdate(["mstatus" => 1],"be_mail")->beWhere("mid",$sendedmails,"IN")->beExecute();
        }
    }
}
?>