<?php

namespace App\System\Task;

use App\System\Model\SettingModel;
use App\System\Model\TicketModel;
use App\System\Vendor\beTicket;
use \Exception;

class TicketStatusTask {
    public function run_task($task){
        $settings = SettingModel::beGetSettings("automation_ticket_close,ticket_close_uid");
        if($settings["automation_ticket_close"] == 0){
            return;
        }

        $checktime = BE_TIME-($settings["automation_ticket_close"]*86400);
        $ticekts = TicketModel::beSelect("tid")->beWhere("tlastreply","admin")->beWhere("tstatus","active")->beWhere("tlastreplydateline",$checktime,"<")->beGetAll();
        foreach($ticekts as $ticket){
            $tid = $ticket["tid"];
            beTicket::beTicketPost([
                "tid" => $tid,
                "uid" => $settings["ticket_close_uid"],
                "message" => str_replace("{count}",$settings["automation_ticket_close"],"<p>Destek talebinize {count} gündür cevap vermediğiniz için talebiniz otomatik olarak sistem tarafından kapatılmıştır!</p>"),
                "files" => "[]",
                "ipaddress" => "0.0.0.0",
                "dateline" => BE_TIME
            ]);
            beTicket::beUpdateTicketStatus($tid,-1);
        }
    }
}

?>