<?php

    namespace App\System\Vendor;

    use App\System\Controller\ConnectionController;
    use App\System\Model\AuthModel;
    use App\System\Model\SettingModel;
    use App\System\Vendor\Basic\beCookie;

    class Auth {
        public static $instance = null,$user = [];
        public static function beIsUserLogged(){
            if(!self::$instance){
                self::beCheckUser();
            }
            return self::$user["uid"] ? true:false;
        }
        public static function beGetUser($uid = 0,$select = ""){
            if(!self::$instance){
                self::beCheckUser();
            }
            if(!$uid){
                return self::$user;
            }
            if(!$select){
                $select = "*";
            }
            if($uid == -1){
                $uid = 0;
            }
            $user = AuthModel::beWhere("uid",$uid)->beSelect($select)->beGet();
            return $user;
        }
        public static function beUserAddData($key,$data){
            self::$user[$key] = $data;
            return self::$user;
        }
        public static function beGetUserUID(){
            if(!self::$instance){
                self::beCheckUser();
            }
            return self::$user["uid"];
        }
        public static function beLoginUser($email = "",$password = "",$remember = true,$cookie = true){
            $user = AuthModel::beWhere("email",$email)->beSelect("uid,salt,password,loginkey,status")->beGet();
            if(!$user){
                return ["status" => false,"message" => "Belirtilen bilgilere ait kullanıcı bulunamadı!"];
            }
            if($user["status"] == -1){
                return ["status" => false,"message" => "Hesabınız askıya alınmış yada girişe izin verilmiyor!"];
            }
            $response = self::beCheckPassword($user["salt"],$password,$user["password"]);
            if(!$response["status"]){
                return ["status" => false,"message" => $response["message"],"uid" => $user["uid"]];
            }
            if($cookie){
                $exprire = -1;
                if(!$remember){
                    $exprire = BE_TIME+86400;
                }
                beCookie::beCreateCookie("be_user",$user["uid"]."_".$user["loginkey"],true,true,$exprire);
            }
            return ["status" => true,"message" => "Başarılı bir şekilde giriş yapıldı!","uid" => $user["uid"],"loginkey" => $user["loginkey"]];
        }
        public static function beCheckPassword($salt,$password,$dbpassword){
            global $be;
            $settings = $be->settings;
            $response = ConnectionController::beSendRequest([
                "method" => "passcheck",
                "data" => [
                    "salt" => $salt,
                    "password" => $password,
                    "dbpass" => $dbpassword,
                    "cid" => $settings["system_id"],
                    "ctoken" => $settings["system_token"],
                    "secret" => $settings["system_secret"]
                ]
            ]);
            if(!$response["status"]){
                return ["status" => false,"message" => "Belirtilen bilgilere ait kullanıcı bulunamadı!"];
            }
            return ["status" => true];
        }
        public static function beLogOut(){
            beCookie::beDeleteCookie("be_user");
        }
        public static function beCreateUser($data = []){
            global $be;
            $settings = $be->settings;
            $user = AuthModel::beWhere("email",$data["email"])->beSelect("uid")->beGet();
            if($user){
                return ["status" => false,"message" => "Böyle bir kullanıcı mevcut!"];
            }
            $salt = substr(md5(BE_TIME),0,16);
            $loginkey = md5($salt);
            $userdata = [
                "loginkey" => $loginkey,
                "name" => $data["name"],
                "surname" => $data["surname"],
                "email" => $data["email"],
                "usergroup" => $data["usergroup"] ?? 2,
                "regdate" => BE_TIME
            ];
            if($data["password"]){
                $response = ConnectionController::beSendRequest([
                    "method" => "passcreate",
                    "data" => [
                        "salt" => $salt,
                        "password" => $data["password"],
                        "cid" => $settings["system_id"],
                        "ctoken" => $settings["system_token"],
                        "secret" => $settings["system_secret"]
                    ]
                ]);
                if(!$response["status"]){
                    return ["status" => false,"message" => "Bir sistem hatası oluştu yönetici ile iletişme geçin!"];
                }
                $userdata["salt"] = $salt;
                $userdata["password"] = $response["password"];
            }
            if($data["extradata"]){
                $userdata = array_merge($userdata,$data["extradata"]);
            }
            $uid = AuthModel::beInsert($userdata);
            return [
                "status" => true,
                "salt" => $salt,
                "uid" => $uid,
                "loginkey" => $loginkey
            ];
        }
        public static function beUpdatePassword($uid,$password){
            $salt = substr(md5(BE_TIME),0,16);
            $loginkey = md5($salt);
            $response = self::beRequestPassword($salt,$password);
            if(!$response["status"]){
                return ["status" => false,"message" => "Bir sistem hatası oluştu yönetici ile iletişme geçin!"];
            }
            AuthModel::beUpdate([
                "password" => $response["password"],
                "salt" => $salt,
                "loginkey" => $loginkey
            ])->beWhere("uid",$uid)->beExecute();
            return ["status" => true,"loginkey" => $loginkey];
        }
        public static function beRequestPassword($salt,$password){
            global $be;
            $settings = $be->settings;
            $response = ConnectionController::beSendRequest([
                "method" => "passcreate",
                "data" => [
                    "salt" => $salt,
                    "password" => $password,
                    "cid" => $settings["system_id"],
                    "ctoken" => $settings["system_token"],
                    "secret" => $settings["system_secret"]
                ]
            ]);
            return $response;
        }
        public static function beCheckUser(){
            $cookie = $_COOKIE["be_user"];
            if(!$cookie){
                self::$user = self::beDefaultUser();
                return;
            }
            list($uid,$loginkey) = explode("_",$cookie);
            $user = AuthModel::beWhere("uid",$uid)->beWhere("loginkey",$loginkey)->beGet();
            if(!$user){
                self::$user = self::beDefaultUser();
            }
            else{
                self::$user = $user;
            }
            self::$instance = new self();
        }
        public static function beDefaultUser(){
            $settings = SettingModel::beGetSettings("system_language,system_currency");
            return [
                "uid" => 0,
                "usergroup" => 1,
                "theme" => "beclassic",
                "lid" => $settings["system_language"],
                "cid" => $settings["system_currency"]
            ];
        }
    }
?>