<?php

    namespace App\System\Vendor;
    use App\System\Basic\beModel;
    use App\System\Model\SettingGroupsModel;
    use App\System\Model\SettingModel;

    /*

    Eklentiler üzerinde komut fonksiyon çağırma
        bePlugin::beGetPlugin("usertype");
        if($identity["status"]){
            $useridentity = bePlugin::beRunPluginFunction("usertype","get_user_identity",["uid" => $uid]);
        }

    */
    class bePlugin {
        public static $beHooks = [],$bePlugins = [],$beQueque = [];
        public static function beLoadPlugins(){
            $path = BE_APPPATH."resources/plugins/";
            if(!is_dir($path)){
                echo "Belirtilen eklenti klasörü bulunamadı!";
                exit;
            }
            $mainfile = BE_APPPATH."resources/cache/plugins.json";
            $plugins = file_get_contents($mainfile);
            $plugins = json_decode($plugins,true);
            foreach($plugins as $pluginname => $data){
                if($data["plstatus"] == 0){
                    continue;
                }
                $file = $pluginname.".php";
                $filepath = $path.$file;
                if(!file_exists($filepath)){
                    return ["status" => false,"message" => "Eklenti dosyası bulunamadı lütfen sistemi kontrol edin 0xA1"];
                }
                $controllerName = "App\System\Plugin\\{$pluginname}";
                require_once $filepath;
                if(!class_exists($controllerName)){
                    echo "hata!";
                    exit;
                }
                $plugin = new $controllerName();
                self::$bePlugins[$pluginname] = [
                    "info" => $plugin->plugin_info(),
                    "plugin" => $plugin
                ];
                $hooks = $plugin->plugin_hooks();
                foreach($hooks as $name => $hook){
                    self::beAddHook($pluginname,$name,$hook);
                }
            }
        }
        public static function beActivePlugin($pluginname){
            $mainfile = BE_APPPATH."resources/cache/plugins.json";
            $plugins = file_get_contents($mainfile);
            $plugins = json_decode($plugins,true);
            if(!$plugins[$pluginname]){
                return ["status" => false,"message" => "Eklentiyi aktif edebilmek için önce kurmanız gerekiyor!"];
            }
            $path = BE_APPPATH."resources/plugins/";
            $filename = $pluginname.".php";
            $file = $path.$filename;
            if(!file_exists($file)){
                return ["status" => false,"message" => "Eklenti dosyası bulunamadı lütfen sistemi kontrol edin 0xA1"];
            }
            $controllerName = "App\System\Plugin\\{$pluginname}";
            require_once $file;
            if(!class_exists($controllerName)){
                echo "hata!";
                exit;
            }
            $plugin = new $controllerName();
            if(!method_exists($plugin,"plugin_active")){
                $plugins[$pluginname]["plstatus"] = 1;
                file_put_contents($mainfile,json_encode($plugins,JSON_UNESCAPED_UNICODE));
                return ["status" => true,"message" => "Başarılı bir şekilde eklenti aktif edildi!"];
            }
            $data = $plugin->plugin_active();
            if(!$data["status"]){
                return ["status" => false,"message" => $data["message"]];
            }
            if(!$data["message"]){
                $data["message"] = "Başarılı bir şekilde eklenti aktif edildi";
            }
            $plugins[$pluginname]["plstatus"] = 1;
            file_put_contents($mainfile,json_encode($plugins,JSON_UNESCAPED_UNICODE));
            return ["status" => true,"message" => $data["message"]];
        }
        public static function beDeactivePlugin($pluginname){
            $mainfile = BE_APPPATH."resources/cache/plugins.json";
            $plugins = file_get_contents($mainfile);
            $plugins = json_decode($plugins,true);
            if(!$plugins[$pluginname]){
                return ["status" => false,"message" => "Eklentiyi pasif yapabilmek için önce kurmanız gerekiyor!"];
            }
            $path = BE_APPPATH."resources/plugins/";
            $filename = $pluginname.".php";
            $file = $path.$filename;
            if(!file_exists($file)){
                return ["status" => false,"message" => "Eklenti dosyası bulunamadı lütfen sistemi kontrol edin 0xA1"];
            }
            $controllerName = "App\System\Plugin\\{$pluginname}";
            require_once $file;
            if(!class_exists($controllerName)){
                echo "hata!";
                exit;
            }
            $plugin = new $controllerName();
            if(!method_exists($plugin,"plugin_deactive")){
                $plugins[$pluginname]["plstatus"] = 0;
                file_put_contents($mainfile,json_encode($plugins,JSON_UNESCAPED_UNICODE));
                return ["status" => true,"message" => "Başarılı bir şekilde eklenti kapatıldı!"];
            }
            $data = $plugin->plugin_deactive();
            if(!$data["status"]){
                return ["status" => false,"message" => $data["message"]];
            }
            if(!$data["message"]){
                $data["message"] = "Başarılı bir şekilde eklenti kapatıldı";
            }
            $plugins[$pluginname]["plstatus"] = 0;
            file_put_contents($mainfile,json_encode($plugins,JSON_UNESCAPED_UNICODE));
            return ["status" => true,"message" => $data["message"]];
        }
        public static function beInstallPlugin($pluginname){
            $mainfile = BE_APPPATH."resources/cache/plugins.json";
            $plugins = file_get_contents($mainfile);
            $plugins = json_decode($plugins,true);
            if($plugins[$pluginname]){
                return ["status" => false,"message" => "Eklenti zaten kurulmuş gözüküyor!"];
            }
            $path = BE_APPPATH."resources/plugins/";
            $filename = $pluginname.".php";
            $file = $path.$filename;
            if(!file_exists($file)){
                return ["status" => false,"message" => "Eklenti dosyası bulunamadı lütfen sistemi kontrol edin 0xA1"];
            }
            $controllerName = "App\System\Plugin\\{$pluginname}";
            require_once $file;
            if(!class_exists($controllerName)){
                echo "hata!";
                exit;
            }
            $plugin = new $controllerName();
            if(!method_exists($plugin,"plugin_install")){
                $plugins[$pluginname] = [
                    "ploptions" => $response["data"] ?? [],
                    "plstatus" => 1,
                    "pldateline" => BE_TIME
                ];
                file_put_contents($mainfile,json_encode($plugins,JSON_UNESCAPED_UNICODE));
                return ["status" => true,"message" => "Başarılı bir şekilde eklenti kuruldu!"];
            }
            $response = $plugin->plugin_install();
            if(!$response["status"]){
                return ["status" => false,"error" => $response["message"]];
            }
            if(!$response["message"]){
                $response["message"] = "Başarılı bir şekilde eklenti kuruldu";
            }
            $plugins[$pluginname] = [
                "ploptions" => $response["data"] ?? [],
                "plstatus" => 1,
                "pldateline" => BE_TIME
            ];
            file_put_contents($mainfile,json_encode($plugins,JSON_UNESCAPED_UNICODE));
            return ["status" => true,"message" => $response["message"]];
        }
        public static function beRemovePlugin($pluginname){
            $mainfile = BE_APPPATH."resources/cache/plugins.json";
            $plugins = file_get_contents($mainfile);
            $plugins = json_decode($plugins,true);
            unset($plugins[$pluginname]);
            $path = BE_APPPATH."resources/plugins/";
            $filename = $pluginname.".php";
            $file = $path.$filename;
            if(!file_exists($file)){
                return ["status" => false,"message" => "Eklenti dosyası bulunamadı lütfen sistemi kontrol edin 0xA1"];
            }
            $controllerName = "App\System\Plugin\\{$pluginname}";
            require_once $file;
            if(!class_exists($controllerName)){
                echo "hata!";
                exit;
            }
            $plugin = new $controllerName();
            if(!method_exists($plugin,"plugin_remove")){
                unlink($file);
                file_put_contents($mainfile,json_encode($plugins,JSON_UNESCAPED_UNICODE));
                return ["status" => true,"message" => "Başarılı bir şekilde eklenti silindi!"];
            }
            $data = $plugin->plugin_remove();
            if(!$data["status"]){
                return ["status" => false,"error" => $data["message"]];
            }
            if(!$data["message"]){
                $data["message"] = "Başarılı bir şekilde eklenti silindi";
            }
            unlink($file);
            file_put_contents($mainfile,json_encode($plugins,JSON_UNESCAPED_UNICODE));
            return ["status" => true,"message" => $data["message"]];
        }
        public static function beAddHook($plugin,$name = "",$function){
            if(!self::$beQueque[$name]){
                self::$beQueque[$name] = 0;
            }
            self::$beHooks[$name][self::$beQueque[$name]] = [
                "plugin" => $plugin,
                "function" => $function
            ];
            self::$beQueque[$name] += 1;
            ksort(self::$beHooks[$name]);
        }
        public static function beRunHook($name = "",$data = null){
            $hooks = self::$beHooks[$name] ?? [];
            if(!$hooks){
                return $data;
            }
            $havedata = $data ? 1:0;
            foreach($hooks as $hook){
                $controllerName = "App\System\Plugin\\{$hook['plugin']}";
                $pluginhandler = new $controllerName();
                if($havedata){
                    $data = call_user_func([$pluginhandler,$hook["function"]],$data);
                }
                else{
                    call_user_func([$pluginhandler,$hook["function"]],[]);
                }
            }
            return $data;
        }
        public static function beGetPlugin($plugin){
            $plugin = self::$bePlugins[$plugin];
            if(!$plugin){
                return ["status" => false,"message" => "Eklenti aktif olmadığı veya bulunamadığı için işlem yapılamıyor"];
            }
            return ["status" => true,"plugin" => $plugin];
        }
        public static function beRunPluginFunction($pluginname,$function,$data = []){
            $plugin = self::$bePlugins[$pluginname];
            if(!$plugin){
                return ["status" => false,"message" => "Eklenti aktif olmadığı veya bulunamadığı için işlem yapılamıyor"];
            }
            return call_user_func([$plugin["plugin"],$pluginname."_".$function],$data);
        }
        public static function beCreateSettingGroup($code,$name,$description){
            $sgid = SettingGroupsModel::beInsert([
                "sgcode" => $code,
                "sgname" => $name,
                "sgdescription" => $description,
                "sgdateline" => BE_TIME
            ]);
            return $sgid;
        }
        public static function beCreateSetting($sgid,$code,$name,$description,$type,$value = "",$editable = "1"){
            $sid = SettingModel::beInsert([
                "sgid" => $sgid,
                "scode" => $code,
                "sname" => $name,
                "sdescription" => $description,
                "stype" => $type,
                "svalue" => $value,
                "seditable" => $editable,
                "sdateline" => BE_TIME
            ]);
            return $sid;
        }
    }
?>