<?php
    namespace App\System\Vendor;
    use App\System\Basic\beModel;
    use App\System\Model\SettingModel;
    use App\System\Model\UserInfoModel;

    class beSms {
        public static function beCreateSms($message,$priorty,$uid = 0){
            if($uid == 0){
                $user = Auth::beGetUser();
                $uid = $user["uid"];
            }
            $usid = beModel::beInsert([
                "uid" => $uid,
                "smessage" => $message,
                "spriorty" => strval($priorty),
                "sstatus" => $priorty == 2 ? "1":"0",
                "sdateline" => BE_TIME
            ],"be_sms");
            if($priorty == 2){
                $userinfo = UserInfoModel::beSelect("uidial,uiphone")->beWhere("uid",$uid)->beGet();
                if($userinfo["uiphone"]){
                    $response = self::beSendSms($userinfo["uidial"],$userinfo["uiphone"],$message,2);
                    if($response["status"] == false){
                        return ["success" => false,"message" => "Sms gönderilirken sistem tarafından bir sorun algılandı"];
                    }
                }
                else{
                    beModel::beInsert([
                        "uid" => $uid,
                        "sltitle" => "SMS Gönderim Hatası",
                        "slcontent" => "Kullanıcının telefon numarası bulunamadı!",
                        "sldata" => json_encode(["uid" => $uid],JSON_UNESCAPED_UNICODE),
                        "sldateline" => BE_TIME
                    ],"be_system_logs");
                    return ["success" => false,"message" => "Kullanıcının telefon numarası bulunamadı!"];
                }
            }
            return ["success" => true,"usid" => $usid];
        }
        public static function beSendSms($dial,$phone,$message){
            global $be;
            if(!$be->settings["system_sms_module"]){
                $setting = SettingModel::beSelect("scode,svalue")->beWhere("scode","system_sms_module")->beGet();
                $smsmodule = "";
                if($setting["svalue"]){ 
                    $smsmodule = $setting["svalue"];
                }
                $be->settings["system_sms_module"] = $smsmodule;
            }
            else{
                $smsmodule = $be->settings["system_sms_module"];
            }
            if($smsmodule){
                beModule::beLoadModule("sms.{$smsmodule}");
                bePlugin::beRunHook("sms_send_pre",["dial" => $dial,"phone" => $phone,"message" => $message]);
                $response = beModule::beRunModuleFunction($smsmodule,"sendmessage",["dial" => $dial,"phone" => $phone,"message" => $message]);
                if(!$response["status"]){
                    beModel::beInsert([
                        "uid" => 0,
                        "sltitle" => "SMS Gönderim Hatası",
                        "slcontent" => "SMS gönderillirken bir sorun oluştu: ".$response["message"],
                        "sldata" => json_encode(["phone" => $phone],JSON_UNESCAPED_UNICODE),
                        "sldateline" => BE_TIME
                    ],"be_system_logs");
                    return ["status" => false,"message" => $response["message"]];
                }
                bePlugin::beRunHook("sms_send_post",["dial" => $dial,"phone" => $phone,"message" => $message]);
                return ["status" => true];
            }
            else{
                return ["status" => false,"message" => "Sistem üzerinde SMS modülü bulunamadığı için SMS gönderilemedi!"];
            }
        }
    }
?>