<?php

use App\System\Basic\beModel;
use App\System\Basic\beRouter;
use App\System\Model\PageTranslationsModel;
use App\System\Vendor\Auth;
use App\System\Vendor\bePlugin;

global $be;

beRouter::beName("auth.")->beGroup(function(){
    beRouter::beRoute("/login","Auth@login_post","post")->beName("login.post");
    beRouter::beRoute("/register","Auth@register_post","post")->beName("register.post");
    beRouter::beRoute("/forget-password","Auth@forgetpassword_post","post")->beName("forgetpassword.post");
    beRouter::beRoute("/sifremi-degistir/{code}","Auth@changepassword")->beMatch("code","str")->beName("changepassword");
    beRouter::beRoute("/change-password","Auth@changepassword_post","post")->beName("changepassword.post");
    beRouter::beRoute("/cikis-yap","Auth@logout")->beName("logout");
});

beRouter::bePrefix("/musteri-paneli","client.")->beGroup(function(){
    global $be;
    beRouter::beRoute("/","Client@dashboard")->beName("dashboard")->beMiddleWare("Auth");
    beRouter::beRoute("/anasayfa","Client@dashboard")->beName("dashboard.alternative")->beMiddleWare("Auth");
    
    beRouter::beRoute("/banka-hesaplari","Client@banks")->beName("banks")->beMiddleWare("Auth");

    beRouter::beRoute("/duyurular","Announcement@all")->beName("announcement")->beMiddleWare("Auth");
    
    beRouter::beRoute("/kullanici-bilgileri","Client@userinfo")->beName("userinfo")->beMiddleWare("Auth");
    beRouter::beRoute("/kullanici-ayarlari","Client@settings")->beName("settings")->beMiddleWare("Auth");
    beRouter::beRoute("/sistem-ayarlari","Client@systemsettings")->beName("systemsettings")->beMiddleWare("Auth");
    beRouter::beRoute("/change-address","Client@address_post","post")->beName("change.address.post")->beMiddleWare("Auth");
    beRouter::beRoute("/change-password","Client@password_post","post")->beName("change.password.post")->beMiddleWare("Auth");
    beRouter::beRoute("/set-language","Client@setlanguage_post","post")->beName("set.language.post")->beMiddleWare("Auth");
    beRouter::beRoute("/systemsettings-save","Client@systemsettings_post","post")->beName("systemsettings.save.post")->beMiddleWare("Auth");
    beRouter::beRoute("/guvenlik-ayarlari","Client@security")->beName("security")->beMiddleWare("Auth");
    beRouter::beRoute("/bildirim/{aid}","Client@alert")->beName("alert")->beMatch("aid","id")->beMiddleWare("Auth");

    beRouter::beRoute("/destek-taleplerim","Ticket@tickets")->beName("ticket.tickets")->beMiddleWare("Auth");
    beRouter::beRoute("/destek/{tid}","Ticket@ticket")->beName("ticket.ticket")->beMatch("tid","id")->beMiddleWare("Auth");
    beRouter::beRoute("/newpost-post","Ticket@newpost_post","post")->beName("ticket.postticket.post")->beMiddleWare("Auth");
    beRouter::beRoute("/yeni-destek-talebi","Ticket@newticket")->beName("ticket.newticket")->beMiddleWare("Auth");
    beRouter::beRoute("/newticket-post","Ticket@newticket_post","post")->beName("ticket.newticket.post")->beMiddleWare("Auth");

    beRouter::beRoute("/faturalarim","Invoice@invoices")->beName("invoice.invoices")->beData("type",9)->beMiddleWare("Auth");
    beRouter::beRoute("/odenmis-faturalarim","Invoice@invoices")->beName("invoice.invoices.paid")->beData("type",1)->beMiddleWare("Auth");
    beRouter::beRoute("/odenmemis-faturalarim","Invoice@invoices")->beName("invoice.invoices.unpaid")->beData("type",0)->beMiddleWare("Auth");
    beRouter::beRoute("/kapatilmis-faturalarim","Invoice@invoices")->beName("invoice.invoices.canceled")->beData("type",-1)->beMiddleWare("Auth");
    
    beRouter::beRoute("/fatura/{iid}","Invoice@invoice")->beName("invoice.invoice")->beMatch("iid","id")->beMiddleWare("Auth");
    beRouter::beRoute("/invoice-pay","Invoice@pay_post","post")->beName("invoice.invoice.post")->beMiddleWare("Auth");
    beRouter::beRoute("/invoice-process","Invoice@process_post","post")->beName("invoice.process.post")->beMiddleWare("Auth");
    beRouter::beRoute("/fatura/ode/{iid}","Invoice@pay")->beName("invoice.pay")->beMatch("iid","id")->beMiddleWare("Auth");
    beRouter::beRoute("/fatura/basarili","Invoice@success")->beName("invoice.success")->beMiddleWare("Auth");
    beRouter::beRoute("/fatura/basarisiz","Invoice@error")->beName("invoice.error")->beMiddleWare("Auth");

    beRouter::beRoute("/sms-kayitlari","ClientLog@sms")->beName("log.sms")->beMiddleWare("Auth");
    beRouter::beRoute("/email-kayitlari","ClientLog@email")->beName("log.email")->beMiddleWare("Auth");
    beRouter::beRoute("/bildirim-kayitlari","ClientLog@alert")->beName("log.alert")->beMiddleWare("Auth");
    beRouter::beRoute("/kullanici-kayitlari","ClientLog@user")->beName("log.user")->beMiddleWare("Auth");
    beRouter::beRoute("/hizmet-kayitlari","ClientLog@product")->beName("log.product")->beMiddleWare("Auth");
    

    if($be->settings["system_localmoney"] == 1){
        beRouter::beRoute("/kredi-yukle","Invoice@money")->beName("invoice.money")->beMiddleWare("Auth");
        beRouter::beRoute("/deposit-money","Invoice@money_post","post")->beName("invoice.deposit.money.post")->beMiddleWare("Auth");
    }

    beRouter::beRoute("/hizmetlerim","UserProduct@userproducts")->beName("userproduct.userproducts")->beMiddleWare("Auth");
    beRouter::beRoute("/hizmet-goruntule/{upid}","UserProduct@show")->beName("userproduct.userproduct.show")->beMatch("upid","id")->beMiddleWare("Auth");
    beRouter::beRoute("/hizmet-goruntule/{upid}/{page}","UserProduct@show")->beName("userproduct.userproduct.show.page")->beMatch("upid","id")->beMatch("page","str")->beMiddleWare("Auth");
    beRouter::beRoute("/hizmet-yukselt/{upid}","UserProduct@upgrade")->beName("userproduct.userproduct.upgrade")->beMatch("upid","id")->beMiddleWare("Auth");
    beRouter::beRoute("/hizmet-iptali/{upid}","UserProduct@cancellation")->beName("userproduct.userproduct.cancellation")->beMatch("upid","id")->beMiddleWare("Auth");
    beRouter::beRoute("/show-process","UserProduct@show_post","post")->beName("userproduct.userproduct.show.post")->beMiddleWare("Auth");
    beRouter::beRoute("/userproduct-options","UserProduct@options_post","post")->beName("userproduct.options")->beMiddleWare("Auth");
    beRouter::beRoute("/userproduct-process","UserProduct@process_post","post")->beName("userproduct.process")->beMiddleWare("Auth");
    beRouter::beRoute("/userproduct-upgrade","UserProduct@upgrade_post","post")->beName("userproduct.upgrade.post")->beMiddleWare("Auth");
    beRouter::beRoute("/userproduct-cancel","UserProduct@cancel_post","post")->beName("userproduct.cancel.post")->beMiddleWare("Auth");
    beRouter::beRoute("/userproduct-cancel-delete","UserProduct@canceldelete_post","post")->beName("userproduct.cancel.delete.post")->beMiddleWare("Auth");
    beRouter::beRoute("/referans-programi","Referance@link")->beName("referance")->beMiddleWare("Auth");

    beRouter::beRoute("/file-upload","Upload@upload","post")->beName("file.upload")->beMiddleWare("Auth");
    beRouter::beRoute("/file-delete","Upload@delete","post")->beName("file.delete")->beMiddleWare("Auth");
});

beRouter::bePrefix(beGetConfig("admin_url"),"admin.")->beGroup(function(){
    beRouter::beRoute("/","Dashboard@admin")->beName("dashboard")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_dashboard"]]);
    beRouter::beRoute("/admin-search","Search@search_post","post")->beName("search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_dashboard"]]);
    beRouter::beRoute("/admin-note-save","Dashboard@notesave_post","post")->beName("note.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_dashboard_note_save"]]);

    beRouter::beRoute("/kullanicilar","User@list")->beName("user.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_list"]]);
    beRouter::beRoute("/kullanici-olutsur","User@add")->beName("user.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_add"]]);
    beRouter::beRoute("/kullanici/{uid}","User@show")->beName("user.show")->beMatch("uid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_show"]]);
    beRouter::beRoute("/user-add","User@add_post","post")->beName("user.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_add"]]);
    beRouter::beRoute("/user-save","User@save_post","post")->beName("user.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_edit"]]);
    beRouter::beRoute("/user-note-save","User@notesave_post","post")->beName("user.note.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_edit"]]);
    beRouter::beRoute("/user-name-save","User@namesave_post","post")->beName("user.name.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_edit"]]);
    beRouter::beRoute("/user-phone-save","User@phonesave_post","post")->beName("user.phone.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_edit"]]);
    beRouter::beRoute("/user-setting-save","User@settingsave_post","post")->beName("user.setting.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_edit"]]);
    beRouter::beRoute("/user-money-update","User@moneyupdate_post","post")->beName("user.money.update.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_edit"]]);
    beRouter::beRoute("/user-loginfromadmin","User@loginfromadmin_post","post")->beName("user.loginfromadmin.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_login"]]);
    beRouter::beRoute("/user-returntoadmin","User@returntoadmin")->beName("user.returntoadmin")->beMiddleWare(["Auth"]);
    beRouter::beRoute("/user-search","User@search_post","post")->beName("user.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_list"]]);
    beRouter::beRoute("/user-orders-search","User@searchorders_post","post")->beName("user.orders.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_show"]]);
    beRouter::beRoute("/user-logs-search","User@searchlogs_post","post")->beName("user.logs.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_show"]]);
    beRouter::beRoute("/user-find","User@userfind_post","post")->beName("user.find.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_list"]]);

    beRouter::beRoute("/kullanici-gruplari","UserGroup@list")->beName("user.group.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_group_list"]]);
    beRouter::beRoute("/kullanici-grubu/{ugid}","UserGroup@edit")->beName("user.group.edit")->beMatch("ugid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_group_edit"]]);
    beRouter::beRoute("/kullanici-grubu-olustur","UserGroup@add")->beName("user.group.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_group_add"]]);
    beRouter::beRoute("/usergroup-add","UserGroup@add_post","post")->beName("user.group.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_group_add"]]);
    beRouter::beRoute("/usergroup-edit","UserGroup@edit_post","post")->beName("user.group.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_group_edit"]]);
    beRouter::beRoute("/usergroup-delete","UserGroup@delete_post","post")->beName("user.group.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_group_delete"]]);

    beRouter::beRoute("/siparisler","Order@list")->beName("order.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_list"]]);
    beRouter::beRoute("/siparis-olustur","Order@add")->beName("order.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_add"]]);
    beRouter::beRoute("/siparis/{upid}","Order@show")->beName("order.show")->beMatch("upid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_show"]]);
    beRouter::beRoute("/order-add","Order@add_post","post")->beName("order.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_add"]]);
    beRouter::beRoute("/order-status-save","Order@status_post","post")->beName("order.status.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_status_edit"]]);
    beRouter::beRoute("/order-name-save","Order@namesave_post","post")->beName("order.name.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit"]]);
    beRouter::beRoute("/order-note-save","Order@notesave_post","post")->beName("order.note.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit"]]);
    beRouter::beRoute("/order-price-save","Order@pricesave_post","post")->beName("order.price.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_price"]]);
    beRouter::beRoute("/order-time-save","Order@timesave_post","post")->beName("order.time.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_time"]]);
    beRouter::beRoute("/order-invoice-create","Order@invoicecreate_post","post")->beName("order.invoice.create.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_create_invoice"]]);
    beRouter::beRoute("/order-options-info","Order@optionsinfo_post","post")->beName("order.options.info.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_option"]]);
    beRouter::beRoute("/order-options-save","Order@optionssave_post","post")->beName("order.options.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_option"]]);
    beRouter::beRoute("/order-automation","Order@automation_post","post")->beName("order.automation.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_automation"]]);
    beRouter::beRoute("/order-automation-save","Order@automationsave_post","post")->beName("order.automation.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_automation"]]);
    beRouter::beRoute("/order-automation-module","Order@automationmodule_post","post")->beName("order.automation.module.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_automation"]]);
    beRouter::beRoute("/order-find","Order@orderfind_post","post")->beName("order.find.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_list"]]);
    beRouter::beRoute("/order-extension-add","Order@extensionadd_post","post")->beName("order.extension.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_extension"]]);
    beRouter::beRoute("/order-extension-save","Order@extensionsave_post","post")->beName("order.extension.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_extension"]]);
    beRouter::beRoute("/order-extension-delete","Order@extensiondelete_post","post")->beName("order.extension.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_edit_extension"]]);
    beRouter::beRoute("/order-transfer","Order@transfer_post","post")->beName("order.transfer.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_transfer"]]);
    beRouter::beRoute("/order-logs-search","Order@searchorderlogs_post","post")->beName("order.logs.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_list"]]);
    beRouter::beRoute("/order-cancel","Order@cancel_post","post")->beName("order.cancel.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_status_edit"]]);
    beRouter::beRoute("/order-delete","Order@delete_post","post")->beName("order.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_delete"]]);
    beRouter::beRoute("/order-search","Order@search_post","post")->beName("order.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_order_list"]]);

    beRouter::beRoute("/urunler","Product@list")->beName("product.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_list"]]);
    beRouter::beRoute("/urun/{pid}","Product@show")->beName("product.show")->beMatch("pid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_edit"]]);
    beRouter::beRoute("/urun-kopyala/{pid}","Product@copy")->beName("product.copy")->beMatch("pid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_add"]]);
    beRouter::beRoute("/urun/ekle","Product@add")->beName("product.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_add"]]);
    beRouter::beRoute("/product-add","Product@add_post","post")->beName("product.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_add"]]);
    beRouter::beRoute("/product-copy","Product@copy_post","post")->beName("product.copy.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_add"]]);
    beRouter::beRoute("/product-delete","Product@delete_post","post")->beName("product.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_delete"]]);
    beRouter::beRoute("/product-info-save","Product@infosave_post","post")->beName("product.info.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_edit"]]);
    beRouter::beRoute("/product-option-save","Product@optionsave_post","post")->beName("product.option.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_edit"]]);
    beRouter::beRoute("/product-upgrade-save","Product@upgradesave_post","post")->beName("product.upgrade.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_edit"]]);
    beRouter::beRoute("/product-price-save","Product@pricesave_post","post")->beName("product.price.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_price_edit"]]);
    beRouter::beRoute("/product-period-get","Product@periodget_post","post")->beName("product.period.get.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_edit"]]);
    beRouter::beRoute("/product-addon-get","Product@addonget_post","post")->beName("product.addon.get.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_addon_edit"]]);
    beRouter::beRoute("/product-addon-save","Product@addonsave_post","post")->beName("product.addon.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_edit"]]);
    beRouter::beRoute("/product-automation-module-get","Product@productmoduleautomationget_post","post")->beName("product.automation.module.get.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_edit"]]);
    beRouter::beRoute("/product-automation-module","Product@automationmodule_post","post")->beName("product.automation.module.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_module_edit"]]);
    beRouter::beRoute("/product-automation-save","Product@automationsave_post","post")->beName("product.automation.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_module_edit"]]);
    beRouter::beRoute("/product-automation-delete","Product@automationdelete_post","post")->beName("product.automation.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_product_module_edit"]]);

    beRouter::beRoute("/kategoriler","Category@list")->beName("category.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_category_list"]]);
    beRouter::beRoute("/kategori/{pcid}","Category@edit")->beName("category.edit")->beMatch("pcid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_category_edit"]]);
    beRouter::beRoute("/kategori-ekle","Category@add")->beName("category.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_category_add"]]);
    beRouter::beRoute("/category-add","Category@add_post","post")->beName("category.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_category_add"]]);
    beRouter::beRoute("/category-edit","Category@edit_post","post")->beName("category.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_category_edit"]]);
    beRouter::beRoute("/category-render","Category@render_post","post")->beName("category.render.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_category_edit"]]);
    beRouter::beRoute("/category-delete","Category@delete_post","post")->beName("category.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_category_delete"]]);
    
    beRouter::beRoute("/cache-clear","Cache@clear_post","post")->beName("cache.clear.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_cache_clear"]]);
    beRouter::beRoute("/cache-clear-all","Cache@clearall_post","post")->beName("cache.clearall.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_cache_clear_all"]]);

    beRouter::beRoute("/menuler","Menu@list")->beName("menu.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_menu_list"]]);
    beRouter::beRoute("/menu/{mid}","Menu@edit")->beName("menu.edit")->beMatch("mid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_menu_edit"]]);
    beRouter::beRoute("/menu-ekle","Menu@add")->beName("menu.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_menu_add"]]);
    beRouter::beRoute("/menu-add","Menu@add_post","post")->beName("menu.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_menu_add"]]);
    beRouter::beRoute("/menu-edit","Menu@edit_post","post")->beName("menu.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_menu_edit"]]);
    beRouter::beRoute("/menu-delete","Menu@delete_post","post")->beName("menu.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_menu_delete"]]);
    beRouter::beRoute("/menu-search","Menu@search_post","post")->beName("menu.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_menu_list"]]);

    beRouter::beRoute("/diller","Language@list")->beName("language.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_list"]]);
    beRouter::beRoute("/dil-ekle","Language@add")->beName("language.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_add"]]);
    beRouter::beRoute("/dil-duzenle/{lid}","Language@edit")->beName("language.edit")->beMatch("lid","str")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_edit"]]);
    beRouter::beRoute("/dil-yazi-duzenle/{lid}","Language@edittext")->beName("language.edit.text")->beMatch("lid","str")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_edit"]]);
    beRouter::beRoute("/language-add","Language@add_post","post")->beName("language.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_add"]]);
    beRouter::beRoute("/language-edit-text","Language@edittext_post","post")->beName("language.edit.text.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_edit"]]);
    beRouter::beRoute("/language-edit","Language@edit_post","post")->beName("language.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_edit"]]);
    beRouter::beRoute("/language-status","Language@status_post","post")->beName("language.status.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_edit_status"]]);
    beRouter::beRoute("/language-delete","Language@delete_post","post")->beName("language.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_language_delete"]]);

    beRouter::beRoute("/para-birimleri","Currency@list")->beName("currency.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_currency_list"]]);
    beRouter::beRoute("/para-birimi-ekle","Currency@add")->beName("currency.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_currency_add"]]);
    beRouter::beRoute("/para-birimi-duzenle/{cid}","Currency@edit")->beName("currency.edit")->beMatch("cid","str")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_currency_edit"]]);
    beRouter::beRoute("/currency-add","Currency@add_post","post")->beName("currency.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_currency_add"]]);
    beRouter::beRoute("/currency-edit","Currency@edit_post","post")->beName("currency.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_currency_edit"]]);
    beRouter::beRoute("/currency-status","Currency@status_post","post")->beName("currency.status.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_currency_edit"]]);
    beRouter::beRoute("/currency-default","Currency@default_post","post")->beName("currency.default.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_currency_edit"]]);
    beRouter::beRoute("/currency-delete","Currency@delete_post","post")->beName("currency.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_currency_delete"]]);

    beRouter::beRoute("/mesaj-sablonlari","MessageTemplate@list")->beName("messagetemplate.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_message_template_list"]]);
    beRouter::beRoute("/mesaj-sablonu/{mtid}","MessageTemplate@edit")->beName("messagetemplate.edit")->beMatch("mtid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_message_template_edit"]]);
    beRouter::beRoute("/messagetemplate-edit","MessageTemplate@edit_post","post")->beName("messagetemplate.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_message_template_edit"]]);

    beRouter::beRoute("/eklentiler","Addon@list")->beName("addon.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_addon_list"]]);
    beRouter::beRoute("/eklenti/{paid}","Addon@show")->beName("addon.show")->beMatch("paid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_addon_edit"]]);
    beRouter::beRoute("/eklenti-ekle","Addon@add")->beName("addon.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_addon_add"]]);
    beRouter::beRoute("/addon-add","Addon@add_post","post")->beName("addon.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_addon_add"]]);
    beRouter::beRoute("/addon-edit","Addon@edit_post","post")->beName("addon.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_addon_edit"]]);
    beRouter::beRoute("/addon-module-edit","Addon@addonmoduleedit_post","post")->beName("addon.module.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_addon_edit"]]);
    beRouter::beRoute("/addon-delete","Addon@delete_post","post")->beName("addon.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_addon_delete"]]);
    beRouter::beRoute("/addon-search","Addon@search_post","post")->beName("addon.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_addon_list"]]);

    beRouter::beRoute("/sayfalar","Page@list")->beName("page.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_list"]]);
    beRouter::beRoute("/sayfa-ekle","Page@add")->beName("page.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_add"]]);
    beRouter::beRoute("/sayfa-duzenle/{pid}","Page@show")->beName("page.show")->beMatch("pid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_edit"]]);
    beRouter::beRoute("/page-add","Page@add_post","post")->beName("page.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_add"]]);
    beRouter::beRoute("/page-edit","Page@edit_post","post")->beName("page.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_edit"]]);
    beRouter::beRoute("/page-delete","Page@delete_post","post")->beName("page.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_delete"]]);
    beRouter::beRoute("/page-alt-delete","Page@deletealt_post","post")->beName("page.alt.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_delete"]]);
    beRouter::beRoute("/page-newarea","Page@newarea_post","post")->beName("page.newarea.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_edit"]]);
    beRouter::beRoute("/page-search","Page@search_post","post")->beName("page.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_page_list"]]);

    beRouter::beRoute("/faturalar","Invoice@list")->beName("invoice.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_list"]]);
    beRouter::beRoute("/fatura/{iid}","Invoice@show")->beName("invoice.show")->beMatch("iid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_show"]]);
    beRouter::beRoute("/fatura-olustur","Invoice@add")->beName("invoice.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_add"]]);
    beRouter::beRoute("/invoice-add","Invoice@add_post","post")->beName("invoice.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_add"]]);
    beRouter::beRoute("/invoice-item-add","Invoice@itemadd_post","post")->beName("invoice.item.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_content_edit"]]);
    beRouter::beRoute("/invoice-item-save","Invoice@itemsave_post","post")->beName("invoice.item.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_content_edit"]]);
    beRouter::beRoute("/invoice-item-delete","Invoice@itemdelete_post","post")->beName("invoice.item.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_content_edit"]]);
    beRouter::beRoute("/invoice-merge","Invoice@merge_post","post")->beName("invoice.merge.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_add"]]);
    beRouter::beRoute("/invoice-status-save","Invoice@status_post","post")->beName("invoice.status.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_status_edit"]]);
    beRouter::beRoute("/invoice-billstatus-save","Invoice@billstatus_post","post")->beName("invoice.billstatus.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_bill_edit"]]);
    beRouter::beRoute("/invoice-name-save","Invoice@namesave_post","post")->beName("invoice.name.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_edit"]]);
    beRouter::beRoute("/invoice-note-save","Invoice@notesave_post","post")->beName("invoice.note.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_edit"]]);
    beRouter::beRoute("/invoice-price-save","Invoice@pricesave_post","post")->beName("invoice.price.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_price_edit"]]);
    beRouter::beRoute("/invoice-time-save","Invoice@timesave_post","post")->beName("invoice.time.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_time_edit"]]);
    beRouter::beRoute("/invoice-delete","Invoice@delete_post","post")->beName("invoice.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_delete"]]);
    beRouter::beRoute("/invoice-search","Invoice@search_post","post")->beName("invoice.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_list"]]);

    beRouter::beRoute("/muhasebe","Accounting@list")->beName("accounting.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_accounting_list"]]);
    beRouter::beRoute("/muhasebe/periyodik-islemler","Accounting@periodiclist")->beName("accounting.periodic.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_accounting_periodic_list"]]);
    beRouter::beRoute("/muhasebe/banka-hesaplari","Accounting@bank_list")->beName("accounting.bank.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_bank_list"]]);
    beRouter::beRoute("/muhasebe/banka-ekle","Accounting@bank_add")->beName("accounting.bank.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_bank_add"]]);
    beRouter::beRoute("/muhasebe/banka-duzenle/{bid}","Accounting@bank_edit")->beName("accounting.bank.edit")->beMatch("bid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_bank_edit"]]);
    beRouter::beRoute("/accounting-bank-add","Accounting@bank_add_post","post")->beName("accounting.bank.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_bank_add"]]);
    beRouter::beRoute("/accounting-bank-edit","Accounting@bank_edit_post","post")->beName("accounting.bank.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_bank_edit"]]);
    beRouter::beRoute("/accounting-bank-delete","Accounting@bank_delete_post","post")->beName("accounting.bank.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_bank_delete"]]);
    beRouter::beRoute("/accounting-add","Accounting@add_post","post")->beName("accounting.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_accounting_add"]]);
    beRouter::beRoute("/accounting-periodic-add","Accounting@addperiodic_post","post")->beName("accounting.periodic.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_accounting_periodic_add"]]);
    beRouter::beRoute("/accounting-periodic-delete","Accounting@deleteperiodic_post","post")->beName("accounting.periodic.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_accounting_periodic_delete"]]);
    beRouter::beRoute("/accounting-search","Accounting@search_post","post")->beName("accounting.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_accounting_list"]]);

    beRouter::beRoute("/pazarlamalar","Marketing@list")->beName("marketing.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_marketing_list"]]);
    beRouter::beRoute("/pazarlama-mesaji","Marketing@messageadd")->beName("marketing.send.message")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_marketing_add_message"]]);
    beRouter::beRoute("/marketing-send-message","Marketing@sendmessage_post","post")->beName("marketing.message.send.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_marketing_add_message"]]);

    beRouter::beRoute("/kuponlar","Coupon@list")->beName("coupon.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_coupon_list"]]);
    beRouter::beRoute("/kupon/{cpid}","Coupon@edit")->beName("coupon.edit")->beMatch("cpid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_coupon_edit"]]);
    beRouter::beRoute("/kupon-ekle","Coupon@add")->beName("coupon.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_coupon_add"]]);
    beRouter::beRoute("/coupon-add","Coupon@add_post","post")->beName("coupon.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_coupon_add"]]);
    beRouter::beRoute("/coupon-edit","Coupon@edit_post","post")->beName("coupon.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_coupon_edit"]]);
    beRouter::beRoute("/coupon-delete","Coupon@delete_post","post")->beName("coupon.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_coupon_delete"]]);
    beRouter::beRoute("/coupon-search","Coupon@search_post","post")->beName("coupon.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_coupon_list"]]);

    beRouter::beRoute("/destek-talepleri","Ticket@list")->beName("ticket.list")->beData("status","all")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    beRouter::beRoute("/talep/{tid}","Ticket@show")->beName("ticket.show")->beMatch("tid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_show"]]);
    beRouter::beRoute("/talep-olustur","Ticket@add")->beName("ticket.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_add"]]);
    beRouter::beRoute("/ticket-add","Ticket@add_post","post")->beName("ticket.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_add"]]);
    beRouter::beRoute("/aktif-destek-talepleri","Ticket@list")->beName("ticket.list.active")->beData("status","active")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    beRouter::beRoute("/kapatilmis-destek-talepleri","Ticket@list")->beName("ticket.list.closed")->beData("status","closed")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    beRouter::beRoute("/islemdeki-destek-talepleri","Ticket@list")->beName("ticket.list.inprocess")->beData("status","inprocess")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    beRouter::beRoute("/ticket-status-save","Ticket@status_post","post")->beName("ticket.status.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_edit_status"]]);
    beRouter::beRoute("/ticket-depertment-save","Ticket@depertment_post","post")->beName("ticket.depertment.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_edit_depertment"]]);
    beRouter::beRoute("/ticket-admin-save","Ticket@admin_post","post")->beName("ticket.admin.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_edit_admin"]]);
    beRouter::beRoute("/ticket-newmesssage-send","Ticket@newmesssage_post","post")->beName("ticket.newmesssage.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_message_add"]]);
    beRouter::beRoute("/ticket-predefinedreply-get","Ticket@getpredefinedreply_post","post")->beName("ticket.predefinedreply.get.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_message_add"]]);
    beRouter::beRoute("/ticket-delete","Ticket@delete_post","post")->beName("ticket.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_delete"]]);
    beRouter::beRoute("/ticket-search","Ticket@search_post","post")->beName("ticket.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    beRouter::beRoute("/destek-departmanlari","Ticket@depertment_list")->beName("ticket.depertment.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_department_list"]]);
    beRouter::beRoute("/destek-departmani/{tdid}","Ticket@depertment_edit")->beName("ticket.depertment.edit")->beMatch("tdid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_department_edit"]]);
    beRouter::beRoute("/destek-departmani-ekle","Ticket@depertment_add")->beName("ticket.depertment.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_department_add"]]);
    beRouter::beRoute("/ticket-derpetment-add","Ticket@depertment_add_post","post")->beName("ticket.depertment.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_department_add"]]);
    beRouter::beRoute("/ticket-derpetment-edit","Ticket@depertment_edit_post","post")->beName("ticket.depertment.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_department_edit"]]);
    beRouter::beRoute("/ticket-derpetment-delete","Ticket@depertment_delete_post","post")->beName("ticket.depertment.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_department_delete"]]);
    beRouter::beRoute("/destek-hazir-cevap","Ticket@predefinedcategory_list")->beName("ticket.predefined.category.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_predefined_category_list"]]);
    beRouter::beRoute("/destek-hazir-cevap/{tpcid}","Ticket@predefinedcategory_edit")->beName("ticket.predefined.category.edit")->beMatch("tpcid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_predefined_category_edit"]]);
    beRouter::beRoute("/destek-hazir-cevap-ekle","Ticket@predefinedcategory_add")->beName("ticket.predefined.category.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_predefined_category_add"]]);
    beRouter::beRoute("/ticket-predefined-categories-add","Ticket@predefinedcategory_add_post","post")->beName("ticket.predefined.category.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_predefined_category_add"]]);
    beRouter::beRoute("/ticket-predefined-categories-edit","Ticket@predefinedcategory_edit_post","post")->beName("ticket.predefined.category.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_predefined_category_edit"]]);
    beRouter::beRoute("/ticket-predefined-categories-delete","Ticket@predefinedcategory_delete_post","post")->beName("ticket.predefined.category.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_predefined_category_delete"]]);
    beRouter::beRoute("/ticket-predefined-message-add","Ticket@predefinedreply_add_post","post")->beName("ticket.predefined.message.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_predefined_message_add"]]);
    beRouter::beRoute("/ticket-predefined-message-delete","Ticket@predefinedreply_delete_post","post")->beName("ticket.predefined.message.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_predefined_message_delete"]]);
    beRouter::beRoute("/talep-imza/{tasid}","Ticket@adminsignature_edit")->beName("ticket.adminsignature.edit")->beMatch("tasid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    beRouter::beRoute("/ticket-signature-add","Ticket@adminsignature_add_post","post")->beName("ticket.adminsignature.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    beRouter::beRoute("/ticket-signature-edit","Ticket@adminsignature_edit_post","post")->beName("ticket.adminsignature.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    beRouter::beRoute("/ticket-signature-delete","Ticket@adminsignature_delete_post","post")->beName("ticket.adminsignature.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_ticket_list"]]);
    
    beRouter::beRoute("/ayarlar","Setting@settinggroups")->beName("settings.settinggroups")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_list"]]);
    beRouter::beRoute("/ayar/{sgid}","Setting@settinggroup")->beName("settings.settinggroup.show")->beMatch("sgid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_group_list"]]);
    beRouter::beRoute("/settings-save","Setting@save_post","post")->beName("settings.save.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_edit"]]);
    beRouter::beRoute("/modul-ayarlari","Setting@module")->beName("settings.module")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_module_list"]]);
    beRouter::beRoute("/settings-module-set","Setting@module_set_post","post")->beName("settings.module.set.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_module_select"]]);
    beRouter::beRoute("/sunucu-ayarlari","Setting@server")->beName("settings.server")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_server_list"]]);
    beRouter::beRoute("/sunucu-ayarlari/sunucu-ekle","Setting@server_add")->beName("settings.server.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_server_add"]]);
    beRouter::beRoute("/sunucu-ayarlari/sunucu/{sid}","Setting@server_edit")->beName("settings.server.edit")->beMatch("sid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_server_edit"]]);
    beRouter::beRoute("/settings-server-add","Setting@server_add_post","post")->beName("settings.server.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_server_add"]]);
    beRouter::beRoute("/settings-server-edit","Setting@server_edit_post","post")->beName("settings.server.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_server_edit"]]);
    beRouter::beRoute("/settings-server-check","Setting@server_check_post","post")->beName("settings.server.check.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_setting_server_edit"]]);

    beRouter::beRoute("/gorevler","Task@list")->beName("task.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_task_list"]]);
    beRouter::beRoute("/gorev/{tid}","Task@edit")->beName("task.edit")->beMatch("tid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_task_edit"]]);
    beRouter::beRoute("/gorev-ekle","Task@add")->beName("task.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_task_add"]]);
    beRouter::beRoute("/task-add","Task@add_post","post")->beName("task.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_task_add"]]);
    beRouter::beRoute("/task-edit","Task@edit_post","post")->beName("task.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_task_edit"]]);
    beRouter::beRoute("/task-status","Task@status_post","post")->beName("task.status.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_task_edit"]]);
    beRouter::beRoute("/task-execute","Task@execute_post","post")->beName("task.execute.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_task_edit"]]);
    beRouter::beRoute("/task-delete","Task@delete_post","post")->beName("task.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_task_delete"]]);

    beRouter::beRoute("/temalar","Theme@list")->beName("theme.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_list"]]);
    beRouter::beRoute("/tema/{tid}","Theme@edit")->beName("theme.edit")->beMatch("tid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_edit"]]);
    beRouter::beRoute("/tema-ekle","Theme@add")->beName("theme.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_add"]]);
    beRouter::beRoute("/theme-add","Theme@add_post","post")->beName("theme.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_add"]]);
    beRouter::beRoute("/theme-edit","Theme@edit_post","post")->beName("theme.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_edit"]]);
    beRouter::beRoute("/theme-select","Theme@select_post","post")->beName("theme.select.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_select"]]);
    beRouter::beRoute("/theme-delete","Theme@delete_post","post")->beName("theme.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_delete"]]);
    beRouter::beRoute("/tema-sayfalari","Theme@page_list")->beName("theme.page.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_list"]]);
    beRouter::beRoute("/tema-sayfa-ekle","Theme@page_add")->beName("theme.page.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_add"]]);
    beRouter::beRoute("/tema-sayfa/{tpid}","Theme@page_edit")->beName("theme.page.edit")->beMatch("tpid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_edit"]]);
    beRouter::beRoute("/theme-page-add","Theme@pageadd_post","post")->beName("theme.page.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_add"]]);
    beRouter::beRoute("/theme-page-edit","Theme@pageedit_post","post")->beName("theme.page.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_edit"]]);
    beRouter::beRoute("/theme-page-delete","Theme@pagedelete_post","post")->beName("theme.page.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_theme_delete"]]);

    beRouter::beRoute("/dosyalar","File@list")->beName("file.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_file_list"]]);
    beRouter::beRoute("/dosya/{aid}","File@edit")->beName("file.edit")->beMatch("tid","id")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_file_edit"]]);
    beRouter::beRoute("/dosya-ekle","File@add")->beName("file.add")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_file_add"]]);
    beRouter::beRoute("/file-add","File@add_post","post")->beName("file.add.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_file_add"]]);
    beRouter::beRoute("/file-upload","File@upload_post","post")->beName("file.upload.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_file_add"]]);
    beRouter::beRoute("/file-edit","File@edit_post","post")->beName("file.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_file_edit"]]);
    beRouter::beRoute("/file-delete","File@delete_post","post")->beName("file.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_file_delete"]]);
    beRouter::beRoute("/file-search","File@search_post","post")->beName("file.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_file_list"]]);

    beRouter::beRoute("/kayitlar/sistem-kayitlari","Log@system")->beName("log.system")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_system_logs_list"]]);
    beRouter::beRoute("/kayitlar/modul-kayitlari","Log@module")->beName("log.module")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_module_logs_list"]]);
    beRouter::beRoute("/kayitlar/kullanici-kayitlari","Log@user")->beName("log.user")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_logs_list"]]);
    beRouter::beRoute("/kayitlar/kullanici-urunleri-kayitlari","Log@userproduct")->beName("log.userproduct")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_product_logs_list"]]);
    beRouter::beRoute("/log-search-system","Log@system_search_post","post")->beName("log.system.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_system_logs_list"]]);
    beRouter::beRoute("/log-delete-system","Log@system_delete_post","post")->beName("log.system.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_system_logs_delete"]]);
    beRouter::beRoute("/log-search-module","Log@module_search_post","post")->beName("log.module.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_module_logs_list"]]);
    beRouter::beRoute("/log-delete-module","Log@module_delete_post","post")->beName("log.module.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_module_logs_delete"]]);
    beRouter::beRoute("/log-search-user","Log@user_search_post","post")->beName("log.user.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_logs_list"]]);
    beRouter::beRoute("/log-delete-user","Log@user_delete_post","post")->beName("log.user.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_logs_delete"]]);
    beRouter::beRoute("/log-search-userproduct","Log@userproduct_search_post","post")->beName("log.userproduct.search.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_product_logs_list"]]);
    beRouter::beRoute("/log-delete-userproduct","Log@userproduct_delete_post","post")->beName("log.userproduct.delete.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_user_product_logs_delete"]]);

    beRouter::beRoute("/guncellemeler","Update@check")->beName("update")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_update_show"]]);
    beRouter::beRoute("/update","Update@update_post","post")->beName("update.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_update_make"]]);
    beRouter::beRoute("/lisans","License@show")->beName("license.show")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_update_show"]]);
    beRouter::beRoute("/license-edit","License@edit_post","post")->beName("license.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_update_make"]]);

    beRouter::beRoute("/lisans-bilgisi","Dashboard@lisanceinfo")->beName("lisanceinfo")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_lisance_show"]]);
    beRouter::beRoute("/api-edit","ApiSelect@edit_post","post")->beName("api.edit.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_lisance_show"]]);

    beRouter::beRoute("/uygulama-marketi","Application@list")->beName("application.list")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_market_list"]]);
    beRouter::beRoute("/uygulama/{slug}","Application@show")->beName("application.show")->beMatch("slug","str")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_market_list"]]);
    beRouter::beRoute("/application-installfiles","Application@installfiles_post","post")->beName("application.installfiles.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_invoice_list"]]);
    beRouter::beRoute("/yuklu-uygulamalar","Application@list_dowloaded")->beName("application.downloaded")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_list"]]);
    beRouter::beRoute("/application-action","Application@action_post","post")->beName("application.action.post")->beMiddleWare(["Auth","Admin" => ["permission" => "admin_plugin_list"]]);
});

beRouter::bePrefix("/api","api.")->beGroup(function(){
    beRouter::beRoute("/admin/{apiname}","ApiAdmin@method","post")->beName("admin")->beMatch("apiname","str");
    beRouter::beRoute("/client/{apiname}","ApiClient@method","post")->beName("client")->beMatch("apiname","str");
});

beRouter::beRoute("/robots.txt",function(){
    return file_get_contents(BE_ROOT."/robots.txt");
});

switch($be->settings["system_mode"]){
    case 0 :
        $user = Auth::beGetUser();
        $pagetranslations = beModel::beTable("be_pages_translations as pt")->beSelect("pt.ptcode,pt.ptslug")->beWhere("pt.lid",$user["lid"])->beWhere("p.tid",$be->settings["system_theme"])->beJoin("INNER JOIN be_pages as p ON p.pid = pt.pid")->beGetAll();
        foreach($pagetranslations as $pagetranslation){
            beRouter::beRoute($pagetranslation["ptslug"],"Page@page")->beName($pagetranslation["ptcode"]);
        }
        break;
    case 1 :
        $user = Auth::beGetUser();
        $pagetranslations = beModel::beTable("be_pages_translations as pt")->beSelect("pt.ptcode,pt.ptslug")->beWhere("pt.lid",$user["lid"])->beWhere("p.tid",$be->settings["system_theme"])->beWhere("p.ptype","system")->beJoin("INNER JOIN be_pages as p ON p.pid = pt.pid")->beGetAll();
        foreach($pagetranslations as $pagetranslation){
            beRouter::beRoute($pagetranslation["ptslug"],"Page@page")->beName($pagetranslation["ptcode"]);
        }
        beRouter::beRoute("/",function(){
            beRouter::beRedirect(beGetRoute("client.dashboard"));
            exit;
        });
        break;
}


beRouter::beRoute("/dosya/{slug}-{aid}","Upload@show")->beName("file.show")->beMatch("slug","str")->beMatch("aid","id");
beRouter::beRoute("/dosya/{aid}","Upload@showspecial")->beName("file.show.special")->beMatch("aid","id")->beMiddleWare("Auth");;

beRouter::bePrefix("/urun","product.")->beGroup(function(){
    beRouter::beRoute("/{slug}","Product@product")->beName("product")->beMatch("slug","str");
    beRouter::beRoute("/calculaterate","Product@rate_post","post")->beName("rate");
    beRouter::beRoute("/calculateprice","Product@price_post","post")->beName("price");
});

beRouter::beRoute("/payment/notification","Invoice@paymentcallback","post")->beName("invoice.payment.callback");
beRouter::beRoute("/payment/notificationpost","Invoice@paymentnotification","post")->beName("invoice.payment.notification");

beRouter::bePrefix("/sepet","cart.")->beGroup(function(){
    beRouter::beRoute("/goruntule","Cart@show")->beName("show");
    beRouter::beRoute("/get-cart","Cart@getcart_post","post")->beName("get.post");
    beRouter::beRoute("/setcountitem-cart","Cart@setcountitem_post","post")->beName("setcount.post");
    beRouter::beRoute("/additem-cart","Cart@additem_post","post")->beName("add.post");
    beRouter::beRoute("/removeitem-cart","Cart@removeitem_post","post")->beName("remove.post");
    beRouter::beRoute("/addretryitem-cart","Cart@addretryitem_post","post")->beName("addretry.post");
    beRouter::beRoute("/check-coupon","Cart@checkcoupon_post","post")->beName("checkcoupon.post");
    beRouter::beRoute("/agree-cart","Cart@agreecart_post","post")->beName("agree.post");
});

beRouter::beRoute("/sitemap.xml","SiteMap@main")->beName("sitemap");
beRouter::beRoute("/sitemap_{lcode}.xml","SiteMap@lang")->beName("sitemap.lang")->beMatch("lcode","str");
beRouter::beRoute("/sitemap_{lcode}/{type}.xml","SiteMap@langtype")->beName("sitemap.lang.type")->beMatch("lcode","str")->beMatch("type","str");

beRouter::beRoute("/kurulum","Install@install")->beName("install");
beRouter::beRoute("/install-post","Install@install_post","post")->beName("install.post");

bePlugin::beRunHook("routes_start");

?>