<?php

namespace App\System\Controller;

use App\System\Basic\beCache;
use App\System\Basic\beContoller;
use App\System\Basic\beModel;
use App\System\Basic\beRouter;
use App\System\Model\AuthModel;
use App\System\Model\TicketModel;
use App\System\Vendor\Auth;
use beVCenter;
use beVCenterTools;

class ApiAdminController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","method") -> "383a72cbdfb347a32aed56ce69f25c77" RANDOM
    public function method($method = ""){
        $method = strtolower($method);
        if(!method_exists($this,$method)){
            return beAjaxError(["message" => "Belirtilen fonksiyon bulunamadı lütfen apiyi kontrol ediniz!"]);
        }
        if($_GET["apitype"] == "json"){
            $data = json_decode(file_get_contents("php://input"));
            $_POST = $data;
        }
        /*$uid = $_POST["uid"];
        $key = $_POST["key"];*/
        if($_POST["apikey"] != "6dc84d32b62eacf40f184047c1c9e80c"){
            return beAjaxError(["message" => "Erişim izni bulunamadı! Şifrenizi değiştirdiyseniz Erişim Tokeni'ni güncellemeyi unutmayınız!"]);
        }
        $user = AuthModel::beSelect("uid")->beWhere("uid",1)->beGet();
        /*if(!$user["uid"]){
            return beAjaxError(["message" => "Erişim izni bulunamadı! Şifrenizi değiştirdiyseniz Erişim Tokeni'ni güncellemeyi unutmayınız!"]);
        }*/
        return $this->$method($user);
    }
    //@ioncube.dk beEncrypt("be_diyocp","account_info") -> "d6f5fcf72b74fdbb1455da44e3b5d553" RANDOM
    public function account_info($user){
        $userdata = Auth::beGetUser($user["uid"]);
        return beAjaxSuccess(["message" => "Kullanıcı sorgulaması başarılı","user" => $userdata]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","ticket_count") -> "cb1539c5160d2c0df2a89b839e1ef8c2" RANDOM
    public function ticket_count($user){
        $status = $_POST["status"];
        $lastreply = $_POST["lastreply"];
        $ticket_count = TicketModel::beSelect("COUNT(tid) as total");
        if($status && $status != "all"){
            $ticket_count = $ticket_count->beWhere("tstatus",$status);
        }
        if($lastreply){
            $ticket_count = $ticket_count->beWhere("tlastreply",$lastreply);
        }
        $ticket_count = $ticket_count->beGet()["total"];
        if(!$ticket_count){
            $ticket_count = 0;
        }
        return beAjaxSuccess(["message" => "Destek talebi adeti sorgulaması başarılı","count" => (int)$ticket_count]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","ticket_search") -> "29bd4ef473bbcc961e65deaa90d71950" RANDOM
    public function ticket_search($user){
        
    }
    //@ioncube.dk beEncrypt("be_diyocp","earnings") -> "bc673daac0eaa473e5190777a3af284d" RANDOM
    public function earnings($user){
        $earnings = json_decode(beCache::beGetCache("stats_times_prices"),true);
        return beAjaxSuccess(array_merge(["message" => "Kazanç sorgulaması başarılı"],$earnings));
    }
}