<?php

namespace App\System\Controller;
use App\System\Basic\beContoller;
use App\System\Vendor\beLanguage;
use App\System\Vendor\bePlugin;
use App\System\Vendor\beUpdate;

class ApplicationController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","list") -> "9101db8b3142404cffbb15d98d4e633a" RANDOM
    public function list(){
        beError("Ulaşılamadı","Uygulama marketi beta süresi içinde şuanlık aktif değildir!");exit;
        global $be;
        $settings = $be->settings;
        /*$response = ConnectionController::beSendRequestStore([
            "method" => "getapplications",
            "data" => [
                "cid" => $settings["system_id"],
                "ctoken" => $settings["system_token"],
                "secret" => $settings["system_secret"]
            ]
        ]);*/
        if(!$response["status"]){
            beError("Ulaşılamadı","Uygulamalar çekilirken bir sorun oluştu!");
        }
        $applications = $response["applications"];
        return beGetView("admin.application.list",["applications" => $applications,"types" => $this->types]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","list_dowloaded") -> "2886470751b94af9c5bacd9ad03770a0" RANDOM
    public function list_dowloaded(){
        $path = BE_APPPATH."resources/plugins";
        if(!is_dir($path)){
            echo "Eklenti klasörü bulunamadı lütfen kontrol edin!";
            exit;
        }
        $mainfile = BE_APPPATH."resources/cache/plugins.json";
        $pluginsjson = file_get_contents($mainfile);
        $pluginsjson = json_decode($pluginsjson,true);
        $checkdir = "{$path}/*.php";
        $plugins = [];
        foreach(glob($checkdir) as $file){
            $pluginname = str_replace($path."/","",$file); 
            $pluginname = str_replace(".php","",$pluginname); 
            $controllerName = "App\System\Plugin\\{$pluginname}";
            require_once $file;
            if(!class_exists($controllerName)){
                echo "Eklenti adı dosya adı ile uyuşmuyor !".$pluginname;
                exit;
            }
            $plugin = new $controllerName();
            $plugins[$pluginname] = $plugin->plugin_info();
            if($pluginsjson[$pluginname]){
                $plugins[$pluginname]["data"] = $pluginsjson[$pluginname];
                if(method_exists($plugin,"plugin_settings")){
                    $plugins[$pluginname]["settings"] = $plugin->plugin_settings();
                }
            }
        }
        return beGetView("admin.application.downloadedlist",["plugins" => $plugins]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","show") -> "7b4045693e59c662956fe59bb1b81dbc" RANDOM
    public function show($slug){
        beError("Ulaşılamadı","Uygulama marketi beta süresi içinde şuanlık aktif değildir!");exit;
        global $be;
        $settings = $be->settings;
        /*$response = ConnectionController::beSendRequestStore([
            "method" => "getapplication",
            "data" => [
                "slug" => $slug,
                "cid" => $settings["system_id"],
                "ctoken" => $settings["system_token"],
                "secret" => $settings["system_secret"]
            ]
        ]);*/
        if(!$response["status"]){
            beError("Ulaşılamadı","Belirtilen uygulamaya ulaşılamadı");
        }
        $userproduct = $be->settings["system_data"]["product"];
        $application = $response["application"];
        $hasapplications = $response["hasapplications"];
        $mainfile = BE_APPPATH."resources/cache/version.json";
        if(!file_exists($mainfile)){
            beError("Bir sorun oluştu!","Yerel sistem dosyası bulunamadı!");
        }
        $system = file_get_contents($mainfile);
        $system = json_decode($system,true);
        $build = $system["build"];
        $version = $system["version"];
        $applicationexits = file_exists(BE_APPPATH."resources/plugins/".$application["amainfile"].".php");
        return beGetView("admin.application.show",["application" => $application,"applicationexits" => $applicationexits,"hasapplications" => $hasapplications,"userproduct" => $userproduct,"build" => $build,"version" => $version,"types" => $this->types]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","installfiles_post") -> "95a58800d0f87c3fd1f13dda8c5d4427" RANDOM
    public function installfiles_post(){
        global $be;
        $settings = $be->settings;
        /*$response = ConnectionController::beSendRequestStore([
            "method" => "getapplication",
            "data" => [
                "type" => "download",
                "slug" => $_POST["slug"],
                "cid" => $settings["system_id"],
                "ctoken" => $settings["system_token"],
                "secret" => $settings["system_secret"]
            ]
        ]);*/
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        $application = $response["application"];
        $file = $application["afiles"];
        if(file_exists(BE_APPPATH."resources/plugins/".$application["amainfile"].".php")){
            return beAjaxError(["message" => "Belirtilen eklenti sizde zaten indirilmiş halde!"]);
        }
        $response = beUpdate::beApplyUpgrade($file,"module");
        if(!$response["status"]){
            return beAjaxError(["message" => $response["message"]]);
        }
        return beAjaxSuccess(["message" => "Başarılı bir şekilde modül kuruldu lütfen kurulumu tamamlayın","url" => beGetRoute("client.application.downloaded")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","action_post") -> "b2c0d9e9f947fa2d55471d65627b4625" RANDOM
    public function action_post(){
        beLanguage::beReadLang("usergroup");
        $plugin = $_POST["plugin"];
        $action = $_POST["action"];
        switch($action){
            case "install" :
                if(!beCheckPermission("admin_plugin_install",0)){
                    return beAjaxError(["message" => beGetLang("usergroup_permission_denied",["permission" => "admin_plugin_install"])]);
                }
                $response = bePlugin::beInstallPlugin($plugin);
                if(!$response["status"]){
                    return beAjaxError(["message" => $response["message"]]);
                }
                return beAjaxSuccess(["message" => $response["message"]]);
                break;
            case "active" :
                if(!beCheckPermission("admin_plugin_activate",0)){
                    return beAjaxError(["message" => beGetLang("usergroup_permission_denied",["permission" => "admin_plugin_activate"])]);
                }
                $response = bePlugin::beActivePlugin($plugin);
                if(!$response["status"]){
                    return beAjaxError(["message" => $response["message"]]);
                }
                return beAjaxSuccess(["message" => $response["message"]]);
                break;
            case "deactive" :
                if(!beCheckPermission("admin_plugin_deactivate",0)){
                    return beAjaxError(["message" => beGetLang("usergroup_permission_denied",["permission" => "admin_plugin_deactivate"])]);
                }
                $response = bePlugin::beDeactivePlugin($plugin);
                if(!$response["status"]){
                    return beAjaxError(["message" => $response["message"]]);
                }
                return beAjaxSuccess(["message" => $response["message"]]);
                break;
            case "remove" :
                if(!beCheckPermission("admin_plugin_delete",0)){
                    return beAjaxError(["message" => beGetLang("usergroup_permission_denied",["permission" => "admin_plugin_delete"])]);
                }
                $response = bePlugin::beRemovePlugin($plugin);
                if(!$response["status"]){
                    return beAjaxError(["message" => $response["message"]]);
                }
                return beAjaxSuccess(["message" => $response["message"]]);
                break;
        }
    }
}

?>