<?php

namespace App\System\Controller;

use App\System\Basic\beCache;
use App\System\Basic\beContoller;
use App\System\Model\AuthModel;
use App\System\Model\CouponModel;
use App\System\Model\CurrencyModel;
use App\System\Model\InvoiceModel;
use App\System\Model\LanguageModel;
use App\System\Model\ProductModel;
use App\System\Vendor\Auth;
use App\System\Vendor\beLanguage;

class CouponController extends beContoller {
    //@ioncube.dk beEncrypt("be_diyocp","list") -> "9101db8b3142404cffbb15d98d4e633a" RANDOM
    public function list(){
        $user = Auth::beGetUser();
        $languages = LanguageModel::beGetLanguages("lid,lname");
        $currencies = CurrencyModel::beGetCurrencies("cid,cname");
        $products = ProductModel::beSelect("be_products.pid,pt.pname")->beWhere("pt.lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGetAll();
        return beGetView("admin.coupon.list",["languages" => $languages,"currencies" => $currencies,"products" => $products]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","add") -> "693124c9e83f454f57d2e4f611fe1c9c" RANDOM
    public function add(){
        $user = Auth::beGetUser();
        $languages = LanguageModel::beGetLanguages("lid,lname");
        $currencies = CurrencyModel::beGetCurrencies("cid,cname");
        $products = ProductModel::beSelect("be_products.pid,pt.pname")->beWhere("pt.lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGetAll();
        return beGetView("admin.coupon.add",["languages" => $languages,"currencies" => $currencies,"products" => $products]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","add_post") -> "ffadff297f0a97a2330891c534e5ce93" RANDOM
    public function add_post(){
        beLanguage::beReadLang("coupon");
        beLanguage::beReadLang("currency");
        beLanguage::beReadLang("user");
        $uid = (int)$_POST["user"];
        if($uid == 0){
            $uid = -1;
        }
        $user = Auth::beGetUser($uid,"uid");
        if(!$user){
            return beAjaxError(["message" => beGetLang("user_not_found")]);
        }
        $lid = (int)$_POST["language"];
        $cid = (int)$_POST["currency"];
        $currencie = CurrencyModel::beGetCurrencies("cid",$cid);
        if(!$currencie){
            return beAjaxError(["message" => beGetLang("currency_not_found")]);
        }
        $name = $_POST["name"];
        $code = $_POST["code"];
        if(empty($name) || empty($code)){
            return beAjaxError(["message" => beGetLang("coupon_name_empty")]);
        }
        $discounttype = (int)$_POST["discounttype"];
        $discount = (double)$_POST["discount"];
        $minprice = (double)$_POST["minprice"];
        $maxprice = (double)$_POST["maxprice"];
        $itemcount = (int)$_POST["itemcount"];
        $limit = (int)$_POST["limit"];
        if(!in_array($discounttype,[1,2])){
            return beAjaxError(["message" => beGetLang("coupon_discount_type_not_found")]);
        }
        $products = $_POST["products"];
        $productlist = [];
        if($products[0] != 0){
            $allproducts = ProductModel::beSelect("pid")->beWhere("pid",$products,"IN")->beGetAll();
            foreach($allproducts as $allproduct){
                $productlist[] = (int)$allproduct["pid"];
            }
        }
        if(is_numeric($_POST["enddateline"])){
            $enddateline = (int)$_POST["enddateline"];
        }
        else{
            $enddateline = strtotime($_POST["enddateline"]);
        }
        if(!$enddateline){
            $enddateline = 0;
        }
        CouponModel::beInsert([
            "cid" => $currencie["cid"],
            "uid" => $user["uid"],
            "lid" => $lid,
            "cname" => $name,
            "ccode" => $code,
            "cdiscounttype" => $discounttype,
            "cdiscount" => $discount,
            "cproducts" => json_encode($productlist),
            "cminprice" => $minprice,
            "cmaxprice" => $maxprice,
            "citemcount" => $itemcount,
            "climit" => $limit,
            "cenddateline" => $enddateline,
            "cstatus" => "1",
            "cdateline" => BE_TIME,
        ]);
        return beAjaxSuccess(["message" => beGetLang("coupon_created"),"url" => beGetRoute("admin.coupon.list")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit") -> "ef2c86a2f570e9f43db63597a17bf569" RANDOM
    public function edit($cpid){
        beLanguage::beReadLang("coupon");
        $user = Auth::beGetUser();
        $coupon = CouponModel::beWhere("cpid",$cpid)->beGet();
        if(!$coupon){
            beError(beGetLang("coupon"),beGetLang("coupon_not_found"));
        }
        $languages = LanguageModel::beGetLanguages("lid,lname");
        $currencies = CurrencyModel::beGetCurrencies("cid,cname");
        $products = ProductModel::beSelect("be_products.pid,pt.pname")->beWhere("pt.lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGetAll();
        $searchuid = $coupon["uid"];
        if($searchuid == 0){
            $searchuid = -1;
        }
        $couponuser = Auth::beGetUser($searchuid,"name,surname,email");
        $coupon["usersearch"] = $couponuser["name"]." ".$couponuser["surname"]." # ".$couponuser["email"];
        return beGetView("admin.coupon.edit",["coupon" => $coupon,"languages" => $languages,"currencies" => $currencies,"products" => $products]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","edit_post") -> "612153cbfbd9f0b9015947cac84fe756" RANDOM
    public function edit_post(){
        beLanguage::beReadLang("coupon");
        beLanguage::beReadLang("currency");
        beLanguage::beReadLang("user");
        $cpid = (int)$_POST["cpid"];
        $coupon = CouponModel::beSelect("cpid")->beWhere("cpid",$cpid)->beGet();
        if(!$coupon){
            return beAjaxError(["message" => beGetLang("coupon_not_found")]);
        }
        $uid = (int)$_POST["user"];
        if($uid == 0){
            $uid = -1;
        }
        $user = Auth::beGetUser($uid,"uid");
        if(!$user){
            return beAjaxError(["message" => beGetLang("user_not_found")]);
        }
        $lid = (int)$_POST["language"];
        $cid = (int)$_POST["currency"];
        $currencie = CurrencyModel::beGetCurrencies("cid",$cid);
        if(!$currencie){
            return beAjaxError(["message" => beGetLang("currency_not_found")]);
        }
        $name = $_POST["name"];
        $code = $_POST["code"];
        if(empty($name) || empty($code)){
            return beAjaxError(["message" => beGetLang("coupon_name_empty")]);
        }
        $discounttype = (int)$_POST["discounttype"];
        $discount = (double)$_POST["discount"];
        $minprice = (double)$_POST["minprice"];
        $maxprice = (double)$_POST["maxprice"];
        $itemcount = (int)$_POST["itemcount"];
        $limit = (int)$_POST["limit"];
        if(!in_array($discounttype,[1,2])){
            return beAjaxError(["message" => beGetLang("coupon_discount_type_not_found")]);
        }
        $products = $_POST["products"];
        $productlist = [];
        if($products[0] != 0){
            $allproducts = ProductModel::beSelect("pid")->beWhere("pid",$products,"IN")->beGetAll();
            foreach($allproducts as $allproduct){
                $productlist[] = (int)$allproduct["pid"];
            }
        }
        if(is_numeric($_POST["enddateline"])){
            $enddateline = (int)$_POST["enddateline"];
        }
        else{
            $enddateline = strtotime($_POST["enddateline"]);
        }
        if(!$enddateline){
            $enddateline = 0;
        }
        CouponModel::beUpdate([
            "cid" => $currencie["cid"],
            "uid" => $user["uid"],
            "lid" => $lid,
            "cname" => $name,
            "ccode" => $code,
            "cdiscounttype" => $discounttype,
            "cdiscount" => $discount,
            "cproducts" => json_encode($productlist),
            "cminprice" => $minprice,
            "cmaxprice" => $maxprice,
            "citemcount" => $itemcount,
            "climit" => $limit,
            "cenddateline" => $enddateline,
        ])->beWhere("cpid",$coupon["cpid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("coupon_updated")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","delete_post") -> "f2e13f17daf43cb049e56f8ccb4e3d39" RANDOM
    public function delete_post(){
        beLanguage::beReadLang("coupon");
        $cpid = (int)$_POST["cpid"];
        $coupon = CouponModel::beSelect("cpid")->beWhere("cpid",$cpid)->beGet();
        if(!$coupon){
            return beAjaxError(["message" => beGetLang("coupon_not_found")]);
        }
        CouponModel::beDelete()->beWhere("cpid",$coupon["cpid"])->beExecute();
        return beAjaxSuccess(["message" => beGetLang("coupon_deleted")]);
    }
    //@ioncube.dk beEncrypt("be_diyocp","search_post") -> "86c60ec2ca926334438a4ae77fc2cdaa" RANDOM
    public function search_post(){
        $user = Auth::beGetUser();
        $sort = (int)$_POST["sort"];
        if(!$sort){
            $sort = 1;
        }
        $page = (int)$_POST["page"];
        if(!$page){
            $page = 1;
        }
        $name = $_POST["name"];
        $code = $_POST["code"];
        $username = $_POST["username"];
        $ordertype = $_POST["ordertype"];
        $lid = (int)$_POST["language"];
        $userid = 0;
        if($username){
            $userdata = explode(" ",$username);
            $namecount = count($userdata);
            switch($namecount){
                case 1 :
                    $userid = AuthModel::beSelect("uid")->beWhere("name",$userdata[0])->beGet()["uid"];
                    if(!$userid){
                        $userid = AuthModel::beSelect("uid")->beWhere("email",$userdata[0])->beGet()["uid"];
                    }
                    break;
                case 2 :
                    $userid = AuthModel::beSelect("uid")->beWhere("name",$userdata[0])->beWhere("surname",$userdata[1])->beGet()["uid"];
                    break;
                case 3 :
                    $userid = AuthModel::beSelect("uid")->beWhere("name",$userdata[0]." ".$userdata[1])->beWhere("surname",$userdata[2])->beGet()["uid"];
                    break;
            }
        }
        $uid = (int)$_POST["uid"];
        if($uid){
            $userid = $uid;
        }
        $itemsearch = CouponModel::beSelect("COUNT(cpid) as total");
        if($userid){
            $itemsearch = $itemsearch->beWhere("uid",$userid);
        }
        if($name){
            $itemsearch = $itemsearch->beWhere("cname",$name);
        }
        if($code){
            $itemsearch = $itemsearch->beWhere("ccode",$code);
        }
        if($lid){
            $itemsearch = $itemsearch->beWhere("lid",$lid);
        }
        $itemcount = (int)$itemsearch->beGet()["total"];
        $paganation = bePaganation($page,$itemcount,"");
        $items = CouponModel::beSelect("be_coupons.*,u.name,u.surname");
        if($userid){
            $items = $items->beWhere("be_coupons.uid",$userid);
        }
        if($name){
            $items = $items->beWhere("cname",$name);
        }
        if($code){
            $items = $items->beWhere("ccode",$code);
        }
        if($lid){
            $items = $items->beWhere("be_coupons.lid",$lid);
        }
        if($paganation["itemstart"] == 0){
            $items = $items->beLimit($paganation["itemlimit"]);
        }
        else{
            $items = $items->beLimit($paganation["itemstart"],$paganation["itemlimit"]);
        }
        switch($ordertype){
            case "use" :
                $orderkey = "cusage";
                break;
            default: 
                $orderkey = "cpid";
                break;
        }
        switch($sort){
            case 1 :
                $items = $items->beOrder($orderkey,"DESC");
                break;
            case 2 :
                $items = $items->beOrder($orderkey,"ASC");
                break;
        }
        $items = $items->beJoin("INNER JOIN be_users as u ON u.uid = be_coupons.uid")->beGetAll();
        $couponstatus = CouponModel::beGetCouponStatus();
        $coupontypes = CouponModel::beGetCouponTypes();
        $languages = LanguageModel::beGetLanguages("lid,lname");
        $productlist = [];
        foreach($items as $key => $item){
            $cproducts = json_decode($item["cproducts"],true);
            if($cproducts){
                $items[$key]["products"] = ProductModel::beSelect("be_products.pid,pt.pname")->beWhere("be_products.pid",$cproducts,"IN")->beWhere("pt.lid",$user["lid"])->beJoin("INNER JOIN be_product_translations as pt ON pt.pid = be_products.pid")->beGetAll();
            }
        }
        $itemhtml = beGetView("admin.coupon.listrows",["items" => $items,"couponstatus" => $couponstatus,"coupontypes" => $coupontypes,"languages" => $languages]);
        return beAjaxSuccess(["html" => $itemhtml,"paganation" => $paganation["paganation"],"itemcount" => $itemcount]);
    }
}

?>